@extends('layouts.app')
@section('content')

<section id="demos" class="bg-primary-darker position-relative pt-6 pb-2">
    <div class="container">
        <header class="w-md-75 w-lg-50 mx-auto text-center mb-8">
            <div class="mb-2">
                @if($user->avatar == NULL)
                <img class="rounded-circle" width="100" height="100" src="{{ url('dist/img/avatar/default_avatar.png') }}" alt="">
                @else
                <img class="rounded-circle" width="100" height="100" src="{{ url('dist/img/avatar/'.$user->avatar)}}" alt="">
                @endif
            </div>
            
            <h2 class="h3 text-white mb-3">{{ $user->name }}</h2>
            <p class="text-white mb-5">
                {{ $user->bio }}
            </p>
        </header>
        
        <!-- SVG BG -->
        <svg class="position-absolute bottom-0 left-0" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 1920 323" enable-background="new 0 0 1920 323" xml:space="preserve">
            <polygon fill="#ffffff" class="opacity_0_5" points="-0.5,322.5 -0.5,121.5 658.3,212.3 "></polygon>
            <polygon fill="#ffffff" class="opacity_1" points="-2,323 1920,323 1920,-1 "></polygon>
        </svg>
        <!-- End SVG BG -->
        
    </div>
</section>

<section class="duik-promo bg-light pt-4 pb-8">
    <div class="container duik-promo-container">
        <div class="row">
            <div class="col-lg-8">
                <div class="card mb-4">
                    <!-- Card Body -->
                    <div class="card-body">
                        <h3 class="mb-2">{{ __('app.text_20') }}</h3>
                        <form method="POST" action="{{ url('user/new-question') }}">
                            @csrf
                            <div class="input-group mb-2">
                                <input class="form-control form-control-lg @error('question') is-invalid @enderror" type="text" placeholder="{{ __('app.text_21') }}" value="{{ old('question') }}" name="question">
                                <div class="input-group-append">
                                    <span class="input-group-text">
                                        <i class="fas fa-question-circle"></i>
                                    </span>
                                </div>
                                
                                @error('question')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                            
                            <div class="custom-control custom-switch mb-2">
                                <input type="checkbox" class="custom-control-input" id="customSwitch1-1" name="private">
                                <label class="custom-control-label" for="customSwitch1-1">{{ __('app.text_22') }}</label>
                            </div>

                            <input type="hidden" name="sent_to" value="{{ $user->id }}">
                            <button class="btn btn-sm btn-secondary" type="submit"><i class="far fa-paper-plane"></i> {{ __('app.text_23') }}</button>
                        </form>
                    </div>
                    <!-- End Card Body -->
                </div>
                
                @forelse($items as $quest)
                <!-- start items -->
                @include('layouts.items')
                <!-- end items -->
                @empty
                <div class="card p-6 border-0 shadow text-center">
                    <div class="card-header border-0"><i class="fas fa-glass-cheers text-muted fa-6x"></i></div>
                    <div class="card-body pt-0">
                        <h4 class="h5">{{ __('app.text_23_1') }}</h4>
                    </div>
                </div>
                @endforelse
                {{ $items->onEachSide(1)->links() }}
            </div>
            
            <div class="col-lg-4">
                <div class="duik-icon-block rounded bg-light">
                    <div class="row no-gutters">
                        <div class="col-md border-bottom border-md-bottom-0">
                            <div class="p-4">
                                <i class="fas fa-heart fa-3x text-danger mb-2"></i>
                                <h4 class="h5 mb-0">{{ App\Likes::where('sent_to', $user->id)->count() }}</h4>
                            </div>
                        </div>
                        <div class="col-md">
                            <div class="p-4">
                                <i class="fas fa-question-circle fa-3x text-success mb-2"></i>
                                <h4 class="h5 mb-0">{{ App\Questions::where('sent_to', $user->id)->where('replied', 1)->count() }}</h4>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- ads space -->
                @if(!App\Settings::first()->adv_3 == NULL)
                    @if(App\Advertisements::find(App\Settings::first()->adv_3) == true)
                        <div class="p-8 mt-6 mb-4 shadow">
                            <div class="text-center text-muted">
                                <p>{!! App\Advertisements::find(App\Settings::first()->adv_3)->adv !!}</p>
                            </div>
                        </div>
                    @endif 
                @endif
                
                <div class="mt-4 d-none d-sm-block">
                <hr />
                <!-- Links -->
                <ul class="list-unstyled">
                    @php
                    $pages = App\Page::where('status', 1)->get()
                    @endphp
                    @forelse($pages as $page)
                    <li class="mb-3"><a class="text-muted" href="{{ url('page/'.$page->slug) }}">{{ $page->title }}</a></li>
                    @empty
                    <p class="text-muted">
                        There are no pages.
                    </p>
                    @endforelse
                    <li class="mb-3"><a class="text-muted" href="{{ route('contacts') }}">{{ __('app.text_8') }}</a></li>
                </ul>
                <!-- End Links -->
            </div>
                
            </div>
        </div>
    </div>
</section>
@endsection