<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Auth\Middleware\Authenticate;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Auth::routes(['verify' => true]);
Route::get('/', 'HomeController@index')->name('index');
Route::get('inbox', 'HomeController@inbox')->middleware('auth');
Route::get('question/{id}', 'HomeController@show_question', function ($id) {
    return App\Questions::findOrFail($id);
});

// Search
Route::get('search', 'HomeController@search')->name('search');
// Page
Route::get('page/{slug}', 'HomeController@page')->name('page');
// Contacts
Route::get('contacts', 'HomeController@contacts')->name('contacts');
Route::post('contacts', 'HomeController@postContacts')->name('postContacts');
//
//
/////
//////////
//////////
////
//
// Google Login
Route::get('auth/google', 'Auth\LoginController@redirectToProvider');
Route::get('callback', 'Auth\LoginController@handleProviderCallback');
// Facebook Login
Route::get('auth/facebook', 'Auth\LoginController@redirectToFacebook');
Route::get('auth/facebook/callback', 'Auth\LoginController@handleFacebookCallback'); 
// Twitter Login
Route::get('auth/twitter', 'Auth\LoginController@redirectToTwitter');
Route::get('auth/twitter/callback', 'Auth\LoginController@TwitterCallback');
////
//////////
////

// This should be under 'auth' middleware group
Route::get('mark-as-read', 'HomeController@markNotification')->name('markNotification');
// Like Or Dislike
Route::post('save-like', 'HomeController@save_like')->middleware('auth');

// User 
Route::get('user/account', 'HomeController@edit_user')->middleware('auth');
Route::get('user/confirm/delete_account', 'HomeController@delete_account')->middleware('auth');
Route::post('user/account', 'HomeController@store_edit_user')->middleware('verified');
Route::get('user/delete/avatar', 'HomeController@delete_avatar')->middleware('verified');
Route::get('@{username}', 'HomeController@user')->name('user');
Route::post('user/new-question', 'HomeController@new_question')->middleware('verified');;
Route::post('user/answer-the-question', 'HomeController@answer_the_question')->middleware('verified');
Route::get('user/bulk-delete-questions', 'HomeController@bulk_delete_questions')->middleware('verified');
Route::get('user/delete-question/{id}', 'HomeController@delete_question')->middleware('verified');
Route::get('user/delete-answer/{id}', 'HomeController@delete_answer')->middleware('verified');
Route::post('report', 'HomeController@reportQA')->name('report')->middleware('verified');
Route::get('user/new-random-question', 'HomeController@new_random_question')->name('new_random_question')->middleware('auth');

// route admin
Route::get('admin', 'Admin@index')->middleware('role:admin');

// route admin/users
Route::get('admin/users', 'Admin@users')->middleware('role:admin');
Route::get('admin/user/delete/{id}', 'Admin@delete_user')->middleware('role:admin');
Route::get('admin/user/add', 'Admin@add_user')->middleware('role:admin');
Route::post('admin/user/add', 'Admin@store_user')->middleware('role:admin');
Route::get('admin/user/edit/{id}', 'Admin@edit_user')->middleware('role:admin');
Route::post('admin/user/edit/{id}', 'Admin@store_edit_user')->middleware('role:admin');
Route::get('admin/user/confirm/{id}', 'Admin@confirm')->middleware('role:admin');

// route admin/pages
Route::get('admin/pages', 'Admin@pages')->middleware('role:admin');
Route::get('admin/page/delete/{id}', 'Admin@delete_page')->middleware('role:admin');
Route::get('admin/page/add', 'Admin@add_page')->middleware('role:admin');
Route::post('admin/page/add', 'Admin@store_page')->middleware('role:admin');
Route::get('admin/page/edit/{id}', 'Admin@edit_page')->middleware('role:admin');
Route::post('admin/page/edit/{id}', 'Admin@store_edit_page')->middleware('role:admin');

// route admin/questions
Route::get('admin/questions', 'Admin@questions')->middleware('role:admin');
Route::get('admin/question/delete/{id}', 'Admin@delete_question')->middleware('role:admin');
// route admin/answers
Route::get('admin/answers', 'Admin@answers')->middleware('role:admin');
Route::get('admin/answer/delete/{id}', 'Admin@delete_answer')->middleware('role:admin');
// route admin/fake_questions
Route::get('admin/fake_questions', 'Admin@fake_questions')->middleware('role:admin');
Route::post('admin/fake_questions', 'Admin@new_fake_question')->middleware('role:admin');
Route::get('admin/fake/question/delete/{id}', 'Admin@delete_fake_question')->middleware('role:admin');

// route admin/reports
Route::get('admin/reports', 'Admin@reports')->middleware('role:admin');
Route::get('admin/report/delete/{id}', 'Admin@delete_report')->middleware('role:admin');

// route admin/advertisements
Route::get('/admin/advertisements', 'Admin@advertisements')->middleware('role:admin');
Route::get('/admin/adv/delete/{id}', 'Admin@delete_adv')->middleware('role:admin');
Route::get('/admin/adv/edit/{id}', 'Admin@edit_adv')->middleware('role:admin');
Route::post('/admin/adv/edit/{id}', 'Admin@store_edit_adv')->middleware('role:admin');
Route::get('/admin/adv/add', 'Admin@add_adv')->middleware('role:admin');
Route::post('/admin/adv/add', 'Admin@store_adv')->middleware('role:admin');

// route admin/settings
Route::get('admin/settings', 'Admin@settings')->middleware('role:admin');
Route::post('admin/settings', 'Admin@update_settings')->middleware('role:admin');
Route::get('admin/settings/delete_logo', 'Admin@delete_logo')->middleware('role:admin');

Route::get('/clear-cache', function() {
    Artisan::call('cache:clear');
    return "Cache is cleared";
});