
<?php $__env->startSection('content'); ?>
<!-- Page title -->
<div class="page-header">
    <div class="row align-items-center">
        <div class="col-auto">
            <!-- Page pre-title -->
            <h2 class="page-title">
                Payments
            </h2>
        </div>
    </div>
</div>
<div class="row row-deck row-cards">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Payments list</h3>
            </div>
            <div class="table-responsive">
                <table class="table card-table table-vcenter text-nowrap datatable">
                    <thead>
                        <tr>
                            <th class="w-1">ID</th>
                            <th>Payment ID</th>
                            <th>User</th>
                            <th>Payer Email</th>
                            <th>Amount</th>
                            <th>Status</th>
                            <th>Created at</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <span class="text-muted">
                                    <?php echo e($item->id); ?>

                                </span>
                            </td>
                            <td class="strong">
                                <small><?php echo e($item->payment_id); ?></small>
                            </td>
                            <td>
                                <small><?php echo e(App\User::find($item->payer_id)->name); ?></small>
                            </td>
                            <td>
                                <small><?php echo e($item->payer_email); ?></small>
                            </td>
                            <td class="strong">
                                <?php echo e($item->amount); ?> <?php echo e($item->currency); ?>

                            </td>
                            <td>
                                <span class="<?php if($item->payment_status == 'approved'): ?>text-green <?php else: ?> text-danger <?php endif; ?>">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z"></path><path d="M5 12l5 5l10 -10"></path></svg>
                                </span>
                            </td>
                            <td>
                                <small><?php echo e($item->created_at); ?></small>
                            </td>
                            <td>
                                <div class="btn-list">
                                    <a href="<?php echo e(url('admin/payment/delete/'.$item->id.'/'.$item->payer_id)); ?>" 
                                       onclick="return confirm('This action is final, are you sure?');" 
                                       class="btn btn-danger btn-sm btn-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-md" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z"></path><line x1="4" y1="7" x2="20" y2="7"></line><line x1="10" y1="11" x2="10" y2="17"></line><line x1="14" y1="11" x2="14" y2="17"></line><path d="M5 7l1 12a2 2 0 0 0 2 2h8a2 2 0 0 0 2 -2l1 -12"></path><path d="M9 7v-3a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v3"></path></svg>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td><?php echo e(__('admin.no_results')); ?></td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            
            <div class="card-footer d-flex align-items-center">
                <p class="m-0 text-muted">
                    Showing <?php echo e($payments->currentPage()); ?> page of <?php echo e($payments->total()); ?> entries
                </p>
                <ul class="pagination m-0 ml-auto">
                    <?php echo e($payments->links()); ?> 
                </ul>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp-1\htdocs\askyou\resources\views/admin/payments/index.blade.php ENDPATH**/ ?>