<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="<?php echo e(App\Settings::first()->dir); ?>">
    <head>
        
        <?php if(!App\Settings::first()->analytics == null): ?>
        <!-- Global site tag (gtag.js) - Google Analytics -->
        <script async src="https://www.googletagmanager.com/gtag/js?id=UA-<?php echo e(App\Settings::first()->analytics); ?>"></script>
        <script>
            window.dataLayer = window.dataLayer || [];
            function gtag(){dataLayer.push(arguments);}
            gtag('js', new Date());
            
            gtag('config', 'UA-<?php echo e(App\Settings::first()->analytics); ?>');
        </script>
        <?php endif; ?>
        
        <meta charset="utf-8"/>
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta http-equiv="X-UA-Compatible" content="ie=edge"/>
        <title><?php echo e($title); ?></title>
        <meta name="description" content="<?php echo e($desc); ?>">
        <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
        <meta name="msapplication-TileColor" content="#206bc4"/>
        <meta name="theme-color" content="#206bc4"/>
        <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent"/>
        <meta name="apple-mobile-web-app-capable" content="yes"/>
        <meta name="mobile-web-app-capable" content="yes"/>
        <meta name="HandheldFriendly" content="True"/>
        <meta name="MobileOptimized" content="320"/>
        <meta name="robots" content="noindex,nofollow,noarchive"/>
        <link rel="icon" href="" type="image/x-icon"/>
        <link rel="shortcut icon" href="" type="image/x-icon"/>
        <!-- CSS files -->
        
        <link rel="stylesheet" href="<?php echo e(asset('dist/css/emojionearea.min.css')); ?>">
        
        <!-- Google Fonts -->
        <link href="//fonts.googleapis.com/css?family=Poppins:300,400,500,600" rel="stylesheet">
        
        <link rel="stylesheet" href="<?php echo e(asset('dist/font-awesome/css/fontawesome-all.min.css')); ?>" />
        <link rel="stylesheet" href="<?php echo e(asset('dist/css/css/theme.css')); ?>" />
        <link rel="stylesheet" href="<?php echo e(asset('dist/css/css/demo.css')); ?>" />

        <meta property="og:url"                content="<?php echo e(\Request::fullUrl()); ?>"/>
        <meta property="og:type"               content="article" />
        <meta property="og:title"              content="<?php echo e($title); ?>" />
        <meta property="og:description"        content="<?php echo e($desc); ?>" />
        
    </head>
    <body>
        <header class="duik-header">
        <nav class="navbar navbar-expand-lg navbar-dark bg-dark left-0 right-0 flex-nowrap z-index-3">
          <div class="container">
            <a class="navbar-brand" href="<?php echo e(url('/')); ?>">AskYou!</a>

            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarCollapse-3" aria-controls="navbarCollapse-3" aria-expanded="false" aria-label="Toggle navigation">
              <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarCollapse-3">
              <ul class="navbar-nav ml-auto mt-1 mt-lg-0">

                  <li class="nav-item mx-2">
                      <a href="#exampleModal" class="nav-link" data-toggle="modal">
                          <i class="fas fa-coins text-warning"></i> Coins 
                          <span class="badge badge-pill badge-warning badge-sm ml-2">
                              <small>22</small>
                          </span>
                      </a>
                  </li>
                  
                  <li class="nav-item mx-2">
                      <a href="<?php echo e(url('inbox')); ?>" class="nav-link">
                          <i class="fas fa-question-circle text-success"></i> Questions
                          <span class="badge badge-pill badge-success badge-sm ml-2">
                              <small>5</small>
                          </span>
                      </a>
                  </li>
                  
                  <li class="nav-item mx-2">
                      <a href="#exampleModal" class="nav-link" data-toggle="modal">
                          <i class="fas fa-bell text-primary"></i> Notifications 
                          <span class="badge badge-pill badge-primary badge-sm ml-2">
                              <small>12</small>
                          </span>
                      </a>
                  </li>
              </ul>

              <ul class="ml-auto navbar-nav">
                <li class="nav-item dropdown">
                  <a class="nav-link" href="#" id="navbarDropdown2" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <img class="rounded-circle img-thumbnail u-box-shadow-sm mr-2" width="35" height="35" src="https://randomuser.me/api/portraits/men/46.jpg" alt="Htmlstream"> <i class="fas fa-angle-down small ml-1"></i>
                  </a>
                  <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown2">
                    <a class="dropdown-item" href="">Profile</a>
                    <a class="dropdown-item" href="#">Account Settings</a>
                    <a class="dropdown-item" href="#">Newsletter</a>
                    <div class="dropdown-divider"></div>
                    <a class="dropdown-item" href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">Sign Out</a>
                      <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                                <?php echo csrf_field(); ?>
                            </form>
                  </div>
                </li>
              </ul>
            </div>
          </div>
        </nav>
        </header>
 
        <?php echo $__env->make('admin.layouts.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->yieldContent('content'); ?>
              
          
        <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="basic-modal" aria-hidden="true" style="display: none;">
                <div class="modal-dialog" role="document">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h5 class="modal-title" id="basic-modal">Basic Modals</h5>
                      <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                      </button>
                    </div>
                    <div class="modal-body">
                      <?php $notifications = App\Notifications::where('to_user_id', Auth::id())->where('read_at', null)->orderByDesc('created_at')->get() ?>
    <ul class="list-group">
                            <?php $__empty_1 = true; $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notify): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    
         <li class="list-group-item">
                <div class="media">
                  <div class="d-flex mr-3">
                    <img class="rounded-circle shadow mt-1" width="40" height="40" src="<?php echo e(url('dist/img/avatar/'.App\User::find($notify->by_user_id)->avatar)); ?>" alt="Htmlstream">
                  </div>
                  <div class="media-body text-muted">
                      
                      <span class="strong"><?php echo e(App\User::find($notify->by_user_id)->name); ?></span> <small>ha risposto <a href="">Quanto sei alto?</a></small>
                      
                    <p class="small"><?php echo e(Carbon::createFromTimeStamp(strtotime($notify->created_at))->diffForHumans()); ?></p>
                  </div>
                </div>
              </li>
                        
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="text-center">
              <div class="card-header border-0"><i class="fas fa-bell text-muted fa-3x"></i></div>
              <div class="card-body pt-0">
                <h4 class="h5 mb-2">There are no notifications!</h4>
              </div>
            </div>
                            <?php endif; ?>
    </ul>
                      
                      
                  
       
                        
                    </div>
                    <div class="modal-footer">
                      <a href="<?php echo e(url('mark-as-read')); ?>" class="btn btn-block btn-sm btn-primary mt-2">
                                Mark all as read
                                <span class="ml-auto"><svg xmlns="http://www.w3.org/2000/svg" class="icon icon-md" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z"></path><polyline points="3 9 12 15 21 9 12 3 3 9"></polyline><path d="M21 9v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-10"></path><line x1="3" y1="19" x2="9" y2="13"></line><line x1="15" y1="13" x2="21" y2="19"></line></svg></span>
                            </a>
                    </div>
                  </div>
                </div>
              </div>
          
        <footer class="duik-promo bg-dark pt-4">
            <div class="container duik-promo-container">

        <!-- Copyright and Social Icons -->
        <div class="row px-md-3 py-4">
          <div class="col-md-8 text-center text-md-left mb-3 mb-md-0">
            <small class="text-white">© 2019 <a class="text-white" href="https://htmlstream.com">Htmlstream</a>. Under MIT license.</small>
          </div>

          <div class="col-md-4 align-self-center">
            <ul class="list-inline text-center text-md-right mb-0">
              <li class="list-inline-item mx-2" data-toggle="tooltip" data-placement="top" title="" data-original-title="Facebook">
                <a class="text-white" target="_blank" href="https://www.facebook.com/htmlstream">
                  <i class="fab fa-facebook"></i>
                </a>
              </li>
              <li class="list-inline-item mx-2" data-toggle="tooltip" data-placement="top" title="" data-original-title="Github">
                <a class="text-white" target="_blank" href="https://github.com/htmlstreamofficial/">
                  <i class="fab fa-github"></i>
                </a>
              </li>
              <li class="list-inline-item mx-2" data-toggle="tooltip" data-placement="top" title="" data-original-title="Instagram">
                <a class="text-white" target="_blank" href="https://www.instagram.com/htmlstream">
                  <i class="fab fa-instagram"></i>
                </a>
              </li>
              <li class="list-inline-item mx-2" data-toggle="tooltip" data-placement="top" title="" data-original-title="Twitter">
                <a class="text-white" target="_blank" href="https://twitter.com/htmlstream">
                  <i class="fab fa-twitter"></i>
                </a>
              </li>
              <li class="list-inline-item mx-2" data-toggle="tooltip" data-placement="top" title="" data-original-title="Dribbble">
                <a class="text-white" target="_blank" href="https://dribbble.com/htmlstream">
                  <i class="fab fa-dribbble"></i>
                </a>
              </li>
            </ul>
          </div>
        </div>
        <!-- End Copyright and Social Icons -->
      </div>
            
            <!-- SVG BG -->
    <svg class="position-absolute bottom-0 left-0" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 1920 323" enable-background="new 0 0 1920 323" xml:space="preserve">
      <polygon fill="#ffffff" style="fill-opacity: .05;" points="-0.5,322.5 -0.5,121.5 658.3,212.3 "></polygon>
      <polygon fill="#ffffff" style="fill-opacity: .1;" points="-2,323 1920,323 1920,-1 "></polygon>
    </svg>
    <!-- End SVG BG -->
    </footer>
          
        <!-- Libs JS -->
        <script type="text/javascript" src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
        <script src="<?php echo e(asset('dist/libs/bootstrap/dist/js/bootstrap.bundle.min.js')); ?>"></script>
        <!-- Scripts -->
        <script src="<?php echo e(asset('dist/js/tabler.min.js')); ?>" defer></script>
        <script type="text/javascript" src="<?php echo e(asset('dist/js/emojionearea.min.js')); ?>"></script>

        <script type="text/javascript">
        // Emoji story
        $(document).ready(function() {
            $("#emojionearea1").emojioneArea({
                useSprite: false
            });
        });
            
        // Emoji comment
        $(document).ready(function() {
            $("#emojionearea2").emojioneArea({
                useSprite: false
            });
        });
            
        // Save Like Or Dislike
        $(document).on('click','#saveLikeDislike',function(){
            var _post=$(this).data('post');
            var _type=$(this).data('type');
            var vm=$(this);
            // Run Ajax
            $.ajax({
                url:"<?php echo e(url('save-likedislike')); ?>",
                type:"post",
                dataType:'json',
                data:{
                    post:_post,
                    type:_type,
                    _token:"<?php echo e(csrf_token()); ?>"
                },
                beforeSend:function(){
                    vm.addClass('disabled');
                },
                success:function(res){
                    if(res.bool==true){
                        vm.removeClass('disabled').addClass('active');
                        vm.removeAttr('id');
                        var _prevCount=$("."+_type+"-"+_post+"").text();
                        _prevCount++;
                        $("."+_type+"-"+_post+"").text(_prevCount);
                    } 
                    
                    if(res.bool==false){
                        vm.removeClass('active').addClass('disabled');
                        vm.removeAttr('id');
                        var _prevCount=$("."+_type+"-"+_post+"").text();
                        _prevCount--;
                        $("."+_type+"-"+_post+"").text(_prevCount);
                    }
                }   
            });
        });
        // End
            
        // Save Favorite
        $(document).on('click','#saveFavorite',function(){
            var _post=$(this).data('post');
            var vm=$(this);
            // Run Ajax
            $.ajax({
                url:"<?php echo e(url('save-favorite')); ?>",
                type:"post",
                dataType:'json',
                data:{
                    post:_post,
                    _token:"<?php echo e(csrf_token()); ?>"
                },
                beforeSend:function(){
                    vm.removeClass('text-orange').addClass('disabled');
                },
                success:function(res){
                    if(res.bool==true){
                        vm.removeClass('text-muted').addClass('text-orange');
                        vm.removeAttr('id');
                        
                        if(res.bool==false){
                            vm.removeClass('text-orange').addClass('text-muted');
                            vm.removeAttr('id');
                        }
                    }
                }   
            });
        });
        // End

        // Save Comment
        $(".save-comment").on('click',function(){
            var _comment=$(".comment").val();
            var _post=$(this).data('post');
            var vm=$(this);
            // Run Ajax
            $.ajax({
                url:"<?php echo e(url('save-comment')); ?>",
                type:"post",
                dataType:'json',
                data:{
                    comment:_comment,
                    post:_post,
                    _token:"<?php echo e(csrf_token()); ?>"
                },
                beforeSend:function(){
                    vm.text('Saving...').addClass('disabled');
                },
                success:function(res){
                    //var _html='<blockquote class="blockquote mb-4"><div class="float-left mr-3"><span class="avatar avatar-md"></span></div><div class="lh-sm"><small class="float-right text-muted">'+value.created_at+'</small><div class="text-muted strong"><a href="">You</a></div><div class="text-muted">'+_comment+'</div></div></blockquote>';
                    if(res.bool==true){
                        $(".comments").prepend(_html);
                        $(".comment").val('');
                        $(".comment-count").text($('blockquote').length);
                        $(".no-comments").hide();
                    }
                    vm.text('Save').removeClass('disabled');
                }   
            });
        });
        </script>
        
       
        
    </body>
</html><?php /**PATH C:\xampp-1\htdocs\askyou\resources\views/default/layouts/app.blade.php ENDPATH**/ ?>