<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <!-- analytics -->
        <?php if(!App\Settings::first()->analytics == null): ?>
        <!-- Global site tag (gtag.js) - Google Analytics -->
        <script async src="https://www.googletagmanager.com/gtag/js?id=UA-<?php echo e(App\Settings::first()->analytics); ?>"></script>
        <script>
            window.dataLayer = window.dataLayer || [];
            function gtag(){dataLayer.push(arguments);}
            gtag('js', new Date());
            
            gtag('config', 'UA-<?php echo e(App\Settings::first()->analytics); ?>');
        </script>
        <?php endif; ?>
        <!-- end analytics -->
        <meta charset="utf-8"/>
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta http-equiv="X-UA-Compatible" content="ie=edge"/>
        <title><?php echo e($title); ?></title>
        <meta name="description" content="<?php echo e($desc); ?>">
        <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
        <meta name="msapplication-TileColor" content="#206bc4"/>
        <meta name="theme-color" content="#206bc4"/>
        <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent"/>
        <meta name="apple-mobile-web-app-capable" content="yes"/>
        <meta name="mobile-web-app-capable" content="yes"/>
        <meta name="HandheldFriendly" content="True"/>
        <meta name="MobileOptimized" content="320"/>
        <link rel="icon" href="" type="image/x-icon"/>
        <link rel="shortcut icon" href="" type="image/x-icon"/>
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
        <!-- Google Fonts -->
        <link href="//fonts.googleapis.com/css?family=Poppins:300,400,500,600" rel="stylesheet">
        <!-- CSS files -->
        <link rel="stylesheet" href="<?php echo e(asset('resources/views/font-awesome/css/fontawesome-all.min.css')); ?>" />
        <link rel="stylesheet" href="<?php echo e(asset('resources/views/css/theme.css')); ?>" />
        <link rel="stylesheet" href="<?php echo e(asset('resources/views/css/demo.css')); ?>" />
        <!-- facebook -->
        <meta property="og:url"                content="<?php echo e(\Request::fullUrl()); ?>"/>
        <meta property="og:type"               content="website" />
        <meta property="og:title"              content="<?php echo e($title); ?>" />
        <meta property="og:description"        content="<?php echo e($desc); ?>" />
        
    </head>
    <body>
        
        <?php echo $__env->make('admin.layouts.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <header class="duik-header">
            
            <nav class="navbar navbar-expand-lg navbar-dark navbar-dark bg-primary-darker flex-nowrap z-index-3 shadow">
                <div class="container">
                    
                    <?php if(!empty(App\Settings::first()->logo)): ?>
                    <a class="navbar-brand mr-0" href="<?php echo e(url('/')); ?>">
                        <img src="<?php echo e(url('dist/img/logo/'.App\Settings::first()->logo)); ?>" class="navbar-brand-image shadow" alt="" data-toggle="tooltip" data-placement="bottom" title="<?php echo e(App\Settings::first()->website_name); ?>" width="35px" />
                    </a>
                    <?php else: ?>
                    <a class="navbar-brand mr-0" href="<?php echo e(url('/')); ?>">
                        <?php echo e(App\Settings::first()->website_name); ?>

                    </a>
                    <?php endif; ?>
                    
                    <!-- Header Search -->
                    <form action="<?php echo e(route('search')); ?>" method="GET" class="d-none d-lg-block w-100 ml-lg-3">
                        <?php echo csrf_field(); ?>
                        <input class="border-0 d-none d-lg-block form-control form-control-sm w-100 ml-lg-3 shadow-lg <?php $__errorArgs = ['key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="key" value="<?php echo e(old('key')); ?>" type="search" placeholder="<?php echo e(__('app.text_10')); ?>">

                        <?php $__errorArgs = ['key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="invalid-feedback" role="alert">
                            <strong><?php echo e($message); ?></strong>
                        </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                    </form>
                    <!-- End Header Search -->

                    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarCollapse-2" aria-controls="navbarCollapse-2" aria-expanded="false" aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"></span>
                    </button>

                    <div class="collapse navbar-collapse" id="navbarCollapse-2">
                        <ul class="navbar-nav ml-auto mr-sm-2 mt-2 mt-lg-0 duik-header__nav small text-nowrap ml-0 ml-md-3">
                            
                            <?php if(Auth::check()): ?>
                            <!-- inbox -->
                            <li class="nav-item <?php echo e((request()->is('inbox')) ? 'active' : ''); ?> ml-4 mx-2">
                                <a class="nav-link" href="<?php echo e(url('inbox')); ?>" title="<?php echo e(__('app.text_2')); ?>"><i class="fas fa-question-circle text-success mr-md-1"></i> <?php echo e(__('app.text_2')); ?>

                                <?php if(App\Questions::where('sent_to', Auth::id())->where('replied', 2)->count() > 0): ?>
                                    <span class="badge badge-pill badge-success badge-sm ml-2">
                                        <small><?php echo e(App\Questions::where('sent_to', Auth::id())->where('replied', 2)->count()); ?></small>
                                    </span>
                                    <?php endif; ?>
                                </a>
                            </li>
                            
                            <!-- notifications -->
                            <li class="nav-item ml-4 mx-2">
                                <a href="#notificationsModal" class="nav-link" data-toggle="modal" title="<?php echo e(__('app.text_3')); ?>">
                                    <i class="fas fa-bell text-warning"></i> <?php echo e(__('app.text_3')); ?>

                                    <?php if(App\Notifications::where('sent_to', Auth::id())->where('read_at', null)->count() > 0): ?>
                                    <span class="badge badge-pill badge-warning badge-sm ml-2">
                                        <small><?php echo e(App\Notifications::where('sent_to', Auth::id())->where('read_at', null)->count()); ?></small>
                                    </span>
                                    <?php endif; ?>
                                </a>
                            </li>
                        
                        </ul>

                        <ul class="navbar-nav">
                            <li class="nav-item dropdown ml-4">
                                <a class="nav-link" href="#" id="navbarDropdown1" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <?php if(Auth::user()->avatar == NULL): ?>
                                    <img class="rounded-circle shadow" width="35" height="35" src="<?php echo e(url('dist/img/avatar/default_avatar.png')); ?>" alt="">
                                    <?php else: ?>
                                    <img class="rounded-circle shadow" width="35" height="35" src="<?php echo e(url('dist/img/avatar/'.Auth::user()->avatar)); ?>" alt="">
                                    <?php endif; ?>
                                </a>
                                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown2">
                                    <a class="dropdown-item" href="<?php echo e(url('@'.Auth::user()->name)); ?>">
                                        <i class="fas fa-address-card"></i> <?php echo e(__('app.text_4')); ?>

                                    </a>

                                    <a class="dropdown-item" href="<?php echo e(url('user/account/')); ?>">
                                        <i class="fas fa-user-cog"></i> <?php echo e(__('app.text_5')); ?>

                                    </a>

                                    <?php if(Auth::user()->hasRole('admin')): ?>
                                    <a class="dropdown-item" href="<?php echo e(url('admin')); ?>">
                                        <strong><i class="fas fa-tools"></i> <?php echo e(__('app.text_6')); ?></strong>
                                    </a>
                                    <?php endif; ?>
                                    <div class="dropdown-divider"></div>
                                    <a class="dropdown-item" href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault();
                                                             document.getElementById('logout-form').submit();">
                                        <i class="fas fa-sign-out-alt"></i> <?php echo e(__('app.text_7')); ?>

                                    </a>
                                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                    </form>
                                </div>
                            </li>
            
                            <?php else: ?>

                            <li class="nav-item ml-6 mx-2">
                                <a href="<?php echo e(url('/')); ?>" class="nav-link">
                                    <i class="fas fa-home"></i> <?php echo e(__('app.text_9')); ?> 
                                </a>
                            </li>

                            <li class="nav-item ml-4 mx-2">
                                <a href="<?php echo e(url('contacts')); ?>" class="nav-link">
                                    <i class="fas fa-at"></i> <?php echo e(__('app.text_8')); ?>

                                </a>
                            </li>

                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
            </nav>
        </header>
        
        <?php echo $__env->yieldContent('content'); ?>
                 
        <div class="modal fade" id="notificationsModal" tabindex="-1" role="dialog" aria-labelledby="basic-modal" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="basic-modal"><?php echo e(__('app.text_3')); ?></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                    </div>
                    <div class="modal-body">
                      <?php $notifications = App\Notifications::where('sent_to', Auth::id())->where('read_at', null)->orderByDesc('created_at')->limit(30)->get() ?>
                        <ul class="list-group">
                            <?php $__empty_1 = true; $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notify): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <a href="<?php echo e(url('question/'.$notify->item_id)); ?>" class="list-group-item text-decoration-none">
                                <div class="media">
                                    <div class="d-flex mr-3">
                                        <?php if(App\User::find($notify->sent_by)->avatar == NULL): ?>
                                        <img class="rounded-circle shadow" width="40" height="40" src="<?php echo e(url('dist/img/avatar/default_avatar.png')); ?>">
                                        <?php else: ?>
                                        <img class="rounded-circle shadow" width="40" height="40" src="<?php echo e(url('dist/img/avatar/'.App\User::find($notify->sent_by)->avatar)); ?>" alt="">
                                        <?php endif; ?>
                                    </div>

                                    <div class="media-body text-muted">
                                        <strong><?php echo e(Str::limit(App\User::find($notify->sent_by)->name, 25)); ?></strong> <?php if($notify->type == "reply"): ?> <i class="fas fa-reply text-primary"></i> <?php echo e(__('app.text_33')); ?> "<strong><?php echo e(Str::limit(App\Questions::find($notify->item_id)->question, 35)); ?></strong>" <?php else: ?> <i class="fas fa-heart text-danger"></i> <?php echo e(__('app.text_34')); ?> "<strong><?php echo e(Str::limit(App\Answers::find($notify->reply_id)->reply, 35)); ?></strong>" <?php endif; ?>
                                        <div class="extra-small"><?php echo e(Carbon::createFromTimeStamp(strtotime($notify->created_at))->diffForHumans()); ?></div>
                                    </div>
                                </div>
                            </a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="card p-4 border-0 text-center">
                                <div class="card-header border-0"><i class="fas fa-bell text-muted fa-3x"></i></div>
                                <div class="card-body pt-0">
                                    <h4 class="h5 mb-2"><?php echo e(__('app.text_31')); ?></h4>
                                </div>
                            </div>
                            <?php endif; ?>
                        </ul>
                    </div>
                    <div class="modal-footer">
                      <a href="<?php echo e(url('mark-as-read')); ?>" class="btn btn-block btn-sm btn-primary strong">
                          <?php echo e(__('app.text_32')); ?>

                          <span class="ml-auto">
                              <i class="fas fa-envelope-open-text"></i>
                          </span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
          
        <footer class="duik-promo p-2 bg-primary-darker">
            <div class="container duik-promo-container">
                
                <!-- Copyright and Social Icons -->
                <div class="row px-md-3 py-4">
                    <div class="col-md-6 text-center text-md-left mb-3 mb-md-0">
                        <small>&copy;<?php echo e(date("Y")); ?> <a href="<?php echo e(url('/')); ?>" class="link-white"><?php echo e(App\Settings::first()->website_name); ?></a> - Produced by <a href="https://codecanyon.net/user/labnetwork/portfolio" target="_blank" class="link-white"><span class="text-danger">&hearts;</span> LabNetwork</a></small>
                    </div>
                    
                    <div class="col-md-6 align-self-center">
                        <ul class="list-inline text-center text-md-right mb-0">
                            <small><?php echo e(App\Settings::first()->website_tagline); ?></small>
                        </ul>
                    </div>
                </div>
                <!-- End Copyright and Social Icons -->
            </div>
        </footer>
          
        <a class="js-go-to duik-go-to show" href="#top">
            <span class="fa fa-arrow-up duik-go-to__inner"></span>
        </a>
        
        <!-- Libs JS -->
        <script type="text/javascript" src="<?php echo e(asset('resources/views/vendor/jquery/dist/jquery-3.5.1.min.js')); ?>"></script>
        <script src="<?php echo e(asset('resources/views/vendor/bootstrap/dist/js/bootstrap.bundle.min.js')); ?>"></script>
        <script src="<?php echo e(asset('resources/views/vendor/bootstrap/dist/js/popper.min.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(asset('resources/js/like-system.js')); ?>"></script>
        <!-- Scripts -->
        
    </body>
</html><?php /**PATH C:\xampp-1\htdocs\askyou\resources\views/layouts/app.blade.php ENDPATH**/ ?>