<?php
$auth_title = __('auth.verify_your_email_address')
?>

<?php $__env->startSection('content'); ?>
<div class="container-tight py-6">
    
    <div class="text-center mb-4">
        <a href="<?php echo e(url('/')); ?>" class="navbar-brand d-none-navbar-horizontal pr-0 pr-md-3">
            <?php if(!empty(App\Settings::first()->logo)): ?>
            <img src="<?php echo e(url('dist/img/logo/'.App\Settings::first()->logo)); ?>" class="navbar-brand-image" alt="" title="<?php echo e(App\Settings::first()->website_name); ?>" data-toggle="tooltip" data-placement="bottom" title="<?php echo e(App\Settings::first()->website_name); ?>"/>
            <?php else: ?>
            <h2 class="text-muted">
                <?php echo e(App\Settings::first()->website_name); ?>

            </h2>
            <?php endif; ?>
        </a>
    </div>
    
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header"><?php echo e(__('auth.verify_your_email_address')); ?></div>

                <div class="card-body">
                    <?php if(session('resent')): ?>
                        <div class="alert alert-success" role="alert">
                            <?php echo e(__('auth.verificatio_link')); ?>

                        </div>
                    <?php endif; ?>

                    <?php echo e(__('auth.before_proceeding')); ?>

                    <?php echo e(__('auth.not_receive')); ?>,
                    <form class="d-inline" method="POST" action="<?php echo e(route('verification.resend')); ?>">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="btn btn-link p-0 m-0 align-baseline">
                            <?php echo e(__('auth.click_here')); ?>

                        </button>.
                    </form>
                    
                    <p class="mt-4 mark strong">
                        <?php echo e(__('auth.before_proceeding_1')); ?>

                    </p>
                </div>
            </div>
            
            <div class="btn-list">
                <a href="<?php echo e(url('user/confirm/delete_account')); ?>" class="btn btn-outline-danger mr-auto" onclick="return confirm('<?php echo app('translator')->get('app.text_49'); ?>');"><?php echo e(__('auth.delete_account')); ?></a>
                <a href="<?php echo e(url('/')); ?>" class="btn btn-primary"><?php echo e(__('auth.come_back')); ?></a>
            </div>
            
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('auth.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp-1\htdocs\askyou\resources\views/auth/verify.blade.php ENDPATH**/ ?>