<div class="card shadow mb-4" id="item-<?php echo e($quest->id); ?>">
    <div class="card-header">
        <h6 class="mb-0"><?php echo e($quest->question); ?> 
            <?php if(e($quest->private) == 2): ?> &mdash; <small><a href="<?php echo e(url('@'.App\User::find($quest->sent_by)->name)); ?>"><strong><?php echo e(App\User::find(e($quest->sent_by))->name); ?></strong></a></small> <?php endif; ?></h6>
    </div>
    
    <!-- answer -->
    <div class="card-body"> 
        <?php
        $answer = App\Answers::where('id_question', $quest->id)->first()
        ?>
        <div class="d-flex align-items-center mt-auto">
            <div class="text-muted">
                <div class="media align-items-center mb-4">
                    <div class="rounded-circle mr-3">
                        <?php if(App\User::find(e($answer->sent_by))->avatar == NULL): ?>
                        <img class="rounded-circle" width="45" height="45" src="<?php echo e(url('dist/img/avatar/default_avatar.png')); ?>" alt="">
                        <?php else: ?>
                        <img class="rounded-circle" width="45" height="45" src="<?php echo e(url('dist/img/avatar/'.App\User::find($answer->sent_by)->avatar)); ?>" alt="">
                        <?php endif; ?>
                    </div>
                    
                    <div class="media-body">
                        <a href="<?php echo e(url('@'.App\User::find($answer->sent_by)->name)); ?>">
                            <strong><?php echo e(Str::limit(App\User::find($answer->sent_by)->name, 25)); ?></strong>
                        </a>
                        <small class="d-block text-muted">
                            <?php echo e(Carbon::createFromTimeStamp(strtotime($answer->created_at))->diffForHumans()); ?>

                        </small>
                    </div>
                </div>
                
                <span class="d-block text-muted"><i class="fas fa-reply"></i> <?php echo e($answer->reply); ?></span>
                <?php if(!empty($answer->photo)): ?>
                <div class="mt-2">
                    <img class="shadow img-thumbnail" src="<?php echo e(url('dist/img/answers/'.$answer->photo)); ?>" width="150" height="150" alt="">
                </div>
                <?php endif; ?>
            </div>
            <!--<div class="ml-auto"></div>!-->
        </div>
    </div>
    <!-- end answer -->
    
    <div class="card-footer">
        <div class="d-flex">
            <a href="" class="btn btn-sm btn-secondary btn-pill mr-2 dropdown-toggle" id="dropdownShare" data-toggle="dropdown"  aria-haspopup="true" aria-expanded="false"><i class="fas fa-share-alt"></i> <?php echo e(__('app.text_15')); ?></a>
            <div class="dropdown-menu navbar-left" aria-labelledby="dropdownShare">
                <a class="dropdown-item text-muted" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(url('/question/'.$quest->id)); ?>&text=<?php echo e(Str::of($quest->question)->words(12, '...')); ?>" target="_blank">
                    <i class="fab fa-facebook text-primary"></i> Facebook
                </a>
                <a class="dropdown-item text-muted" href="http://twitter.com/share?text=<?php echo e(Str::of($quest->question)->words(12, '...')); ?>&url=<?php echo e(url('/question/'.$quest->id)); ?>&hashtags=ask,question,answer" target="_blank">
                    <i class="fab fa-twitter text-info"></i> Twitter
                </a>
                <a class="dropdown-item text-muted" href="whatsapp://send?text=<?php echo e(url('/question/'.$quest->id)); ?>" target="_blank">
                    <i class="fab fa-whatsapp text-success"></i> Whatsapp
                </a>
            </div>
            
            
            <div class="dropdown">
                <button class="btn btn-sm btn-light btn-pill dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fas fa-ellipsis-h"></i></button>
                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                        <a class="dropdown-item text-muted" href="<?php echo e(url('question/'.$quest->id)); ?>">
                            <i class="fas fa-eye"></i> <?php echo e(__('app.text_16')); ?>

                        </a>
                        <a class="dropdown-item text-muted" href="<?php echo e(route('report')); ?>" onclick="event.preventDefault(); document.getElementById('report-form-q<?php echo e($quest->id); ?>a<?php echo e($answer->id); ?>').submit();">
                            <i class="fas fa-flag"></i> <?php echo e(__('app.text_17')); ?>

                        </a>
                        <form id="report-form-q<?php echo e($quest->id); ?>a<?php echo e($answer->id); ?>" action="<?php echo e(route('report')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="question_id" value="<?php echo e($quest->id); ?>" /> 
                            <input type="hidden" name="answer_id" value="<?php echo e($answer->id); ?>" />
                        </form>
                        
                        <?php if($answer->sent_by == Auth::id()): ?>
                        <a class="dropdown-item text-primary" href="<?php echo e(url('user/delete-question/'.$quest->id)); ?>" onclick="return confirm('<?php echo app('translator')->get('app.text_49'); ?>');">
                            <i class="fas fa-trash-alt"></i> <?php echo e(__('app.text_17_1')); ?>

                        </a>
                        <a class="dropdown-item text-danger" href="<?php echo e(url('user/delete-answer/'.$answer->id)); ?>" onclick="return confirm('<?php echo app('translator')->get('app.text_48'); ?>');">
                            <i class="fas fa-trash-alt"></i> <?php echo e(__('app.text_17_2')); ?>

                        </a>
                        <?php endif; ?>
                    </div>
                </div>
          
            <div class="ml-auto">
                <span id="saveLike" data-url="<?php echo e(url('save-like')); ?>" data-post="<?php echo e($quest->id); ?>" data-answer="<?php echo e($answer->id); ?>" data-touser="<?php echo e($answer->sent_by); ?>" class="btn btn-sm btn-pill <?php if(@App\Answers::checkLike(Auth::id(), $answer->id) == 1): ?> btn-outline-danger active <?php else: ?> btn-light <?php endif; ?>">
                    <i class="far fa-heart"></i> <span class="like-<?php echo e($answer->id); ?>"><?php echo json_encode($answer->likes(), 15, 512) ?></span>
                </span>
            </div>
        </div>
    </div>
</div><?php /**PATH C:\xampp-1\htdocs\askyou\resources\views/layouts/items.blade.php ENDPATH**/ ?>