パスワードを扱う
================

ほとんどの開発者はパスワードを平文テキストで保存してはいけないということを知っていますが、パスワードを `md5` や `sha1`
でハッシュしてもまだ安全だと思っている開発者がたくさんいます。かつては、前述のハッシュ・アルゴリズムを使えば十分であった時もありましたが、
現代のハードウェアをもってすれば、そのようなハッシュはブルート・フォース・アタックを使って非常に簡単に復元することが可能です。

最悪のシナリオ (アプリケーションに侵入された場合) であっても、ユーザのパスワードについて強化されたセキュリティを提供することが出来るように、
ブルート・フォース・アタックに対する耐性が強いハッシュ・アルゴリズムを使う必要があります。現在、最善の選択は `bcrypt` です。
PHP では、[crypt 関数](https://secure.php.net/manual/ja/function.crypt.php) を使って `bcrypt` ハッシュを生成することが出来ます。
Yii は `crypt` を使ってハッシュを安全に生成し検証することを容易にするために、二つのヘルパ関数を提供しています。

ユーザが初めてパスワードを提供するとき (例えば、ユーザ登録の時) には、パスワードをハッシュする必要があります。


```php
$hash = Yii::$app->getSecurity()->generatePasswordHash($password);
```

そして、ハッシュを対応するモデル属性と関連付けて、後で使用するためにデータベースに保存します。

ユーザがログインを試みたときは、送信されたパスワードは、前にハッシュされて保存されたパスワードと照合して検証されなければなりません。


```php
if (Yii::$app->getSecurity()->validatePassword($password, $hash)) {
    // よろしい、ユーザをログインさせる
} else {
    // パスワードが違う
}
```
