先を見通す
==========

「はじめよう」の章全体を読み通したなら、いまやあなたは、完全な Yii のアプリケーションを作成したことがある、ということになります。
その過程で、あなたは必要とされることが多いいくつかの機能、例えば、HTML フォームを通じてユーザからデータを取得することや、データベースからデータを取得すること、また、ページ付けをしてデータを表示することなどを実装する方法を学びました。
また、[Gii](https://www.yiiframework.com/extension/yiisoft/yii2-gii/doc/guide) を使ってコードを自動的に生成する方法も学びました。
Gii をコード生成に使うと、ウェブ開発のプロセスの大部分が、いくつかのフォームに入力していくだけの簡単な仕事になります。

このセクションでは、Yii フレームワークを使うときの生産性を更に高めるために利用できるリソースについてまとめます。

* ドキュメント
    - [決定版ガイド](http://www.yiiframework.com/doc-2.0/guide-README.html):
      名前が示すように、このガイドは Yii がどのように動作すべきものかを正確に記述し、Yii を使用するについての全般的な手引きを提供するものです。
      これは唯一の最も重要な Yii のチュートリアルであり、Yii のコードを少しでも書く前にあなたが読まなければならないものです。
    - [クラス・リファレンス](http://www.yiiframework.com/doc-2.0/index.html):
      これは Yii によって提供される全てのクラスの使用法を記述しています。
      主として、コードを書いている時に、特定のクラス、メソッド、プロパティについて理解したい場合に読まれるべきものです。
      クラス・リファレンスの使用は、フレームワーク全体の文脈的な理解が出来てからにするのが最善です。
    - [Wiki の記事](http://www.yiiframework.com/wiki/?tag=yii2):
      Wiki の記事は、Yii のユーザが自身の経験に基づいて書いたものです。
      ほとんどの記事は、料理本のレシピのように書かれており、特定の問題を Yii を使って解決する方法を示しています。
      これらの記事の品質は決定版ガイドほどには良くないかもしれませんが、より広範なトピックをカバーしていることと、たいていは即座に使えるソリューションを提供してくれることにおいて有用なものです。
    - [書籍](http://www.yiiframework.com/doc/)
* [エクステンション](http://www.yiiframework.com/extensions/):
  Yii は、ユーザによって作られた数千におよぶエクステンションのライブラリを誇りとしています。
  エクステンションはあなたのアプリケーションに簡単に組み込むことが出来、そうすることでアプリケーションの開発作業をより一層速くて簡単なものにします。
* コミュニティ
    - フォーラム: <http://www.yiiframework.com/forum/>
    - IRC チャット: freenode ネットワーク (<irc://irc.freenode.net/yii>) の #yii チャンネル
    - Slack チャンネル:  <https://join.slack.com/t/yii/shared_invite/enQtMzQ4MDExMDcyNTk2LTc0NDQ2ZTZhNjkzZDgwYjE4YjZlNGQxZjFmZDBjZTU3NjViMDE4ZTMxNDRkZjVlNmM1ZTA1ODVmZGUwY2U3NDA>
    - Gitter チャット: <https://gitter.im/yiisoft/yii2>
    - GitHub: <https://github.com/yiisoft/yii2>
    - Facebook: <https://www.facebook.com/groups/yiitalk/>
    - Twitter: <https://twitter.com/yiiframework>
    - LinkedIn: <https://www.linkedin.com/groups/yii-framework-1483367>
    - Stackoverflow: <http://stackoverflow.com/questions/tagged/yii2>
