# 何を知っている必要があるか

Yii の学習曲線は他の PHP フレームワークほど急峻ではありませんが、それでも Yii を使い始める前に学習すべき事がいくつかはあります。

## PHP

Yii は PHP フレームワークですから、必ず [言語リファレンスを読んで理解する](https://secure.php.net/manual/ja/langref.php) ようにして下さい。
Yii を使って開発するときはオブジェクト指向の流儀でコードを書くことになりますから、必ず、[クラスとオブジェクト](https://secure.php.net/manual/ja/language.oop5.basic.php) および [名前空間](https://secure.php.net/manual/ja/language.namespaces.php) には慣れ親しんでおいて下さい。

## オブジェクト指向プログラミング

オブジェクト指向プログラミングの基礎的な理解が必要です。これに慣れていない場合は、利用できるチュートリアルが沢山ありますので、その中の一つをチェックして下さい。
例えば、[tuts+ の中の一つ](https://code.tutsplus.com/tutorials/object-oriented-php-for-beginners--net-12762) など。

あなたのアプリケーションが複雑であればあるほど、その複雑性をうまく管理するために、
より高度な OOP 概念を学ぶ必要があることに留意して下さい。

## コマンド・ラインと Composer

Yii は業界標準の PHP パッケージ管理ソフトである [Composer](https://getcomposer.org/) を広範囲に使用していますので、必ずその [ガイド](https://getcomposer.org/doc/01-basic-usage.md) を読んで理解して下さい。
あなたがコマンド・ラインの使用に慣れていないのであれば、今こそ使い始めてみるべき時です。
いったん基礎さえ学習してしまえば、二度とコマンド・ラインなしで仕事をしようとは思わなくなりますよ。

