アプリケーション・コンポーネント
================================

アプリケーションは [サービス・ロケータ](concept-service-locator.md) です。
アプリケーションは、リクエストを処理するためのいろいろなサービスを提供する一組の *アプリケーション・コンポーネント* と呼ばれるものをホストします。
例えば、`urlManager` がウェブ・リクエストを適切なコントローラにルーティングする役割を負い、
`db` コンポーネントが DB 関連のサービスを提供する、等々です。

全てのアプリケーション・コンポーネントは、それぞれ、同一のアプリケーション内で他のアプリケーション・コンポーネントから区別できるように、ユニークな ID を持ちます。
アプリケーション・コンポーネントには、次の式によってアクセス出来ます。

```php
\Yii::$app->componentID
```

例えば、`\Yii::$app->db` を使って、アプリケーションに登録された [[yii\db\Connection|DB 接続]] を取得することが出来ます。
また、`\Yii::$app->cache` を使って、[[yii\caching\Cache|プライマリ・キャッシュ]] を取得できます。

アプリケーション・コンポーネントは、上記の式を使ってアクセスされた最初の時に作成されます。
二度目以降のアクセスでは、同じコンポーネント・インスタンスが返されます。

どのようなオブジェクトでも、アプリケーション・コンポーネントとすることが可能です。
[アプリケーションの構成情報](structure-applications.md#application-configurations) の中で [[yii\base\Application::components]] プロパティを構成することによって、アプリケーション・コンポーネントを登録することが出来ます。
例えば、

```php
[
    'components' => [
        // クラス名を使って "cache" コンポーネントを登録
        'cache' => 'yii\caching\ApcCache',

        // 構成情報の配列を使って "db" コンポーネントを登録
        'db' => [
            'class' => 'yii\db\Connection',
            'dsn' => 'mysql:host=localhost;dbname=demo',
            'username' => 'root',
            'password' => '',
        ],

        // 無名関数を使って "search" コンポーネントを登録
        'search' => function () {
            return new app\components\SolrService;
        },
    ],
]
```

> Info: 必要なだけ多くのアプリケーション・コンポーネントを登録することが出来ますが、慎重にしなければなりません。
  アプリケーション・コンポーネントはグローバル変数のようなものです。
  あまり多くのアプリケーション・コンポーネントを使うと、コードのテストと保守が困難になるおそれがあります。
  多くの場合、必要なときにローカルなコンポーネントを作成して使用するだけで十分です。


## コンポーネントをブートストラップに含める <span id="bootstrapping-components"></span>

上述のように、アプリケーション・コンポーネントは最初にアクセスされた時に初めてインスタンスが作成されます。
リクエストの間に全くアクセスされなかった時は、インスタンスは作成されません。
けれども、場合によっては、明示的にアクセスされないときでも、リクエストごとにアプリケーション・コンポーネントのインスタンスを作成したいことがあります。
そうするために、アプリケーションの [[yii\base\Application::bootstrap|bootstrap]] プロパティのリストにそのコンポーネントの ID を挙げることが出来ます。

また、カスタマイズしたコンポーネントをブートストラップするためにクロージャを用いることも出来ます。インスタンス化されたコンポーネントを返すことは要求されません。
単に [[yii\base\Application]] のインスタンス化の後にコードを走らせるだけのためにクロージャを使うことも出来ます。

例えば、次のアプリケーション構成情報は、`log` コンポーネントが常にロードされることを保証するものです。

```php
[
    'bootstrap' => [
        'log',
        function($app){
            return new ComponentX();
        },
        function($app){
            // 何らかのコード
           return;
        }
    ],
    'components' => [
        'log' => [
            // "log" コンポーネントの構成情報
        ],
    ],
]
```


## コア・アプリケーション・コンポーネント <span id="core-application-components"></span>

Yii は固定の ID とデフォルトの構成情報を持つ一連の *コア*・アプリケーション・コンポーネントを定義しています。
例えば、[[yii\web\Application::request|request]] コンポーネントは、ユーザ・リクエストに関する情報を収集して、
それを [ルート](runtime-routing.md) として解決するために使用されます。
また、[[yii\base\Application::db|db]] コンポーネントは、それを通じてデータ・ベースクエリを実行できるデータベース接続を表現します。
Yii のアプリケーションがユーザ・リクエストを処理出来るのは、まさにこれらのコア・アプリケーション・コンポーネントの助けがあってこそです。

下記が事前に定義されたコア・アプリケーション・コンポーネントです。
通常のアプリケーション・コンポーネントに対するのと同様に、これらを構成し、カスタマイズすることが出来ます。
コア・アプリケーション・コンポーネントを構成するときは、クラスを指定しない場合は、デフォルトのクラスが使用されます。

* [[yii\web\AssetManager|assetManager]]: アセット・バンドルとアセットの発行を管理します。
  詳細は [アセット](structure-assets.md) のセクションを参照してください。
* [[yii\db\Connection|db]]: データベース接続を表します。これを通じて、DB クエリを実行することが出来ます。
  このコンポーネントを構成するときは、コンポーネントのクラスはもちろん、[[yii\db\Connection::dsn]]
  のような必須のコンポーネント・プロパティを指定しなければならないことに注意してください。
  詳細は [データベース・アクセス・オブジェクト](db-dao.md) のセクションを参照してください。
* [[yii\base\Application::errorHandler|errorHandler]]: PHP のエラーと例外を処理します。
  詳細は [エラー処理](runtime-handling-errors.md) のセクションを参照してください。
* [[yii\i18n\Formatter|formatter]]: エンド・ユーザに表示されるデータに書式を設定します。
  例えば、数字が3桁ごとの区切りを使って表示されたり、日付が長い書式で表示されたりします。
  詳細は [データの書式設定](output-formatting.md) のセクションを参照してください。
* [[yii\i18n\I18N|i18n]]: メッセージの翻訳と書式設定をサポートします。
  詳細は [国際化](tutorial-i18n.md) のセクションを参照してください。
* [[yii\log\Dispatcher|log]]: ログ・ターゲットを管理します。
  詳細は [ロギング](runtime-logging.md) のセクションを参照してください。
* [[yii\swiftmailer\Mailer|mailer]]: メールの作成と送信をサポートします。
  詳細は [メール](tutorial-mailing.md) のセクションを参照してください。
* [[yii\base\Application::response|response]]: エンド・ユーザに送信されるレスポンスを表現します。
  詳細は [レスポンス](runtime-responses.md) のセクションを参照してください。
* [[yii\base\Application::request|request]]: エンド・ユーザから受信したリクエストを表現します。
  詳細は [リクエスト](runtime-requests.md) のセクションを参照してください。
* [[yii\web\Session|session]]: セッション情報を表現します。
  このコンポーネントは、[[yii\web\Application|ウェブ・アプリケーション]] においてのみ利用できます。
  詳細は [セッションとクッキー](runtime-sessions-cookies.md) のセクションを参照してください。
* [[yii\web\UrlManager|urlManager]]: URL の解析と生成をサポートします。
  詳細は [ルーティング と URL 生成](runtime-routing.md) のセクションを参照してください。
* [[yii\web\User|user]]: ユーザの認証情報を表現します。
  このコンポーネントは、[[yii\web\Application|ウェブ・アプリケーション]] においてのみ利用できます。
  詳細は [認証](security-authentication.md) のセクションを参照してください。
* [[yii\web\View|view]]: ビューのレンダリングをサポートします。
  詳細は [ビュー](structure-views.md) のセクションを参照してください。
