共有ホスティング環境
====================

共有ホスティング環境では、たいてい、構成やディレクトリ構造について大きな制約があります。
それでも、ほとんどの場合、少し調整をすれば、Yii 2.0 を共有ホスティング環境で走らせることが可能です。

## ベーシック・プロジェクト・テンプレートを配備する

通例、共有ホスティング環境では、一つのウェブ・ルートしかありませんので、可能であればベーシック・プロジェクト・テンプレートを使用して下さい。
まず、[Yii をインストールする](start-installation.md) のセクションを参照して、
プロジェクト・テンプレートをローカル環境にインストールします。
そして、ローカル環境でアプリケーションが動くようにした後で、共有ホスティング環境でホスト出来るようにいくつかの修正を行います。

### ウェブ・ルートの名前を変える <span id="renaming-webroot"></span>

FTP またはその他の手段であなたの共有ホストに接続します。おそらく、下記のようなディレクトリが見えるでしょう。
 
```
config
logs
www
```

上記で `www` はウェブ・サーバのウェブ・ルート・ディレクトリです。
別の名前かもしれません。よくある名前は、`www`、`htdocs`、`public_html` です。

私たちのベーシック・プロジェクト・テンプレートではウェブ・ルートの名前は `web` になっています。
あなたのウェブ・サーバにアップロードする前に、ローカルのウェブ・ルートの名前をあなたのサーバに適合するように変更します。
すなわち、`web` から `www` や `public_html` など、何であれ、あなたの共有ホストのウェブ・ルートの名前に変更します。

### FTP ルート・ディレクトリは書き込み可能

ルート・レベルのディレクトリ、すなわち、`config`、`logs`、`www` があるディレクトリに対して書き込みが出来るのであれば、
`assets`、`commands` などをそのままルート・レベルのディレクトリにアップロードします。

### ウェブ・サーバのための追加設定 <span id="add-extras-for-webserver"></span>

使用されているウェブ・サーバが Apache である場合は、次の内容を持つ `.htaccess` ファイルを `web`
(または `public_html` など、要するに、`index.php` があるディレクトリ) に追加する必要があります。

```
Options +FollowSymLinks
IndexIgnore */*

RewriteEngine on

# ディレクトリかファイルが存在すれば、それを直接使う
RewriteCond %{REQUEST_FILENAME} !-f
RewriteCond %{REQUEST_FILENAME} !-d

# それ以外は、index.php にフォワードする
RewriteRule . index.php
```

nginx の場合は、追加の構成ファイルは必要がない筈です。

### 必要条件をチェックする

Yii を走らせるためには、あなたのウェブ・サーバは Yii の必要条件を満たさなければなりません。最低限の必要条件は PHP 5.4 です。
必要条件をチェックするために、`requirements.php` をルート・ディレクトリからウェブ・ルート・ディレクトリにコピーして、
`http://example.com/requirements.php` という URL を使ってブラウザ経由で走らせます。後でファイルを削除するのを忘れないでください。

## アドバンスト・プロジェクト・テンプレートを配備する

アドバンスト・プロジェクト・テンプレートを共有ホストに配備することは、ベーシック・プロジェクト・テンプレートを配備するのに比べると少しトリッキーにはなりますが、可能です。
[アドバンスト・プロジェクト・テンプレートのドキュメント](https://github.com/yiisoft/yii2-app-advanced/blob/master/docs/guide-ja/topic-shared-hosting.md)
で説明されている指示に従って下さい。
