Криптография
============

В этом разделе мы рассмотрим следующие аспекты безопасности:

- Генерация случайных данных
- Шифрование и дешифрование
- Подтверждение целостности данных

Генерация псевдослучайных данных
----------------------------

Псевдослучайные данные полезны во многих ситуациях. Например, при сбросе пароля по электронной почте вам необходимо сгенерировать токен, сохранить его в базе данных и отправить его по электронной почте конечному пользователю, что, в свою очередь, позволит ему подтвердить право собственности на эту учетную запись. Очень важно, чтобы этот токен был уникальным и его было трудно угадать, иначе есть вероятность, что злоумышленник сможет предсказать значение токена и сбросить пароль пользователя.

Помощник по безопасности Yii упрощает генерацию псевдослучайных данных:

```php
$key = Yii::$app->getSecurity()->generateRandomString();
```

Шифрование и дешифрование
-------------------------

Yii предоставляет удобные вспомогательные функции, которые позволяют шифровать или расшифровывать данные с помощью секретного ключа. Данные передаются через функцию шифрования, так что только человек, у которого есть секретный ключ, сможет расшифровать его.
Например, нам нужно сохранить некоторую информацию в нашей базе данных, но мы должны убедиться, что только пользователь, у которого есть секретный ключ, может ее просмотреть (даже если база данных приложения скомпрометирована):

```php
// $data и $secretKey получены из формы
$encryptedData = Yii::$app->getSecurity()->encryptByPassword($data, $secretKey);
// $encryptedData хранится в БД
```

Впоследствии, когда пользователь хочет прочитать данные:

```php
// $secretKey введен пользователем, $encryptedData получен из БД
$data = Yii::$app->getSecurity()->decryptByPassword($encryptedData, $secretKey);
```

Кроме того, можно использовать ключ вместо пароля через [[\yii\base\Security::encryptByKey()]] и [[\yii\base\Security::decryptByKey()]].

Подтверждение целостности данных
-------------------------

Есть ситуации, в которых вам нужно убедиться, что ваши данные не были изменены третьей стороной или даже повреждены каким-либо образом. Yii обеспечивает простой способ для подтверждения целостности данных в виде двух вспомогательных функций.

Префикс данных генерируются из секретного ключа и данных:
```php
// $secretKey нашего приложения или пользователя, $genuineData полученые из надежного источника
$data = Yii::$app->getSecurity()->hashData($genuineData, $secretKey);
```

Проверка, нарушена ли целостность данных:

```php
// $secretKey - нашего приложения или пользователя, $data - данные полученные из ненадежного источника
$data = Yii::$app->getSecurity()->validateData($data, $secretKey);
```
