Работа с паролями
=================

Многие разработчики знают, что хранить пароль открытым текстом нельзя, но многие до сих пор считают безопасным
использование для хеширования паролей `md5` или `sha1`. Раньше упомянутых алгоритмов было достаточно, но современное
оборудование позволяет подобрать эти хеши очень быстро, методом простого перебора.

Для того, чтобы обеспечить повышенную безопасность паролей ваших пользователей даже в худшем случае (ваше
приложение взломано), нужно использовать алгоритм шифрования, устойчивый к атаке перебором. Лучший вариант в текущий
момент `bcrypt`. В PHP вы можете использовать хеши `bcrypt` через [функцию crypt](https://secure.php.net/manual/en/function.crypt.php).
Yii обеспечивает две вспомогательные функции, которые упрощают использование функции `crypt` для генерации и проверки
пароля.

Когда пользователь задаёт пароль (например во время регистрации), пароль должен быть захеширован:


```php
$hash = Yii::$app->getSecurity()->generatePasswordHash($password);
```

Хеш можно связать с соответствующим атрибутом модели, так чтобы он сохранялся в базе для последующего использования.

Когда пользователь попытается войти, отправленный пароль должен быть хеширован и сравнён с ранее сохранённым хешем:

```php
if (Yii::$app->getSecurity()->validatePassword($password, $hash)) {
    // всё хорошо, пользователь может войти
} else {
    // неправильный пароль
}
```
