Входные скрипты
===============

Входные скрипты это первое звено в процессе начальной загрузки приложения. Приложение (веб приложение или консольное приложение)
включает единый входной скрипт. Конечные пользователи делают запросы к входному скрипту,
который создает объекты приложения и перенаправляет запрос к ним.

Входные скрипты для веб приложений должны быть сохранены в папках, доступных из веб, таким образом они могут быть
доступны конечным пользователям. Такие скрипты обычно именуются `index.php`, но так же могут использовать другие имена,
которые могут быть распознаны используемыми веб-серверами.

Входные скрипты для консольных приложений обычно расположены в [базовой папке](structure-applications.md) приложений и имеют название 
`yii` (с суффиксом `.php`). Они должны иметь права на выполнение, таким образом пользователи смогут запускать консольные приложения 
через команду `./yii <маршрут> [аргументы] [опции]`.

Входные скрипты в основном делают следующую работу:

* Объявляют глобальные константы;
* Регистрируют загрузчик классов [Composer](https://getcomposer.org/doc/01-basic-usage.md#autoloading);
* Подключают файл класса [[Yii]];
* Загружают конфигурацию приложения;
* Создают и конфигурируют объект [приложения](structure-applications.md);
* Вызывают метод [[yii\base\Application::run()]] приложения для обработки входящего запроса.


## Веб приложения <span id="web-applications"></span>

Ниже представлен код входного скрипта для [базового шаблона приложения](start-installation.md).

```php
<?php

defined('YII_DEBUG') or define('YII_DEBUG', true);
defined('YII_ENV') or define('YII_ENV', 'dev');

// регистрация загрузчика классов Composer
require __DIR__ . '/../vendor/autoload.php';

// подключение файла класса Yii
require __DIR__ . '/../vendor/yiisoft/yii2/Yii.php';

// загрузка конфигурации приложения
$config = require __DIR__ . '/../config/web.php';

// создание и конфигурация приложения, а также вызов метода для обработки входящего запроса
(new yii\web\Application($config))->run();
```


## Консольные приложения <span id="console-applications"></span>

Ниже представлен аналогичный код входного скрипта консольного приложения:

```php
#!/usr/bin/env php
<?php
/**
 * Yii console bootstrap file.
 *
 * @link http://www.yiiframework.com/
 * @copyright Copyright (c) 2008 Yii Software LLC
 * @license http://www.yiiframework.com/license/
 */

defined('YII_DEBUG') or define('YII_DEBUG', true);

// регистрация загрузчика классов Composer
require __DIR__ . '/vendor/autoload.php';

// подключение файла класса Yii
require __DIR__ . '/vendor/yiisoft/yii2/Yii.php';

// загрузка конфигурации приложения
$config = require __DIR__ . '/config/console.php';

$application = new yii\console\Application($config);
$exitCode = $application->run();
exit($exitCode);
```


## Объявление констант <span id="defining-constants"></span>

Входные скрипты являются наилучшим местом для объявления глобальных констант. Yii поддерживают следующие три константы:

* `YII_DEBUG`: указывает работает ли приложение в отладочном режиме. Находясь в отладочном режиме, приложение будет собирать
  больше информации в логи и покажет детальный стек вызовов если возникнет исключение. По этой причине, отладочный режим должен
  быть использован только в процессе разработки. По-умолчанию значение `YII_DEBUG` равно `false`;
* `YII_ENV`: указывает в каком окружении запущено приложение. Данная тема подробно описана в разделе [Конфигурации](concept-configurations.md#environment-constants).
  По-умолчанию значение `YII_ENV` равно `'prod'`, означающие, что приложение запущено в производственном режиме;
* `YII_ENABLE_ERROR_HANDLER`: указывает нужно ли включать имеющийся в Yii обработчик ошибок. По-умолчанию значение данной константы
  равно `true`.

При определении константы, мы обычно используем следующий код:

```php
defined('YII_DEBUG') or define('YII_DEBUG', true);
```

который равнозначен коду, приведенному ниже:

```php
if (!defined('YII_DEBUG')) {
    define('YII_DEBUG', true);
}
```

Первый способ является более кратким и понятным.

Константы должны быть определены как можно раньше, в самом начале входного скрипта, таким образом они могут оказать влияние,
когда остальные PHP файлы будут подключены.
