Создание своей структуры приложения
=======================================

> Note: Этот раздел находится на стадии разработки.

Пока шаблоны проектов [basic](https://github.com/yiisoft/yii2-app-basic) и [advanced](https://github.com/yiisoft/yii2-app-advanced) великолепно справляются с большинством ваших потребностей, но вы можете захотеть создать свой собственный шаблон проекта, с которого будете начинать делать ваши проекты.

Шаблоны проектов в Yii - это просто репозитарии, содержащие `composer.json` файл, и зарегистрированные как Composer пакет.
Любые репозитарии, которые могут быть определены как Composer пакеты, становятся установочными через Composer команду `create-project`.

Чтобы построить весь свой шаблон с нуля, нужно затратить много энергии, поэтому лучше использовать один из встроенных шаблонов, как базовый.

Клонирование базового шаблона
----------------------------------------

Первый шаг для клонирования базового Yii шаблона из Git репозитария:

```bash
git clone git@github.com:yiisoft/yii2-app-basic.git
```

Затем необходимо подождать, чтобы репозитарии загрузился на ваш компьютер. С внесенными изменениями шаблон должен быть "запушен"(push) обратно, затем вы можете удалить `.git` директорию и весь загруженный контент на вашем компьютере.

Измените файлы
------------

Следующее, вам надо изменить `composer.json` в соответствии с вашим шаблоном. Измените значения `name`(имя), `description`(описание), `keywords`(ключевые слова), `homepage`(адрес домашней страницы), `license`(лицензия), и `support`(поддержка)
для описания вашего нового шаблона. Также установите `require`(зависимости фреимворка), `require-dev`(зависимости от расширений), `suggest`, и другие опции, которые необходимы для вашего шаблона.

> Note: В файле `composer.json` используйте `writable` параметр внутри `extra`, чтобы указать
> права доступа к файлам, которые будут установлены, после создания приложения на основе данного шаблона.

Следующее, измените структуру и содержание приложения, по вашему вкусу. В заключении обновите README файл, чтобы он соответствовал конечному варианту вашего шаблона.

Создание пакета
--------------

Создайте Git репозитарий из созданного шаблона, и запушьте(push) его. Если вы собираетесь сделать ваш шаблон с открытым исходным кодом, [Github](http://github.com) - это лучшее место, чтобы разместить его. Если вы собираетесь сохранить ваш шаблон для личных целей, используйте любой Git, предназначенный для этих целей.

Затем, вам необходимо зарегистрировать ваш пакет в Composer. Пакет с публичным шаблоном должен быть зарегистрирован на [Packagist](https://packagist.org/).
Для приватных шаблонов, зарегистрировать шаблона немного сложнее. Для получения инструкции загляните в [Composer documentation](https://getcomposer.org/doc/05-repositories.md#hosting-your-own).

Использование шаблона
------

Это все, что требуется для создания нового шаблона проекта в Yii. Сейчас вы можете создавать проекты, использующие ваш шаблон:

```
composer global require "fxp/composer-asset-plugin:^1.4.1"
composer create-project --prefer-dist --stability=dev mysoft/yii2-app-coolone new-project
```
