Робота із стороннім кодом
=========================

Час від часу, вам, можливо, буде потрібно використовувати деякий сторонній код в своїх Yii додатках.
Або ви маєте потребу використовувати Yii, як бібліотеку в деяких сторонніх системах.
У цьому розділі, ми покажемо як досягти цих цілей.


Використання сторонніх бібліотек в Yii <span id="using-libs-in-yii"></span>
--------------------------------------

Для використання сторонньої бібліотеки в Yii додатку, ви, в основному, повинні переконатися, що класи в бібліотеці
правильно підключені або можуть завантажуватися автоматично.

### Використання пакунків Composer <span id="using-composer-packages"></span>

Багато сторонніх бібліотек випущені у вигляді пакунків [Composer](https://getcomposer.org/).
Ви можете встановити такі бібліотеки, виконавши два прості кроки:

1. змінити файл `composer.json` вашого додатку і вказати, які пакунки Composer необхідно встановити.
2. виконати команду `composer install` для встановлення зазначених пакунків.

Класи встановлених пакунків Composer можуть бути автоматично завантажені, використовуючи автозавантажувача Composer.
Переконайтися, що [вхідний скрипт](structure-entry-scripts.md) вашого додатку містить наступні рядки для
встановлення автозавантажувача Composer:

```php
// встановлення автозавантажувача Composer
require __DIR__ . '/../vendor/autoload.php';

// підключення файлу класа Yii
require __DIR__ . '/../vendor/yiisoft/yii2/Yii.php';
```

### Використовуйте завантажені бібліотеки <span id="using-downloaded-libs"></span>

Якщо бібліотека не випущена в якості пакунку Composer, ви повинні слідувати згідно її інструкції по встановленню.
У більшості випадків, вам потрібно буде завантажити випущений файл вручну і розархівувати його в каталог `BasePath/vendor`,
де `BasePath` представляє собою [основний шлях](structure-applications.md#basePath) вашого додатку.

Якщо бібліотека використовує свій власний автозавантажувач класів, ви можете підключити його у
[вхідному скрипті](structure-entry-scripts.md) вашого додатку. Рекомендується підключити його перед тим, 
як буде підключено файл `Yii.php`, щоб автозавантажувач Yii мав приорітет при автоматичному завантаженні класів.

Якщо бібліотека не надає автозавантажувача класів, але іменування її класів відповідає
[PSR-4](http://www.php-fig.org/psr/psr-4/) - ви можете використовувати автозавантажувач Yii для завантаження її класів. 
Все, що вам потрібно зробити, це тільки оголосити [системний псевдонім](concept-aliases.md#defining-aliases) 
для кожного кореневого простору імен, що використовується в цих класах. Для прикаду, припустимо, що ви хочете встановити 
бібліотеку в каталог `vendor/foo/bar`, і класи бібліотеки знаходяться в кориневому просторі імен `xyz`.
Ви можете включити наступний код в конфігурації вашого додатку:

```php
[
    'aliases' => [
        '@xyz' => '@vendor/foo/bar',
    ],
]
```

Якщо жоден з варіантів не підійшов, цілком ймовірно, що для використання бібліотеки потрібно налаштувати в конфігурації
директиву PHP `include_path` для коректного пошуку та підключення файлів класів. 
Просто дотримуйтесь її інструкції з налаштування директиви PHP `include_path`.

В гіршому випадку, бібліотека вимагає явного підключення каждого файлу класу, тому ви можете використати наступний метод
для підключення класів за вимогою:

* Визначіть, які класи входять до складу бібліотеки.
* Перерахуйте класи і шляхи до відповідних файлів в `Yii::$classMap` у [вхідному скрипті](structure-entry-scripts.md)
  додатку. Наприклад,
```php
Yii::$classMap['Class1'] = 'path/to/Class1.php';
Yii::$classMap['Class2'] = 'path/to/Class2.php';
```


Використання Yii в сторонніх системах <span id="using-yii-in-others"></span>
-------------------------------------

Оскільки в Yii організовано безліч корисних функцій, іноді вони можуть знадобитися при розробці або розширенні сторонніх систем,
таких як WordPress, Joomla, або додатки, розроблені з використанням іншого PHP-фреймворку.
Наприклад, ви можете використовувати клас [[yii\helpers\ArrayHelper]] або можливості [Active Record](db-active-record.md)
в сторонніх системах. Для цього необхідно виконати два кроки: встановити Yii та bootstrap Yii.

Якщо стороння система використовує управління залежностями Composer, ви можете встановити Yii за допомогою наступних команд:

```bash
    composer global require "fxp/composer-asset-plugin:^1.4.1"
    composer require yiisoft/yii2
    composer install
```

Перша команда встановлює [composer asset plugin](https://github.com/francoispluchino/composer-asset-plugin/),
який дозволяє керувати залежностями пакунків Bower і NPM через Composer. Навіть якщо ви захочете використовувати тільки
прошарки бази даних або інші, не повʼязані ресурсами, можливості Yii, вам все-одно необхідно встановити даний пакунок composer.

Якщо ви бажаєте використовувати [можливість публікації ресурсів Yii](structure-assets.md),
вам також слід додати наступну конфігурацію до розділу `extra` вашого файлу `composer.json`:

```json
{
    ...
    "extra": {
        "asset-installer-paths": {
            "npm-asset-library": "vendor/npm",
            "bower-asset-library": "vendor/bower"
        }
    }
}
```

Дивіться також загальний [розділ про встановлення Yii](start-installation.md#installing-via-composer), для отримання додаткової
інформації про Composer та проблеми, які можуть виникнути під час встановлення.

В іншому випадку, ви можете [завантажити](http://www.yiiframework.com/download/) файли релізу Yii і розархівувати його
в каталог `BasePath/vendor`.

Далі вам необхідно змінити вхідний скрипт сторонньої системи помістивши на його початок наступний код:

```php
require __DIR__ . '/../vendor/yiisoft/yii2/Yii.php';

$yiiConfig = require __DIR__ . '/../config/yii/web.php';
new yii\web\Application($yiiConfig); // НЕ ВИКЛИКАЙТЕ run() в цьому місці
```

Як ви бачите, цей код дуже схожий на код [вхідного скрипта](structure-entry-scripts.md) типового додатку Yii.
Єдина відмінність заключається в тому, що після створення екземпляру додатку, метод `run()` не викликається.
Це звʼязано з тим, що при виклику `run()`, Yii захоплює контроль над процесом обробки запиту, що в даному випадку
не є потрібним, оскільки цю задачу виконує вже наявний додаток.

Як і у випадку з Yii додатком, вам необхідно налаштувати екземпляр додатку, виходячи із середовища запущеної сторонньої системи.
Наприклад, щоб скористатися можливостями [Active Record](db-active-record.md), необхідно налаштувати
[компонент додатку](structure-application-components.md) `db` з налаштування підключення бази данних,
яка використовується сторонньою системою.

Тепер ви можете використовувати більшість функцій фреймворку Yii. Наприклад, ви можете створювати класи Active Record і
використовувати їх для роботи з базами даних.


Використання Yii 2 з Yii 1 <span id="using-both-yii2-yii1"></span>
--------------------------

Якщо попередньо ви використовували Yii 1, цілком ймовірно, що у вас є робочий додаток Yii 1.
Замість того, щоб переписувати цілий додаток під Yii 2, ви можете просто його покращити, використовуючи деякі функції, 
що доступні тільки в Yii 2. Для цього потрібно виконати наступні дії.

> Note: Yii 2 вимагає версію PHP 5.4 або вищу. Переконайтися, що і сервер і наявний додаток підтримують її.

По-перше, встановіть Yii 2 до вашого поточного додатку, виконавши дії, описані в [попередньому підрозділі](#using-yii-in-others).

По-друге, змініть вхідний скрипт додатку наступним чином,

```php
// підключення модифікованого класу Yii, описаного нижче
require __DIR__ . '/../components/Yii.php';

// налаштування додатку Yii 2
$yii2Config = require __DIR__ . '/../config/yii2/web.php';
new yii\web\Application($yii2Config); // не викликайте run()

// налаштування додатку Yii 1
$yii1Config = require __DIR__ . '/../config/yii1/main.php';
Yii::createWebApplication($yii1Config)->run();
```

Оскільки Yii 1 та Yii 2 використовують клас `Yii`, вам необхідно створити модифіковану версію, щоб обʼєднати їх.
Наведений нижче код підключить модифікований файл класу `Yii`, який може бути створений наступним чином.

```php
$yii2path = '/path/to/yii2';
require $yii2path . '/BaseYii.php'; // Yii 2.x

$yii1path = '/path/to/yii1';
require $yii1path . '/YiiBase.php'; // Yii 1.x

class Yii extends \yii\BaseYii
{
    // скопіюйте та вставте код з YiiBase (1.x) сюди
}

Yii::$classMap = include($yii2path . '/classes.php');
// реєстрація автозавантажувача Yii 2 через Yii 1
Yii::registerAutoloader(['Yii', 'autoload']);
// створення контейнера впровадження залежностей
Yii::$container = new yii\di\Container;
```

От і все! Тепер в будь-якому місці коду можна використовувати конструкцію `Yii::$app` для отримання доступу до
екземпляру класу додатку Yii 2, а з допомогою конструкції `Yii::app()` - до екземпляру класу додатку Yii 1:

```php
echo get_class(Yii::app()); // виводить 'CWebApplication'
echo get_class(Yii::$app);  // виводить 'yii\web\Application'
```
