# Yii 文档风格指南

编写或编辑任何 Yii 文档时的准则。

*此文还需要扩展。*

## 总体风格

* 尽量使用主动语态。
* 使用简短的陈述性句子。
* 尽可能使用代码展示想法。
* 请勿使用“我们”。这指的是 Yii 开发团队或 Yii 核心团队。更好的是从框架或指南的角度来考虑。
* 使用牛津逗号（例如，“这个，那个，另一个”不是“这个，那个和另一个”）。

## 格式

* 使用 *斜体* 强调，不要大写，粗体或下划线。

## 列表

* 数字列表应该是以句号结尾的完整句子。
* 项目符号列表应该是以分号结尾的片段，除了最后一个项目，它应该以句点结尾。

## 块

块使用 Markdown 语法 `> Type: `。有四种块类型：

* `Warning`, 对于不安全的事情和其他问题
* `Note`, 强调关键概念，需要避免的事情
* `Info`, 一般资料（旁白）; 不如“注意”表达强烈
* `Tip`, 专业提示，附加提示，可能是有用的，但可能并非每个人都需要

冒号后的句子应以大写字母开头。

在翻译文档时，不应翻译这些 Block 标示符。
将它们保持原样并仅翻译块内容。
为了翻译 `Type` 这些词，每个指南翻译应该有一个 `blocktypes.json` 文件
并包含翻译。以下显示了德语的一个示例：

```json
{
    "Warning:": "Achtung:",
    "Note:": "Hinweis:",
    "Info:": "Info:",
    "Tip:": "Tipp:"
}
```

## 参考

* Yii 2.0 或 Yii 2（不能是 Yii2 或 Yii2.0）。
* 指南的每个“页面”都被称为“章节”。
* 代码对象的引用：
  - 请参阅使用完整的命名空间类：`yii\base\Model`
  - 即使它们不是静态的，也可以使用静态语法引用类属性：`yii\base\Model::$validators`
  - 即使它们不是静态的，也可以使用静态语法来引用类方法，并且使用括号来表示它是一种方法：`yii\base\Model::validate()`
  - 对代码对象的引用应该写在 `[[]]` 中以生成指向API文档的链接。 例如，`[[yii\base\Model]]`，`[[yii\base\Model::$validators]]`，或 `[[yii\base\Model::validate()]]`。

## 字母大小写

* Web，不是 web
* guide，不是 Guide

## 验证文档

以下脚本可帮助查找指南中的链接和其他问题：

查找无效的链接（可能会出现一些误报）：

    grep -rniP "\[\[[^\],']+?\][^\]]"  docs/guide*
    grep -rniP "[^\[]\[[^\]\[,']+?\]\]"  docs/guide*
    
## 译者的归属

翻译人员的姓名将在翻译版本的
指南的作者中列出。
因此，在每个指南目录中使用与英语不同的语言时，应创建一个“translators.json”文件，
其中包含参与翻译的人员的名称数组。

```json
[
  "Jane Doe",
  "John Doe"
]
```

如果您对翻译有重要贡献，请随时发送 pull request 并添加您的名字。