What is Yii
===========

Yii is a high performance, component-based PHP framework for rapidly developing modern Web applications.
The name Yii (pronounced `Yee` or `[ji:]`) means "simple and evolutionary" in Chinese. It can also
be thought of as an acronym for **Yes It Is**!


What is Yii Best for?
---------------------

Yii is a generic Web programming framework, meaning that it can be used for developing all kinds
of Web applications using PHP. Because of its component-based architecture and sophisticated caching
support, it is especially suitable for developing large-scale applications such as portals, forums, content
management systems (CMS), e-commerce projects, RESTful Web services, and so on.


How does Yii Compare with Other Frameworks?
-------------------------------------------

If you're already familiar with another framework, you may appreciate knowing how Yii compares:

- Like most PHP frameworks, Yii implements the MVC (Model-View-Controller) architectural pattern and promotes code
  organization based on that pattern.
- Yii takes the philosophy that code should be written in a simple yet elegant way. Yii will never try to
  over-design things mainly for the purpose of strictly following some design pattern.
- Yii is a full-stack framework providing many proven and ready-to-use features: query builders
  and ActiveRecord for both relational and NoSQL databases; RESTful API development support; multi-tier
  caching support; and more.
- Yii is extremely extensible. You can customize or replace nearly every piece of the core's code. You can also
  take advantage of Yii's solid extension architecture to use or develop redistributable extensions.
- High performance is always a primary goal of Yii.

Yii is not a one-man show, it is backed up by a [strong core developer team](http://www.yiiframework.com/team/), as well as a large community
of professionals constantly contributing to Yii's development. The Yii developer team
keeps a close eye on the latest Web development trends and on the best practices and features
found in other frameworks and projects. The most relevant best practices and features found elsewhere are regularly incorporated into the core framework and exposed
via simple and elegant interfaces.


Yii Versions
------------

Yii currently has two major versions available: 1.1 and 2.0. Version 1.1 is the old generation and is now in maintenance mode. Version 2.0 is a complete rewrite of Yii, adopting the latest
technologies and protocols, including Composer, PSR, namespaces, traits, and so forth. Version 2.0 represents the current
generation of the framework and will receive the main development efforts over the next few years.
This guide is mainly about version 2.0.


Requirements and Prerequisites
------------------------------

Yii 2.0 requires PHP 5.4.0 or above and runs best with the latest version of PHP 7. You can find more detailed
requirements for individual features by running the requirement checker included in every Yii release.

Using Yii requires basic knowledge of object-oriented programming (OOP), as Yii is a pure OOP-based framework.
Yii 2.0 also makes use of the latest features of PHP, such as [namespaces](https://secure.php.net/manual/en/language.namespaces.php)
and [traits](https://secure.php.net/manual/en/language.oop5.traits.php). Understanding these concepts will help
you more easily pick up Yii 2.0.

