# 後方互換性

私たちは `2.x.y.Z` のようなパッチ・リリースにおいては厳密に後方互換性を保持するように努めるとともに、
`2.x.Y` のようなマイナー・リリースにおいても修正が必要となるような後方互換性の無い変更を避けるように努めています。

バージョン番号については [Yii バージョン規約](versions.md) を参照して下さい。

## 使用

### インタフェイス

ユース・ケース | 後方互換?
-------------|----------
インタフェイスのタイプ・ヒント | Yes
インタフェイス・メソッドの呼び出し | Yes
**インタフェイスの実装における ...** |
メソッドの実装 | Yes
実装済みメソッドへの引数の追加 | Yes
引数のデフォルト値の追加 | Yes

### クラス

ユース・ケース | 後方互換?
-------------|----------
クラスのタイプ・ヒント | Yes
新しいインスタンスの作成 | Yes
クラスの拡張 | Yes
パブリック・プロパティへのアクセス | Yes
パブリック・メソッドの呼び出し | Yes
**クラスの拡張における ...** |
プロテクト・プロパティへのアクセス | Yes
プロテクト・メソッドの呼び出し | Yes
パブリック・プロパティのオーバーライド | Yes
プロテクト・プロパティのオーバーライド | Yes
パブリック・メソッドのオーバーライド | Yes
プロテクト・メソッドのオーバーライド | Yes
新しいプロパティの追加 | No
新しいメソッドの追加 | No
オーバーライドされたメソッドへの引数の追加 | Yes
引数のデフォルト値の追加 | Yes
プライベート・メソッドの呼び出し(リフレクション経由) | No
プライベート・プロパティへのアクセス(リフレクション経由) | No


## 開発

### インタフェイスの変更

変更のタイプ | 後方互換?
-------------|----------
削除 | No
名前または名前空間の変更 | No
親のインタフェイスの追加 | 新しいメソッドが追加されなければ Yes
親のインタフェイスの削除 | No
**インタフェイス・メソッド** | 
メソッドの追加 | No
メソッドの削除 | No
名前の変更 | No
親のインタフェイスへの移動 | Yes
デフォルト値を持たない引数の追加 | No
デフォルト値を持つ引数の追加 | No
引数の削除 | Yes (末尾の一つまたは複数の引数のみ)
引数のデフォルト値の追加 | No
引数のデフォルト値の削除 | No
引数のタイプ・ヒントの追加 | No
引数のタイプ・ヒントの削除 | No
引数の型の変更 | No
戻り値の型の変更 | No
**定数** |	 
定数の追加 | Yes
定数の削除 | No
定数の値の変更 | シリアライズされる可能性のあるオブジェクトを除いて Yes。UPGRADE.md への記載が必須

### クラス

変更のタイプ | 後方互換?
-------------|----------
削除 | No
final への変更 | No
abstract への変更 | No
名前または名前空間の変更 | No
親クラスの変更 | Yes ただし元の親クラスは祖先クラス(祖父母クラスなど)として残らなければならない
インタフェイスの追加 | Yes
インタフェイスの削除 | No
**パブリック・プロパティ** | 
パブリック・プロパティの追加 | Yes
パブリック・プロパティの削除 | No
可視性の低減 | No
親クラスへの移動 | Yes
**プロテクト・プロパティ** | 	 
プロテクト・プロパティの追加 | Yes
プロテクト・プロパティの削除 | No
可視性の低減 | No
親クラスへの移動 | Yes
**プライベート・プロパティ** | 
プライベート・プロパティの追加 | Yes
プライベート・プロパティの削除 | Yes
**コンストラクタ** | 
コンストラクタの削除 | No
パブリック・コンストラクタの可視性低減 | No
プロテクト・コンストラクタの可視性低減 | No
親クラスへの移動 | Yes
**パブリック・メソッド** |
パブリック・メソッドの追加 | Yes
パブリック・メソッドの削除 | No
名前の変更 | No
可視性の低減 | No
親クラスへの移動 | Yes
デフォルト値を持たない引数の追加 | No
デフォルト値を持つ引数の追加 | No
引数の削除 | Yes (末尾の一つまたは複数の引数のみ)
引数のデフォルト値の追加 | No
引数のデフォルト値の削除 | No
引数のタイプ・ヒントの追加 | No
引数のタイプ・ヒントの削除 | No
引数の型の変更 | No
戻り値の型の変更 | No
**プロテクト・メソッド** | 	 
プロテクト・メソッドの追加 | Yes
プロテクト・メソッドの削除 | No
名前の変更 | No
可視性の低減 | No
親クラスへの移動 | Yes
デフォルト値を持たない引数の追加 | No
デフォルト値を持つ引数の追加 | No
引数の削除 | Yes (末尾の一つまたは複数の引数のみ)
引数のデフォルト値の追加 | No
引数のデフォルト値の削除 | No
引数のタイプ・ヒントの追加 | No
引数のタイプ・ヒントの削除 | No
引数の型の変更 | No
戻り値の型の変更 | No
**プライベート・メソッド** | 	 
プライベート・メソッドの追加 | Yes
プライベート・メソッドの削除 | Yes
名前の変更 | Yes
デフォルト値を持たない引数の追加 | Yes
デフォルト値を持つ引数の追加 | Yes
引数の削除 | Yes
引数のデフォルト値の追加 | Yes
引数のデフォルト値の削除 | Yes
引数のタイプ・ヒントの追加 | Yes
引数のタイプ・ヒントの削除 | Yes
引数の方の変更 | Yes
戻り値の型の変更 | Yes
**スタティック・メソッド** | 
非スタティックなメソッドのスタティックへの変更 | No
スタティックなメソッドの非スタティックへの変更 | No
**定数** | 	 
定数の追加 | Yes
定数の削除 | No
定数の値の変更 | シリアライズされる可能性のあるオブジェクトを除いて Yes。UPGRADE.md への記載が必須
