Yii 2 寄稿者のための Git ワークフロー
=====================================

で、Yii の開発に貢献したい、と。すばらしい。 
でも、あなたの修正案が速やかに採用されるチャンスを増やすために、以下のステップを踏むようにしてください。
あなたが git と github については初めてだという場合は、最初に [github help](http://help.github.com/) や [try git](https://try.github.com) を精査したり、
[git internal data model](http://nfarina.com/post/9868516270/git-is-simpler) についていくらか学習したりする必要があるかもしれません。

あなたの開発環境を準備する
--------------------------

以下のステップを踏むと Yii の開発環境を作成し、それを使って Yii フレームワークのコア・コードに取り組むことが出来るようになります。
これらのステップは、あなたが最初に寄稿するときにだけ必要になります。

### 1. github で Yii リポジトリを [Fork](http://help.github.com/fork-a-repo/) し、あなたのフォークをあなたの開発環境にクローンする

```
git clone git@github.com:YOUR-GITHUB-USERNAME/yii2.git
```

Linux において、GitHub で GIT を設定するのに問題が生じたり、"Permission Denied (publickey)" のようなエラーが発生したりする場合は、
[setup your GIT installation to work with GitHub](http://help.github.com/linux-set-up-git/) に従ってください。

> Tip: あなたが Git に精通していない場合は、素晴らしい無料の [プロ Git ブック](https://git-scm.com/book/en/v2) を読むことをお勧めします。

### 2. メインの Yii リポジトリを "upstream" という名前でリモートとして追加する

Yii をクローンしたディレクトリ、通常は "yii2" に入って、以下のコマンドを打ち込みます。

```
git remote add upstream git://github.com/yiisoft/yii2.git
```

### 3. テスト環境を準備する <span id="prepare-the-test-environment"></span

以下のステップは、翻訳またはドキュメントだけに取り組みたい場合は、必要ではありません。

- `composer install` を実行して、依存パッケージをインストールします ([composer をグローバルにインストール](https://getcomposer.org/doc/00-intro.md#globally) したものと仮定しています)。

JavaScript を扱おうとしている場合は、

- `npm install` を実行して JavaScript テスト・ツール群とその依存ライブラリをインストールします ([Node.js と NPM のインストール](https://nodejs.org/en/download/package-manager/) は完了しているものとします)。

> Note: JavaScript のテストが依存している [jsdom](https://github.com/tmpvar/jsdom) ライブラリは、Node.js 4 以降を必要とします。
  Node.js 6 または 7 を使用することをより強く推奨します。

- `php build/build dev/app basic <fork>` を実行し、ベーシック・アプリケーションをクローンし、ベーシック・アプリケーションのための composer 依存パッケージをインストールします
  ここで `<fork>` は、`git@github.com:my_nickname/yii2-app-basic.git` のような、あなたのレポジトリのフォークの URL です。
  あなたがコア・フレームワークの貢献者である場合は、フォークの指定を省略しても構いません。このコマンドは外部 composer パッケージは通常どおりインストールしますが、yii2 レポジトリは現在チェックアウトされているものをリンクします。
  これで、インストールされる全てのコードについて、一つのインスタンスを持つことになります。
  
  必要であれば、アドバンスト・アプリケーションについても同様にします: `php build/build dev/app advanced <fork>`。
  
  このコマンドは後日、依存パッケージを更新するためにも使用されます。このコマンドは内部的に `composer update` を実行します。

> Note: デフォルトの git レポジトリの Url を使うため、SSH 経由で github からクローンすることになります。
> `build` コマンドに `--useHttp` フラグを追加すれば、代りに HTTP を使うことが出来ます。

**これであなたは Yii 2 をハックするための作業用の遊び場を手に入れました。**

以下のステップはオプションです。

### 単体テスト

レポジトリのルート・ディレクトリで `phpunit` を実行することによって単体テストを実行することが出来ます。
phpunit をグローバルにインストールしていない場合は、代りに `php vendor/bin/phpunit` を実行することが出来ます。

テストによっては、データベースの設定と構成が必要なものがあります。
`tests/data/config.local.php` を作成して、`tests/data/config.php` において構成されている設定を上書きすることが出来ます。

取り組んでいるグループのものだけにテストを限定することが出来ます。例えば、バリデータと redis のためのテストだけを走らせるためには、`phpunit --group=validators,redis` とします。
利用できるグループのリストを取得するためには、`phpunit --list-groups` を実行してください。

JavaScript の単体テストは、レポジトリのルート・ディレクトリで `npm test` を走らせることによって実行することが出来ます。

### エクステンション

エクステンションに取り組むためには、エクステンションのレポジトリをクローンする必要があります。私たちは、あなたに代ってそれをするコマンドを作っています。

```
php build/build dev/ext <extension-name> <fork>
```

ここで `<extension-name>` がエクステンションの名前、例えば `redis` です。そして `<fork>` は、`git@github.com:my_nickname/yii2-redis.git` のような、あなたのエクステンションのフォークの URL です。あなたがコア・フレームワークの貢献者である場合は、フォークの指定を省略しても構いません。

エクステンションをアプリケーション・テンプレートのどちらかでテストしたい場合は、通常そうするように、アプリケーションの `composer.json` にそれを追加するだけです。
例えば、ベーシック・アプリケーションの `require` セクションに `"yiisoft/yii2-redis": "~2.0.0"` を追加します。
`php build/build dev/app basic <fork>` を実行すると、エクステンションとその依存パッケージがインストールされ、`extensions/redis` に対するシンボリック・リンクが作成されます。
こうすることで、composer の vendor ディレクトリではなく、直接に yii2 のレポジトリで作業をすることが出来るようになります。

> Note: デフォルトの git レポジトリの Url を使うため、SSH 経由で github からクローンすることになります。
> `build` コマンドに `--useHttp` フラグを追加すれば、代りに HTTP を使うことが出来ます。


バグ修正と機能改良に取り組む
----------------------------

上記で説明したように開発環境の準備を完了すれば、機能改良やバグ修正の取り組みを開始することが出来るようになります。

### 1. あなたが取り組もうとする問題が、修正するために著しい努力を要求するものである場合は、それに対する課題 (issue) が作成されていることを確認する

全ての新機能とバグ修正は、議論とドキュメントのための単一の参照ポイントを提供するために、それに結びつく課題 (issue) を持つべきです。
数分間時間を取って、既存の課題リストに目を通し、あなたが寄稿しようとしている問題に合致するものが無いかどうか調べてください。
もし課題リストにすでに挙っているのを見つけた場合は、その課題にコメントを残して、あなたがその項目について取り組もうとしていることを示してください。
あなたが取り組もうとしている問題に合致する既存の課題が見つからなかった場合は、[新しい課題を立て](report-an-issue.md) てください。
単純な修正であれば、直接にプル・リクエストをしてください。
こうすることで、開発チームはあなたの提案をレビューし、将来にわたって適切なフィードバックを提供することが可能になります。

> 小さな変更や、ドキュメントの問題、または単純な修正については、課題を作成する必要はありません。それらについては、プル・リクエストだけで十分です。

### 2. メインの Yii ブランチから最新のコードをプルする

```
git pull upstream
```

最新のコードに対して作業することを保証するために、すべての新しい寄稿においてこのステップから作業を開始すべきです。

### 3. 現在の Yii のマスター・ブランチに基いて、あなたの寄稿のための新しいブランチを作成する

> これは非常に重要です。なぜなら、master ブランチを使うと、
  あなたのアカウントからは一つ以上のプル・リクエストを送信することが出来なくなるからです。

独立したバグ修正や変更は、各々、それ自身のブランチに入れるべきです。
ブランチの名前は説明的なものにし、あなたのコードが関係する課題の番号で始まるようにしてください。
特定の課題を修正するものでない場合は、番号を省略してください。例えば、

```
git checkout upstream/master
git checkout -b 999-name-of-your-branch-goes-here
```

### 4. あなたの魔法を使って、あなたのコードを書く

動くことを確認してくださいね :)

単体テストは常に歓迎されます。テストされ、十分にカバーされたコードは、あなたの寄稿をチェックするタスクを非常に単純化してくれます。
単体テストの失敗を中身とする課題を立てることも許容されています。

### 5. CHANGELOG を更新する

CHANGELOG ファイルを編集して、あなたの修正を追加します。新しい行は、ファイル冒頭の最初の見出し (現在開発中のバージョン) の下に挿入してください。
チェンジログの行は、下記のどちらかのように書いてください。

```
Bug #999: バグ修正の内容説明 (あなたの名前)
Enh #999: 機能拡張の内容説明 (あなたの名前)
```

`#999` は `Bug` または `Enh` が参照している課題番号です。
チェンジ・ログは、タイプ (`Bug`, `Enh`) によってグループ化し、課題番号順に並べます。

非常に小さな修正、すなわち、タイポやドキュメントの修正については、CHANGELOG を更新する必要はありません。

### 6. 修正をコミットする

以下のコマンドを使って、コミットしたいファイルや変更を [staging area](http://git.github.io/git-reference/basic/#add) に追加します。

```
git add path/to/my/file.php
```

`-p` オプションを使って、コミットに含める変更を選択することも出来ます。

説明的なコミット・メッセージを付けて修正をコミットしてください。
github があなたのコミットを自動的にチケットとリンクするように、必ず `#XXX` でチケット番号に言及してください。

```
git commit -m "#999 を解決する変更の短い説明をここに入れる"
```

### 7. 最新の Yii コードを upstream からあなたのブランチにプルする

```
git pull upstream master
```

このステップは、プル・リクエストを出す前にあなたのブランチが最新のコードを持っていることを確実にするためのものです。
もし何かマージ衝突がある場合は、ここでそれを修正してから再度変更をコミットすべきです。
こうすると、Yii 開発チームがワン・クリックであなたの変更をマージすることが確実に出来るようになります。

### 8. 衝突をすべて解決したら、あなたのコードを github にプッシュする

```
git push -u origin 999-name-of-your-branch-goes-here
```

`-u` パラメータによって、今後はあなたのそのブランチが github のブランチに対して自動的にプッシュおよびプルされるようになります。
つまり、次回 `git push` とタイプしたときには、git は既にどこにプッシュすればよいか知っている、ということです。
こうしておくと、後でプル・リクエストにコミットを追加したくなった場合に便利です。

### 9. upstream に対して [プルリクエスト](https://help.github.com/articles/creating-a-pull-request-from-a-fork/) を発行する

github 上のあなたのリポジトリに入って、"Pull Request" をクリックし、右側にあるブランチを選び、
コメント・ボックスにもう少し詳細を記述します。
プル・リクエストを課題とリンクさせるために、プル・コメントのどこかに `#999` という書式で課題番号を記載します。

> 全てのプル・リクエストはそれぞれ一つの課題を解決すべきものであることに注意してください。

### 10. 誰かがあなたのコードをレビューする

誰かがあなたのコードをレビューします。あなたは修正を求められるかも知れません。その場合は、ステップ #6 に戻ってください
(現在のプル・リクエストが open である限りは、別の新しいプル・リクエストをする必要はありません)。あなたのコードが受け入れられた場合は、コードはメイン・ブランチにマージされて、次回の Yii のリリースの一部となります。
受け入れられなくても、落胆しないでください。必要とする機能は人によってさまざまに異なりますし、Yii は全ての人に対して全てを提供することは出来ません。
また、却下された場合でも、あなたのコードはそれを必要とする人々から参照されるように github 上で公開され続けます。

### 11. クリーンアップする

あなたのコードが受け入れられるか却下されるかした後、あなたが作業してきたブランチをローカル・レポジトリおよび 
`origin` から削除することが出来ます。

```
git checkout master
git branch -D 999-name-of-your-branch-goes-here
git push origin --delete 999-name-of-your-branch-goes-here
```

### 注意:

退行 (regression) を早期に発見するために、github 上の Yii コード・ベースへのマージは、すべて [Travis CI](http://travis-ci.com) に取り上げられて、自動化されたテストにかけられます。
コア・チームとしては、このサービスに過大な負担をかけたくないために、以下の場合にはマージの説明に 
[`[ci skip]`](https://docs.travis-ci.com/user/customizing-the-build/#Skipping-a-build) が含まれるようにしてください。
すなわち、プル・リクエストが下記のものである場合がそうです。

* javascript、css または画像ファイルだけに影響する場合
* ドキュメントを更新する場合
* 固定の文字列だけを修正する (例えば、翻訳をアップデートする) 場合

このようにすることによって、そもそもテストによってカバーされない変更に対しては、travis がテスト・ランを開始しないようにすることが出来ます。

### コマンド概要 (上級の寄稿者向け)

```
git clone git@github.com:YOUR-GITHUB-USERNAME/yii2.git
git remote add upstream git://github.com/yiisoft/yii2.git
```

```
git fetch upstream
git checkout upstream/master
git checkout -b 999-name-of-your-branch-goes-here

/* 魔法を使い、必要なら changelog を更新 */

git add path/to/my/file.php
git commit -m "A brief description of this change which fixes #999 goes here"
git pull upstream master
git push -u origin 999-name-of-your-branch-goes-here
```
