Проектні рішення
================

Цей документ перелічує проектні рішення, які були прийняті командою розробників після широких дискусій.
Допоки немає дуже вагомих причин, ці рішення повинні дотримуватись для узгодженості. Для будь-якої зміни
у цих рішеннях необхідно отримати згоду команди головних розробників.

1. **[Коли підтримувати псевдоніми шляху?](https://github.com/yiisoft/yii2/pull/3079#issuecomment-40312268)**
   Псевдоніми шляху повинні підтримуватися для властивостей, які можна сконфігурувати, тому-що використання псевдонімів шляху
   у конфігураціях дуже зручно. В інших випадках, потрібно обмежувати підтримку псевдонімів шляху.
2. **Коли перекладати повідомлення?**
   Повідомлення повинні перекладатись, якщо вони показуються кінцевому користувачу та мають для нього значення. Повідомлення статусу HTTP,
   виключення і т. п. не повинні перекладатись. Повідомлення консолі завжди англійською мовою, через труднощі обробки кодування
   та кодової сторінки.
3. **[Додавання підтримки нового клієнту аутентифікації](https://github.com/yiisoft/yii2/issues/1652)**
   Для кращого супроводу, ніякі додаткові клієнти аутентифікації не будуть додаватись до базового розширення. Вони
   повинні бути виконані у вигляді користувацьких розширень.
4. **При використанні замикань**, рекомендується **вказувати всі параметри, які передаються**, у сигнатурі, навіть, якщо не всі з них
   використовуються. Таким чином змінювати чи копіювати код легше, тому-що вся інформація перед очима та нема потреби переглядати
   документацію для пошуку доступних параметрів. ([#6584](https://github.com/yiisoft/yii2/pull/6584), [#6875](https://github.com/yiisoft/yii2/issues/6875))
5. Надавайте перевагу **int замість unsigned int** у схемі бази даних. Використання int має перевагу, бо може бути представлене в PHP як число.
   Щоб представити unsigned, для 32-розрядної системи необхідно використовувати текстовий рядок.
   Але також unsigned int подвоює діапазон позитивних чисел. Якщо у вас є таблиця, яка потребує такий великий числовий простір,
   то безпечніше використовувати bigint або mediumint, а не покладатися на unsigned.
   <https://github.com/yiisoft/yii/pull/1923#issuecomment-11881967>
