Процес перекладу
================

Yii перекладається на багато різних мов, щоб бути корисним для міжнародних додатків та розробників. Основними двома областями,
де вітається співпраця є документація та повідомлення фреймворку.

Повідомлення фреймворку
-----------------------

Фреймворк має два типи повідомлень: виключення, які призначені для розробників й ніколи не перекладаються, та повідомлення
видимі кінцевому користувачу, такі як помилки перевірки.

Щоб розпочати переклад повідомлень необхідно:

1. Перейти до директорії `framework` та виконати команду `./yii message/extract @yii/messages/config.php --languages=uk`.
2. Перекласти повідомлення у файлі `framework/messages/uk/yii.php`. Зберегти файл у кодуванні UTF-8.
3. [Відправити "pull request"](git-workflow.md).

Для підтримання перекладу в актуальному стані можна знову використовувати команду `./yii message/extract @yii/messages/config.php --languages=uk`.
Це автоматично здобуде нові повідомлення, зберігаючи при цьому вже перекладені.

У файлі перекладу кожний ключ елементу масиву представляє повідомлення, а значення елементу масиву представляє переклад.
Якщо значення порожнє, повідомлення вважається не перекладеним. Переклади повідомлень, які вже не потребують перекладу,
замкнуті між парами знаків '@@'. Текст перекладу може містити формат кількох форм множини.
Ознайомтесь з розділом посібника [Інтернаціоналізація](../guide-uk/tutorial-i18n.md) для більш детальної інформації.

Документація
------------

Переклад документації знаходиться у `docs/<original>-uk`, де `<original>` відповідає оригінальній директорії,
наприклад `guide` або `internals`.

Після завершення розпочатої роботи можна отримати звіт про стан перекладу за допомогою виклику спеціальної команди з
директорії `build`:

```
php build translation "../docs/guide" "../docs/guide-uk" "Ukrainian guide translation report" > report_guide_uk.html
```

У разі необхідності встановіть [Composer](https://getcomposer.org/) в кореневій директорії вашого локального репозиторію.

### Список документів

Перелік документів, що потребують перекладу, можна знайти за нижченаведеними посиланнями:

- [список документів для guide-uk](https://ethercalc.org/yii2.docs.guide-uk);
- [список документів для internals-uk](https://ethercalc.org/yii2.docs.internals-uk).

Перед тим, як розпочати переклад, переконайтесь, що їм ніхто не займається, та запишіть себе у списку документів.

В залежності від прогресу оберіть відповідний статус перекладу:
- В роботі — переклад готується перекладачем до відправлення "pull request";
- Ревізія — відправлений переклад перевіряється ревізором;
- Перекладено — переклад прийнято до головної (master) гілки проекту.

За додатковою інформацією можете звертатись до учасників української [команди перекладачів](../internals/translation-teams.md).

### Переклад зображень

Зображення до документації знаходяться у вкладеній директорії `images`. Усі вони створенні програмою [yED](http://www.yworks.com/en/products/yfiles/yed/).
При необхідності перекладу оригінальний файл копіюється в директорію `images` перекладу, перекладається та зберігається у форматі png.

Перелік зображень, що потребують перекладу, можна знайти за нижченаведеним посиланням:

- [список зображень для guide-uk](https://ethercalc.org/yii2.docs.guide-uk.images).

### Переклад спеціальних повідомлень

- Tip → Підказка
- Note → Примітка
- Info → Інформація
- Warning → Попередження

### Список термінів

[Англійсько-українські словники](http://e2u.org.ua)

- action — дія;
- Active Record — (не перекладається);
- Advanced/Basic Project Template — Розширений/Базовий шаблон проекту;
- alias — псевдонім;
- alphanumeric — буквено-цифровий;
- (Web) application — (веб-)додаток;
- assignment — призначення;
- attach handler — приєднати обробник;
- attribute of the model — атрибут моделі;
- authentication — аутентифікація / установлення справжності;
- authorization — авторизація/уповноваження;
- autoloader — автозавантажувач;
- back-end — (не перекладається);
- backward compatibility / BC — зворотна сумісність;
- bootstrap, bootstrapping — початкове завантаження;
- branch — гілка;
- browser — браузер;
- (asset) bundle — колекція (ресурсів);
- cache, caching — кеш, кешування;
- camel case — (не перекладається);
- case-sensitive — регістр-залежний;
- column — колонка;
- commit — комміт;
- concatenation — конкатенація;
- configuration — конфігурація;
- content — вміст;
- content view — вкладене представлення;
- contributor — учасник;
- cookies — кукі;
- customization — (тонке) налаштування;
- debug mode — режим налагодження (див. production mode);
- debugger — налагоджувач;
- (function) declaration — оголошення (функції);
- definition — визначення;
- design pattern — шаблон проектування;
- development mode — режим розробки;
- (root) directory — (коренева) директорія;
- eager loading — жадібне завантаження (див. lazy loading);
- email address — адреса електронної пошти;
- environment — середовище;
- exception — виключення;
- existing — наявний/присутній; // перекладати як "існуючий" не вірно
- (PHP) extension — розширення (PHP);
- Facebook — Фейсбук;
- field (of the table) — поле/атрибут (таблиці);
- fixture — фікстура;
- folder — папка/каталог;
- footer — футер;
- fork — форк;
- formatter — форматтер;
- framework — фреймворк;
- front-controller — фронт-контролер;
- front-end — (не перекладається);
- getter — геттер;
- (event) handler — обробник (події);
- hash — хеш;
- header — шапка;
- help — довідка;
- helper — хелпер;
- id — ідентифікатор;
- image — зображення;
- initialize — ініціалізувати/встановлювати;
- to initiate — ініціювати/розпочинати;
- instance — екземпляр;
- instantiate — створювати екземпляр;
- issue — питання/проблема; // в залежності від контексту
- layout — макет;
- lazy loading — відкладене завантаження;
- log, logging — журнал, журналювання;
- markdown — (не перекладається);
- method — метод (обʼєкта/класу);
- merge — поєднання;
- Model-View-Controller (MVC) — Модель-Представлення-Контролер (MVC);
- namespace — простір імен;
- out of the box — "з коробки";
- package — пакунок;
- pagination — розділення на сторінки;
- parameter — параметр;
- to parse — обробляти;
- (application) performance — швидкодія (додатка);
- placeholder — заповнювач;
- plugin — плагін;
- postprocessing — після-обробка;
- predefined — попередньо визначений;
- production mode — робочий режим (див. debug mode);
- profiling — профілювання;
- property — властивість (обʼєкта);
- pull request — (не перекладається);
- query builder — конструктор запитів;
- refactoring — рефакторинг;
- to render, rendering — формувати, формування;
- related, relation — повʼязаний, звʼязок;
- release — реліз;
- repo, repository — репозиторій;
- resolve request — попередня обробка запиту;
- route, routing — маршрут, маршрутизація;
- row (of the table) — рядок (таблиці);
- screenshot — знімок екрану;
- Service Locator — Локатор служб;
- setter — сеттер;
- shared hosting — віртуальний хостинг;
- (call) stack — стек (викликів);
- staging area — буферна зона;
- standalone — автономний;
- string — текстовий рядок;
- sub-directory — під-директорія;
- substitution — підставлення/заміщення;
- tabular input — табличний ввід;
- tag — тег;
- template engine — шаблонізатор;
- theming — темізація;
- third party — сторонній;
- thumbnail — мініатюра;
- tracing — трасування;
- trait — трейт;
- trigger event — породжувати подію;
- Twitter — Твіттер;
- Unicode — (не перекладається);
- unit tests — модульні тести;
- to validate — перевіряти;
- valid — коректний;
- validator — валідатор;
- validation — перевірка;
- validator class — клас валідатора;
- versioning — версіонування;
- widget — віджет.
