Версіонування Yii
=================

Цей документ описує політику призначення версій Yii. Поточна стратегія призначення версій
базується на [ferver](https://github.com/jonathanong/ferver), це за думкою розробників є більш практичним
та розумним рішенням, ніж використання [semver](http://semver.org/) (див. [#7408](https://github.com/yiisoft/yii2/issues/7408) для довідки).

У колі головних розробників неодноразово підкреслювалась важливість зберігати зворотну сумісність релізів 2.0.x на 100%.
Але це ідеалістичний план. Стаття про ferver доводить, що досягнути цього на практиці дуже важко,
не зважаючи на те, використовується semver чи ні.

Загалом, політика призначення версій наступна:

## Патч-релізи `2.x.Y`

Патч-релізи, які мають бути на 100% зворотно сумісними. В ідеалі, вони містять лише виправлення помилок, що зменшує
можливість порушення зворотної сумісності. На практиці, релізи починаючи з 2.0.x стали частішими та зазвичай містять невеликі доповнення,
що дає можливість користувачам почати використовувати ці зміни раніше.

* Підтримуються у гілці `2.x`
* Переважно містять виправлення помилок та невеликі покращення
* Відсутні великі зміни та доповнення
* 100%-ва зворотна сумісність, що гарантує оновлення без проблем. Виключенням можуть бути лише проблеми безпеки, які потребують порушення зворотної сумісності
* Цикл релізу близько 1-2 місяців
* Не має необхідності у пре-релізах (альфа, бета, реліз-кандидат)
* Регулярно обʼєднуються з головною (master) гілкою (щонайменш раз у тиждень вручну)


## Молодші (мінорні) релізи `2.X.0`

Зворотно несумісні релізи, що містять великі доповнення та зміни, які можуть порушувати зворотну сумісність. Оновлення з ранніх версій
може бути не простим, але у наявності повна інструкція по оновленню або навіть скрипт.

* Розроблюються у головній (майстер) гілці
* Переважно містять нові доповнення та виправлення помилок
* Містять невеликі доповнення та виправлення помилок з патч-релізів
* Можуть мати зворотно несумісні зміни, які записуються у файл `UPGRADE-2.X.md`
* Цикл релізу близько 6-8 місяців
* Необхідні пре-релізи: `2.X.0-alpha`, `2.X.0-beta`, `2.X.0-rc`
* Потребують маркетингових зусиль та публікування у головних новинах


## Основні (мажорні) релізи `X.0.0`

Це наче 2.0 після 1.0. Такий перехід, вірогідніше, буде не частіше ніж кожні 3-5 років, у звʼязку з просуванням сторонніх технологій
(наприклад, оновлення PHP з 5.0 до 5.4).

> Примітка: Офіційні розширення використовують таку ж саму політику призначення версій, але можуть публікуватись незалежно від
фреймворку, тобто номера версій фреймворку та розширення не повинні обовʼязково збігатися.
