<?php
/**
 * 云端设置
 */
$title = '云端设置';
include "header.php";

?>
<div class="row">
    <div class="col-xl-12">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-12">
                        <h3 class="mb-3 header-title text-success"><?= $title ?></h3>
                        <form class="form-horizontal layui-form">
                            <div class="form-group mb-3">
                                <label for="example-input-normal" style="font-weight: 500">服务端接口 <span class="badge badge-primary-lighten" onclick="ping()">节点连通率检测</span></label>
                                <select class="custom-select mt-3" id="api_Interface" lay-search name="Interface">
                                    <option <?= $conf['Interface'] == 1 ? 'selected' : '' ?> value="1">国内接口1[江苏](国内快)</option>
                                    <option <?= $conf['Interface'] == 2 ? 'selected' : '' ?> value="2">国内接口2(上海)(国内快)</option>
                                    <option <?= $conf['Interface'] == 3 ? 'selected' : '' ?> value="3">国内接口3(北京)(国内快)</option>
                                    <option <?= $conf['Interface'] == 4 ? 'selected' : '' ?> value="4">国内接口4(成都)</option>
                                    <option <?= $conf['Interface'] == 5 ? 'selected' : '' ?> value="5">国内接口5(西安)</option>
                                    <option <?= $conf['Interface'] == 6 ? 'selected' : '' ?> value="6">国内接口6(青岛)</option>
                                    <option <?= $conf['Interface'] == 7 ? 'selected' : '' ?> value="7">国内接口7(深圳)(国内快)</option>
                                    <option <?= $conf['Interface'] == 8 ? 'selected' : '' ?> value="8">国外接口1(美国)</option>
                                    <option <?= $conf['Interface'] == 9 ? 'selected' : '' ?> value="9">国外接口2(美国)</option>
                                    <option <?= $conf['Interface'] == 10 ? 'selected' : '' ?> value="10">国外接口3(美国)(国外快)</option>
                                    <option <?= $conf['Interface'] == 11 ? 'selected' : '' ?> value="11">国外接口4(美国)</option>
                                </select>
                            </div>
                            <button type="submit" lay-submit lay-filter="Web_editor"
                                    class="btn btn-block btn-xs btn-danger">保存内容
                            </button>
                        </form>
                        <a href="https://cdn.api.ln.cn/api/wxapi/view/" target="_blank" style="display: block;margin-top:1em"><span class="badge badge-success-lighten">云端控制台</span></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<?php include "bottom.php"; ?>

<script>
    layui.use('form', function () {
        var form = layui.form;
        form.on('submit(Web_editor)', function (data) {
            layer.alert('是否要执行当前操作？', {
                icon: 3, btn: ['确定', '取消'], btn1: function (layero, index) {
                    var index = layer.msg('数据保存中,请稍后...', {icon: 16, time: 999999});
                    $.post('ajax.php?act=config_set', data.field, function (res) {
                        if (res.code == 1) {
                            layer.close(index);
                            layer.alert(res.msg, {
                                btn1: function (layero, index) {
                                    location.reload();
                                }
                            });
                        } else {
                            layer.close(index);
                            layer.alert(res.msg, {
                                btn1: function (layero, index) {
                                    location.reload();
                                }
                            });
                        }
                    });
                }
            });
            return false;
        })
    });
    function ping() {
        var index = layer.msg('正在检测['+$("#api_Interface option:selected").text()+']接口状态,请稍后...', {icon: 16, time: 999999});
        $.post('ajax.php?act=api_ping',{aid:$("#api_Interface option:selected").val()}, function (res) {
            if (res.code == 1) {
                layer.close(index);
                layer.alert(res.msg, {
                    icon:1,
                    anim:3,
                    title:$("#api_Interface option:selected").text()+"检测结果:"
                });
            } else {
                layer.close(index);
                layer.alert(res.msg, {
                    icon:2,
                    anim:4
                });
            }
        });
    }
</script>


