<?php
/**
 * 同系统商品克隆
 */
$title = '同系统商品克隆';
include "header.php";
?>
<div class="row">
    <div class="col-xl-12">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-12">
                        <h3 class="mb-3 header-title text-success"><?= $title ?></h3>
                        <p class="text-danger">
                            请根据文字提示来配置参数！
                        </p>
                        <form class="form-horizontal layui-form">
                            <div class="form-group mb-3">
                                <label for="example-input-normal" style="font-weight: 500">历史订单</label>
                                <select class="custom-select mt-3" name="type">
                                    <option value="1">清空旧订单+支付记录(重新开始)</option>
                                    <option value="2">保留旧订单+支付记录(订单和商品会对不上)</option>
                                </select>
                            </div>

                            <div class="form-group mb-3">
                                <label for="example-input-normal" style="font-weight: 500">对方域名</label>
                                <div class="input-group">
                                    <input type="text" name="url" lay-verify="required"
                                           class="form-control" value="" id="url"
                                           placeholder="需输入http://，填写完整域名路径！">
                                    <div class="input-group-append">
                                        <a href="javascript:text($('#url').val())" class="input-group-text"
                                           style="cursor: pointer;background-color: #a8f46b;color: white">测试链接可用性</a>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group mb-3">
                                <label for="example-input-normal" style="font-weight: 500">克隆密钥</label>
                                <div class="input-group">
                                    <input type="text" name="token" lay-verify="required"
                                           class="form-control" value=""
                                           placeholder="请输入克隆密钥,由对方站点提供！">
                                </div>
                            </div>
                            <button type="submit" lay-submit lay-filter="hy"
                                    class="btn btn-block btn-xs btn-success">开始克隆站点商品
                            </button>
                        </form>

                        <span class="mt-3" style="display: block">我的克隆密钥：<span
                                    class="badge badge-danger"
                                    onclick="layer.alert('我的域名：<br><?= is_https(false) . href() . '/<br>' ?>克隆密钥：<br><?= cloning::token() ?><br><br><font color=red>可通过修改对接货源信息来修改克隆密钥！</font>',{title:'我的克隆密钥'})">点击查看</span><br>
                        克隆须知：克隆站点不会克隆到对方的自营，卡密，CURL接口对接商品，只会克隆到对方的货源对接商品和分类，并且若是对方关闭了商品的克隆权限，将会无法克隆已经关闭权限的商品！
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<?php include "bottom.php"; ?>

<script>
    layui.use('form', function () {
        var form = layui.form;
        form.on('submit(hy)', function (data) {
            layer.alert('是否要克隆当前填写域名，克隆成功后将会清空当前商品/社区/分类数据？', {
                icon: 3, btn: ['确定', '取消'], btn1: function (layero, index) {
                    var index = layer.msg('数据加载中,请稍后...', {icon: 16, time: 999999});
                    $.post('ajax.php?act=cloning_reception', data.field, function (res) {
                        if (res.code == 1) {
                            layer.alert(res.msg, {
                                title: '恭喜你,克隆成功！', end: function (layero, index) {
                                    location.href = 'admin.source.list.php'
                                }
                            });
                        } else layer.alert(res.msg)
                    });
                }
            });
            return false;
        })
    });

    function text(url) {
        var index = layer.msg('正在测试,请稍后...', {icon: 16, time: 999999});
        $.post('ajax.php?act=cloning_availability', {url: url}, function (res) {
            if (res.code == 1) {
                layer.msg(res.msg, {icon: 1, anim: 4})
            } else {
                layer.msg(res.msg, {icon: 2, anim: 3})
            }
            layer.close(index);
        });
    }
</script>


