<?php
/**
 * 发卡商品
 */
$title = '卡密管理';
include "header.php";
$sum = 8; #每页数量
$page = shop::page($sum, $_QET['page']); #取出翻页数据
$khamwi_list = shop::khamwi_list($sum, $page['count'], $page['limit'], $_QET['gid'], $_QET['query']); #获取库存卡密列表
$paging = shop::paging($khamwi_list['count'], $_QET['page']); #取出翻页按钮数据
if (isset($_QET['gid'])) {
    $_QET['gid'] = (int)$_QET['gid'];
    $gid_data = $DB->get_row("SELECT * FROM `sky_goods` WHERE gid = '{$_QET['gid']}' ");
    if (!$gid_data) show_msg('温馨提示', '商品不存在！');
}

$rec = $DB->query("SELECT * FROM `sky_goods` WHERE `sqid` = '-3' ORDER BY `sort` DESC ");
$gid_arr = [];
while ($res = $DB->fetch($rec)) {
    $count = $DB->count("SELECT count(*) FROM `sky_token` WHERE `gid` = '{$res['gid']}' AND `endtime` is null ");
    if ($count == 0) $count = 0;
    $gid_arr[] = ['gid' => $res['gid'], 'name' => $res['name'], 'state' => $res['state'], 'count' => $count];
}

if (!empty($_QET['unset'])) {
    $a = $DB->query("DELETE FROM `sky_token` WHERE (`kid`='{$_QET['unset']}')"); #删除
    if ($a) {
        show_msg('成功提示', '编号:' . $_QET['unset'] . '删除成功,请点击下方按钮返回', '1');
    } else show_msg('温馨提示', '编号:' . $_QET['unset'] . '删除失败,原因->' . $DB->error(), '2');
}
?>
<!-- third party css -->
<link href="<?= $cdnserver == null ? '../' : $cdnserver ?>assets/css/vendor/dataTables.bootstrap4.css" rel="stylesheet"
      type="text/css"/>
<link href="<?= $cdnserver == null ? '../' : $cdnserver ?>assets/css/vendor/responsive.bootstrap4.css" rel="stylesheet"
      type="text/css"/>
<!-- third party css end -->
<!-- App css -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-sm-6 text-center">
                        <a <?= $gid_data['name'] == '' ? '' : 'href="./admin.goods.token.php"' ?>
                           class="btn btn-outline-danger mb-2">
                            <?= $gid_data['name'] == '' ? '请选择商品' : $gid_data['name'] . '- 查看全部' ?>
                        </a>
                        <a href="javascript:kami.query()" class="btn btn-outline-secondary mb-2">
                            <?= !empty($_QET['query']) ? $_QET['query'] . '的查询结果' : '查询卡密' ?>
                        </a>
                        <a href="javascript:<?= $gid_data['name'] == '' ? 'layer.alert(\'请先选择商品,在查商品的下拉框选择\')' : 'kami.add()' ?>"
                           class="btn btn-outline-success mb-2">
                            添加库存
                        </a>
                        <a href="javascript:kami.empty_use(<?= $gid_data['gid'] ?>)"
                           class="btn btn-outline-warning mb-2">
                            清空已使用
                        </a>
                        <a href="javascript:kami.empty(<?= $gid_data['gid'] ?>)" class="btn btn-outline-danger mb-2">
                            清空全部
                        </a>
                    </div>
                    <div class="col-sm-6">
                        <form class="layui-form" action="">
                            <div class="layui-form-item">
                                <label class="layui-form-label">查商品</label>
                                <div class="layui-input-block">
                                    <select name="kmgid" lay-search lay-filter="kmgid">
                                        <option value="">请选择对应的卡密商品</option>
                                        <?php
                                        foreach ($gid_arr as $v) {
                                            $state = $v['state'] == 1 ? '上架中' : '已下架';
                                            echo '<option value="' . $v['gid'] . '" ';
                                            echo $_QET['gid'] == $v['gid'] ? 'selected' : null;
                                            echo ' >' . $v['name'] . ' - [' . $v['count'] . '库存/' . $state . ']</option>';
                                        }
                                        ?>
                                    </select>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="table-responsive">
                    <table class="table table-centered table-striped dt-responsive nowrap w-100"
                           id="products-datatable">
                        <thead>
                        <tr style="white-space: nowrap">
                            <th>KID</th>
                            <th>UID</th>
                            <th>商品名称</th>
                            <th>卡密内容</th>
                            <th>提卡密码</th>
                            <th>使用者IP</th>
                            <th>对应订单</th>
                            <th>使用时间</th>
                            <th>添加时间</th>
                            <th>操作</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($khamwi_list['data'] as $v) {
                            ?>
                            <tr style="white-space: nowrap;font-size: 0.9em">
                                <td>
                                    <a href="#"
                                       class="badge badge-info-lighten">
                                        <?= $v['kid'] ?>
                                    </a>
                                </td>

                                <td>
                                    <?= $v['uid'] ?>
                                </td>

                                <td>
                                    <?= $v['name'] ?>
                                </td>

                                <td>
                                    <?= $v['token'] ?>
                                </td>
                                <td>
                                    <?= $v['code'] ?>
                                </td>
                                <td>
                                    <?= $v['ip'] ?>
                                </td>

                                <td>
                                    <?= $v['order'] ?>
                                </td>

                                <td>
                                    <?= $v['endtime'] ?>
                                </td>

                                <td>
                                    <?= $v['addtime'] ?>
                                </td>

                                <td>
                                    <a href="javascript:kami.delete(<?= $v['kid'] ?>)" class="action-icon"> <i
                                                class="layui-icon layui-icon-delete"></i></a>
                                </td>
                            </tr>
                        <?php } ?>

                        </tbody>
                    </table>
                </div>
                <nav>
                    <ul class="pagination pagination-rounded" style="overflow: auto">
                        <li class="page-item">
                            <a class="page-link"
                               href="?page=1<?= !empty($_QET['gid']) ? '&gid=' . $_QET['gid'] : '' ?><?= !empty($_QET['query']) ? '&query=' . $_QET['query'] : '' ?>"
                               aria-label="Previous">
                                <span aria-hidden="true">«</span>
                                <span class="sr-only">Previous</span>
                            </a>
                        </li>
                        <?php foreach ($paging as $v) { ?>
                            <li class="page-item <?= $v['active'] ?>"><a class="page-link"
                                                                         href="?page=<?= $v['number'] ?><?= !empty($_QET['gid']) ? '&gid=' . $_QET['gid'] : '' ?><?= !empty($_QET['query']) ? '&query=' . $_QET['query'] : '' ?>"><?= $v['number'] ?></a>
                            </li>
                        <?php } ?>
                        <li class="page-item">
                            <a class="page-link"
                               href="?page=<?= $shop_list['count'] ?><?= !empty($_QET['gid']) ? '&gid=' . $_QET['gid'] : '' ?><?= !empty($_QET['query']) ? '&query=' . $_QET['query'] : '' ?>"
                               aria-label="Next">
                                <span aria-hidden="true">»</span>
                                <span class="sr-only">Next</span>
                            </a>
                        </li>
                        <?php if (!empty($_QET['gid']) || !empty($_QET['query'])) { ?>
                            <li class="page-item">
                                <a class="page-link" href="?page=1" aria-label="Nexst">
                                    <span aria-hidden="true">查看全部</span>
                                    <span class="sr-only">Nexst</span>
                                </a>
                            </li>
                        <?php } ?>
                    </ul>
                </nav>
            </div> <!-- end card-body-->
        </div> <!-- end card-->
    </div> <!-- end col -->
</div>
<?php include "bottom.php"; ?>

<script>
    layui.use('form', function () {
        var form = layui.form;
        form.on('select(kmgid)', function (data) {
            if (data.value != '') {
                location.href = '?gid=' + data.value;
            } else {
                location.href = 'admin.goods.token.php';
            }
        });
    });
    var kami = { //卡密类
        query: function () {
            layer.prompt({
                formType: 3,
                value: '',
                title: '可输入卡密/订单号/KID/IP',
            }, function (value, index, elem) {
                location.href = '?query=' + value;
            });
        },
        empty_use: function (gid = null) {
            if (gid == null) {
                var gid = '';
                var tpis = '是否清空本站全部已使用过的库存卡密,清空后用户无法提取对应卡密?';
            } else {
                var gid = gid;
                var tpis = '是否清空商品：[ <?=$gid_data['name']?> ] 下全部已使用过的库存卡密,清空后用户无法提取对应卡密？';
            }
            layer.alert(tpis, {
                title: '温馨提示', btn: ['确定', '取消'], btn1: function (layero, index) {
                    $.post('ajax.php?act=kami_empty_use', {
                        gid: gid,
                    }, function (res) {
                        if (res.code == 1) {
                            layer.alert(res.msg, {
                                end: function (layero, index) {
                                    location.reload()
                                }
                            })
                        } else
                            layer.alert(res.msg)
                    })
                }
            })
        },
        empty: function (gid = null) {
            if (gid == null) {
                var gid = '';
                var tpis = '是否清空本站全部库存卡密?';
            } else {
                var gid = gid;
                var tpis = '是否清空商品：[ <?=$gid_data['name']?> ] 下的全部卡密？';
            }
            layer.alert(tpis, {
                title: '温馨提示', btn: ['确定', '取消'], btn1: function (layero, index) {
                    $.post('ajax.php?act=kami_empty', {
                        gid: gid,
                    }, function (res) {
                        if (res.code == 1) {
                            layer.alert(res.msg, {
                                end: function (layero, index) {
                                    location.reload()
                                }
                            })
                        } else
                            layer.alert(res.msg)
                    })
                }
            })
        },
        add: function () { //添加
            layer.prompt({
                formType: 2,
                value: '',
                maxlength: 99999999999,
                title: '为商品[ <?=$gid_data['name']?> ]添加卡密库存,<font color=red>一卡一行</font>！',
                area: ['800px', '350px']
            }, function (value, index, elem) {
                var content = value.split('\n');
                console.log(content);
                var gid = '<?=$gid_data['gid']?>';
                layer.alert('是否添加这' + content.length + '个卡密？', {
                    title: '添加确认', icon: 3, btn: ['确定添加', '取消添加！'], btn1: function (layero, index) {
                        $.post('ajax.php?act=kami_add', {
                            gid: gid,
                            kam_arr: content
                        }, function (res) {
                            if (res.code == 1) {
                                layer.alert(res.msg, {
                                    end: function (layero, index) {
                                        location.reload()
                                    }
                                })
                            } else
                                layer.alert(res.msg)
                        })
                    }
                });
            });
        },
        delete: function (a) {
            layer.alert('删除后不可撤销，是否确认删除？', {
                icon: 3, title: '温馨提示', btn: ['取消', '确定删除'], btn2: function (layero, index) {
                    window.location.href = '?unset=' + a;
                }
            })
        }
    }
</script>

