<?php
/**
 * 支付配置
 */
$title = '支付接口配置';
include "header.php";
?>
<style>.paystate {
        display: none
    }</style>
<div class="row">
    <div class="col-xl-12">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-12">
                        <h3 class="mb-3 header-title text-success"><?= $title ?></h3>
                        <form class="form-horizontal layui-form">
                            <div class="form-group mb-3">
                                <label for="example-input-normal">QQ支付</label>
                                <select class="custom-select mt-3" name="pay_qqapy" lay-filter="pay" lay-search>
                                    <option <?= $conf['pay_qqapy'] == -1 ? 'selected' : '' ?> value="-1">关闭接口</option>
                                    <option <?= $conf['pay_qqapy'] == 1 ? 'selected' : '' ?> value="1">易支付对接</option>
                                    <option <?= $conf['pay_qqapy'] == 2 ? 'selected' : '' ?> value="2">码支付对接</option>
                                </select>
                            </div>
                            <div class="form-group mb-3">
                                <label for="example-input-normal">微信支付</label>
                                <select class="custom-select mt-3" name="pay_wxpay" lay-filter="pay" lay-search>
                                    <option <?= $conf['pay_wxpay'] == -1 ? 'selected' : '' ?> value="-1">关闭接口</option>
                                    <option <?= $conf['pay_wxpay'] == 1 ? 'selected' : '' ?> value="1">易支付对接</option>
                                    <option <?= $conf['pay_wxpay'] == 2 ? 'selected' : '' ?> value="2">码支付对接</option>
                                </select>
                            </div>
                            <div class="form-group mb-3">
                                <label for="example-input-normal">支付宝支付</label>
                                <select class="custom-select mt-3" name="pay_alipay" lay-filter="pay" lay-search>
                                    <option <?= $conf['pay_alipay'] == -1 ? 'selected' : '' ?> value="-1">关闭接口</option>
                                    <option <?= $conf['pay_alipay'] == 1 ? 'selected' : '' ?> value="1">易支付对接</option>
                                    <option <?= $conf['pay_alipay'] == 2 ? 'selected' : '' ?> value="2">码支付对接</option>
                                    <option <?= $conf['pay_alipay'] == 3 ? 'selected' : '' ?> value="3">支付宝当面付</option>
                                </select>
                            </div>

                            <div class="form-group mb-3 paystate epay">
                                <label for="example-input-normal" style="font-weight: 500">易支付接口</label>
                                <input type="text" name="pay_url"
                                       class="form-control" value="<?= $conf['pay_url'] ?>"
                                       placeholder="易支付接口,需带http://">
                            </div>
                            <div class="form-group mb-3 paystate epay">
                                <label for="example-input-normal" style="font-weight: 500">商户ID</label>
                                <input type="text" name="pay_partner"
                                       class="form-control" value="<?= $conf['pay_partner'] ?>" placeholder="易支付商户ID">
                            </div>
                            <div class="form-group mb-3 paystate epay">
                                <label for="example-input-normal" style="font-weight: 500">商户KEY</label>
                                <input type="text" name="pay_key"
                                       class="form-control" value="<?= $conf['pay_key'] ?>" placeholder="易支付商户token">
                            </div>
                            <div class="form-group mb-3 paystate cpay">
                                <label for="example-input-normal" style="font-weight: 500">码支付ID</label>
                                <input type="text" name="cpay_id"
                                       class="form-control" value="<?= $conf['cpay_id'] ?>" placeholder="码支付ID">
                            </div>
                            <div class="form-group mb-3 paystate cpay">
                                <label for="example-input-normal" style="font-weight: 500">码支付密钥</label>
                                <input type="text" name="cpay_key"
                                       class="form-control" value="<?= $conf['cpay_key'] ?>" placeholder="码支付密钥">
                            </div>
                            <div class="form-group mb-3 paystate apay">
                                <label for="example-input-normal" style="font-weight: 500">当面付商品自定义名称</label>
                                <input type="text" name="alipay_name"
                                       class="form-control" value="<?= $conf['alipay_name'] ?>"
                                       placeholder="当面付商品名称自定义，留空默认">
                            </div>
                            <div class="form-group mb-3 paystate apay">
                                <label for="example-input-normal" style="font-weight: 500">支付宝公钥(当面付)</label>
                                <input type="text" name="alipay_public_key"
                                       class="form-control" value="<?= $conf['alipay_public_key'] ?>"
                                       placeholder="支付宝公钥">
                            </div>
                            <div class="form-group mb-3 paystate apay">
                                <label for="example-input-normal" style="font-weight: 500">商户私钥(当面付)</label>
                                <input type="text" name="merchant_private_key"
                                       class="form-control" value="<?= $conf['merchant_private_key'] ?>"
                                       placeholder="商户私钥">
                            </div>

                            <div class="form-group mb-3 paystate apay">
                                <label for="example-input-normal" style="font-weight: 500">应用ID(当面付)</label>
                                <input type="text" name="alipay_fpay_id"
                                       class="form-control" value="<?= $conf['alipay_fpay_id'] ?>" placeholder="应用ID">
                            </div>

                            <button type="submit" lay-submit lay-filter="Web_editor"
                                    class="btn btn-block btn-xs btn-success">保存内容
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<?php include "bottom.php"; ?>

<script>
    layui.use('form', function () {
        var form = layui.form;
        form.on('submit(Web_editor)', function (data) {
            layer.alert('是否要执行当前操作？', {
                icon: 3, btn: ['确定', '取消'], btn1: function (layero, index) {
                    var index = layer.msg('数据保存中,请稍后...', {icon: 16, time: 999999});
                    $.post('ajax.php?act=config_set', data.field, function (res) {
                        if (res.code == 1) {
                            layer.close(index);
                            layer.alert(res.msg, {
                                btn1: function (layero, index) {
                                    location.reload();
                                }
                            });
                        } else {
                            layer.close(index);
                            layer.alert(res.msg, {
                                btn1: function (layero, index) {
                                    location.reload();
                                }
                            });
                        }
                    });
                }
            });
            return false;
        })
        /**
         * 接口状态监控
         */
        form.on('select(pay)', function (data) {
            payset.Rendering();
        });

    })

    var payset = {
        paystate: function () { //当前接口状态
            var pay_qqapy = $("select[name='pay_qqapy']").val();
            var pay_wxpay = $("select[name='pay_wxpay']").val();
            var pay_alipay = $("select[name='pay_alipay']").val();
            return [pay_qqapy, pay_wxpay, pay_alipay];
        },
        Rendering: function () { //根据当前所选渲染内容
            var paystate = this.paystate();
            if (paystate[0] == 1 || paystate[1] == 1 || paystate[2] == 1) {
                $(".epay").show();
            } else $(".epay").hide();
            if (paystate[0] == 2 || paystate[1] == 2 || paystate[2] == 2) {
                $(".cpay").show();
            } else $(".cpay").hide();
            if (paystate[2] == 3) {
                $(".apay").show();
            } else $(".apay").hide();
        }
    }
    payset.Rendering();
</script>

