<?php
/**
 * 域名防洪
 */
$title = '域名防洪';
include "header.php";
?>

<div class="row">
    <div class="col-xl-12">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-12">
                        <h3 class="mb-3 header-title text-success"><?= $title ?></h3>
                        <form class="form-horizontal layui-form">
                            <div class="form-group mb-3">
                                <label for="example-input-normal">防洪开关</label>
                                <select class="custom-select mt-3" name="prevent_switch">
                                    <option></option>
                                    <option value="1" <?= $conf['prevent_switch'] == '1' ? 'selected' : null ?>>开启域名防洪
                                    </option>
                                    <option value="-1" <?= $conf['prevent_switch'] == '-1' ? 'selected' : null ?>>关闭域名防洪
                                    </option>
                                </select>
                            </div>
                            <div class="form-group mb-3">
                                <label for="example-input-normal">防洪接口(适用于优启梦防洪系统)</label>
                                <input type="text"
                                       value="<?= $conf['prevent_url'] ?>" name="prevent_url" id="prevent_url"
                                       class="form-control" placeholder="请填写防洪接口"/>
                                <span class="font-13 text-danger">一般接口格式为：http://域名地址//dwz.php?longurl=</span>
                            </div>
                            <div class="form-group mb-3">
                                <label for="example-input-normal">生成类型</label>
                                <select class="custom-select mt-3" name="prevent_type" id="prevent_type">
                                    <option></option>
                                    <option value="qq" <?= $conf['prevent_type'] == 'qq' ? 'selected' : null ?>>生成链接适用于QQ
                                    </option>
                                    <option value="vx" <?= $conf['prevent_type'] == 'vx' ? 'selected' : null ?>>生成链接适用于WX
                                    </option>
                                </select>
                            </div>
                            <div class="form-group mb-3">
                                <label for="example-input-normal">链接类型</label>
                                <select class="custom-select mt-3" name="prevent_dwzapi" id="prevent_dwzapi" lay-search>
                                    <option></option>
                                    <option value="0" <?= $conf['prevent_dwzapi'] == 0 ? 'selected' : null ?>>不缩短
                                    </option>
                                    <!--<option value="1" <? /*=$conf['prevent_dwzapi']==1?'selected':null*/ ?>>多接口</option>-->
                                    <option value="2" <?= $conf['prevent_dwzapi'] == 2 ? 'selected' : null ?>>t.cn
                                    </option>
                                    <option value="3" <?= $conf['prevent_dwzapi'] == 3 ? 'selected' : null ?>>url.cn
                                    </option>
                                    <option value="6" <?= $conf['prevent_dwzapi'] == 6 ? 'selected' : null ?>>mrw.so
                                    </option>
                                    <option value="7" <?= $conf['prevent_dwzapi'] == 7 ? 'selected' : null ?>>sinaurl.cn
                                    </option>
                                    <option value="8" <?= $conf['prevent_dwzapi'] == 8 ? 'selected' : null ?>>sohu.gg
                                    </option>
                                    <option value="9" <?= $conf['prevent_dwzapi'] == 9 ? 'selected' : null ?>>w.url.cn
                                    </option>
                                    <option value="10" <?= $conf['prevent_dwzapi'] == 10 ? 'selected' : null ?>>tsu.im
                                    </option>
                                    <option value="11" <?= $conf['prevent_dwzapi'] == 11 ? 'selected' : null ?>>dwz.la
                                    </option>
                                </select>
                            </div>
                            <div class="form-group mb-3">
                                <label for="example-input-normal">返回方式</label>
                                <select class="custom-select mt-3" name="prevent_format" id="prevent_format">
                                    <option></option>
                                    <option value="json" <?= $conf['prevent_format'] == 'json' ? 'selected' : null ?>>json格式
                                    </option>
                                    <!-- <option value="txt" <? /*=$conf['prevent_format']=='txt'?'selected':null*/ ?>>txt格式</option>
                                    <option value="qrcode" <? /*=$conf['prevent_format']=='qrcode'?'selected':null*/ ?>>qrcode格式</option>-->
                                </select>
                            </div>
                            <div class="form-group mb-3">
                                <label for="example-input-normal">测试数据</label>
                                <div class="input-group">
                                    <input type="text" id="test"
                                           value="<?=href()?>" disabled
                                           class="form-control" placeholder="填写防洪接口后,可点击旁边的按钮测试是否可用"/>
                                    <div class="input-group-append">
                                        <a href="javascript:text()" class="input-group-text"
                                           style="cursor: pointer;background-color: #7e11ff;color: white">测试接口</a>
                                    </div>
                                </div>
                            </div>
                            <button type="submit" lay-submit lay-filter="Web_editor"
                                    class="btn btn-block btn-xs btn-success">保存防洪接口
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include "bottom.php"; ?>

<script>
    layui.use('form', function () {
        var form = layui.form;
        form.on('submit(Web_editor)', function (data) {
            layer.alert('是否要执行当前操作？', {
                icon: 3, btn: ['确定', '取消'], btn1: function (layero, index) {
                    var index = layer.msg('数据保存中,请稍后...', {icon: 16, time: 999999});
                    $.ajax({
                        type: "post",
                        url: "ajax.php?act=config_set",
                        data: data.field,
                        dataType: "json",
                        success: function (res) {
                            layer.close(index);
                            if (res.code == 1) {
                                layer.alert(res.msg, {
                                    btn1: function (layero, index) {
                                        location.reload();
                                    }
                                });
                            } else {
                                layer.alert(res.msg, {
                                    btn1: function (layero, index) {
                                        location.reload();
                                    }
                                });
                            }
                        },
                        error: function () {
                            layer.close(index);
                            layer.alert('保存失败');
                        }
                    });
                }
            });
            return false;
        })
    });

    $.ajax({
        type: "POST",
        url: "ajax.php?act=prevent",
        dataType: "json",
        success: function (data) {
            $("#test").val(data.msg);
        },
        error: function () {
            layer.alert('加载失败！');
        }
    });

    function text() {
        var text = $('#prevent_type').val();
        var dwzapi = $('#prevent_dwzapi').val();
        var format = $('#prevent_format').val();
        if (text == null || dwzapi == null || format == null) {
            layer.alert('请将参数选择完整！');
            return false;
        }
        layer.load(3, {time: 99999999});
        $.ajax({
            type: "get",
            url: $('input[name="prevent_url"]').val() + '<?=href()?>' + '&type=' + text + '&dwzapi=' + dwzapi + '&format=' + format,
            dataType: "json",
            success: function (data) {
                layer.closeAll();
                if (data.code == 1) {
                    layer.alert('域名短链接：' + data.ae_url + '<br>域名长链接：' + data.longurl, {icon: 1, title: '返回数据：'});
                    $("#test").val(data.ae_url);
                } else {
                    layer.msg('接口数据获取失败!');
                }
            },
            error: function () {
                layer.alert('测试失败！');
            }
        });
    }
</script>