<?php
/**
 * Author：晴天 QQ：1186258278
 * Creation：2020/3/27 13:40
 * Filename：admin.security.center.php
 */
$title = '安全中心';
include "header.php";
?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                网站安全日志管理中心 - 点击日期查看日志内容，若感觉网站速度变慢，可在网站设置内关闭此功能！
            </div>
            <div class="card-body" style="z-index: 1;padding: 1em">
                <table class="layui-hide" id="security" lay-filter="security"></table>
            </div>
        </div>
    </div>
</div>


<?php include "bottom.php"; ?>

<script>
    layui.use(['form', 'table', 'upload'], function () {
        var table = layui.table;
        table.render({
            elem: '#security'
            , url: 'ajax.php?act=security_log'
            , title: '访问日志'
            , cellMinWidth: 120
            , id: 'idTest'
            , cols: [[
                {type: 'checkbox', fixed: 'left'}
                , {
                    field: 'date',
                    title: '记录日期',
                    fixed: 'left',
                    unresize: true,
                    sort: true,
                    templet: '#filename',
                    width: 300
                }
                , {
                    field: 'filename', title: '日志文件名'
                }
                , {
                    field: 'count', title: '当日日志数量'
                    , sort: true
                    , width: 130,
                }
            ]]
            , page: true
        });
    });
    security = {
        LogList: function (filename, date) {
            layer.open({
                title: date + '日整站访问日志详情',
                content: '<table class="layui-hide" id="security_log" lay-filter="security_log"></table>',
                area: ['98%', '98%'],
                btn: false,
                success: function (layero, index) {
                    layui.use(['form', 'table', 'upload'], function () {
                        var table = layui.table;
                        table.render({
                            elem: '#security_log'
                            , limits: [12, 24, 36, 100, 1000]
                            , limit: 12
                            , url: 'ajax.php?act=security_filename_log&filename=' + filename
                            , title: '访问日志'
                            , cellMinWidth: 120
                            , id: 'idTest'
                            , cols: [[
                                {
                                    field: 'date', title: '触发日期'
                                },
                                {
                                    field: 'data', templet: '#data', title: 'GET / POST'
                                },
                                {
                                    field: 'flie', title: '文件路径'
                                },
                                {
                                    field: 'environment', templet: '#environment', title: '来访者设备信息', width: 270,
                                },
                                {
                                    field: 'present', title: '完整访问链接'
                                },
                                {
                                    field: 'previous_url', templet: '#previous_url', title: '来路域名'
                                },
                                {
                                    field: 'ip', title: 'IP', width: 120,
                                },
                                {
                                    field: 'uid', templet: '#uid', title: '来访者身份', width: 110,
                                },
                            ]]
                            , page: true
                        });
                    });
                }
            })
        }
    }
</script>

<script id="filename" type="text/html">
    <a href="javascript:security.LogList('{{d.filename}}','{{ d.date }}')" class="text-danger"
       title="当日共有{{d.count}}条日志记录!">{{ d.date
        }}日</a>
</script>

<script id="environment" type="text/html">
    <span class="badge badge-primary-lighten">{{ d.environment.os }}</span> - <span class="badge badge-warning-lighten">{{ d.environment.browser }}</span>
</script>

<script id="uid" type="text/html">
    {{#  if(d.uid=='游客'){ }}
    <span class="badge badge-danger-lighten">{{ d.uid }}</span>
    {{#  }else if(d.uid=='站长'){ }}
    <span class="badge badge-success-lighten">{{ d.uid }}</span>
    {{#  }else{ }}
    <span class="badge badge-info-lighten">{{ d.uid }}</span>
    {{#  } }}
</script>

<script id="previous_url" type="text/html">
    {{#  if(d.previous_url==null){ }}
    <span class="text-danger">无来路信息</span>
    {{#  }else{ }}
    {{ d.previous_url }}
    {{#  } }}
</script>

<script id="data" type="text/html">
    {{#  if(d.data.length==0){ }}
    <span class="badge badge-info-lighten">未携带参数</span>
    {{#  }else{ }}
    {{# return adata(d.data) }}
    {{#  } }}
</script>
<script>
    function adata(data) {
        var datas = '<font color=red>';
        $.each(data, function (key, val) {
            datas += key + ' => ' + val + '<br>';
        });
        return datas + '</font>'
    }
</script>