<?php
/**
 * 短信配置
 */
$title = '平台消息通知配置';
include "header.php";
?>
<div class="row">
    <div class="col-xl-12">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-12">
                        <h3 class="mb-3 header-title text-success"><?= $title ?></h3>
                        <form class="form-horizontal layui-form">
                            <div class="form-group mb-3">
                                <label for="example-input-normal">短信开关(后台登陆)</label>
                                <select class="custom-select mt-3" lay-search name="sms_switch_user">
                                    <option <?= $conf['sms_switch_user'] == -1 ? 'selected' : '' ?> value="-1">关闭短信验证
                                    </option>
                                    <option <?= $conf['sms_switch_user'] == 1 ? 'selected' : '' ?> value="1">开启短信验证
                                    </option>
                                </select>
                            </div>

                            <div class="form-group mb-3">
                                <label for="example-input-normal">短信开关(购买提醒/用户)</label>
                                <select class="custom-select mt-3" lay-search name="sms_switch_order">
                                    <option <?= $conf['sms_switch_order'] == -1 ? 'selected' : '' ?> value="-1">关闭短信验证
                                    </option>
                                    <option <?= $conf['sms_switch_order'] == 1 ? 'selected' : '' ?> value="1">开启短信验证
                                    </option>
                                </select>
                            </div>

                            <div class="form-group mb-3">
                                <label for="example-input-normal">公众号订单提醒(试用功能) <a href="javascript:;"
                                                                                   onclick="layer.alert('必须要绑定微信公众号才可使用！<br>试用期间，免费开放！若反映良好会添加后续通知功能！<br>若服务器速度较慢,可能会影响下单提交速度！')">说明</a></label>
                                <select class="custom-select mt-3" lay-search name="weix_notice">
                                    <option <?= $conf['weix_notice'] == -1 ? 'selected' : '' ?> value="-1">关闭新订单通知
                                    </option>
                                    <option <?= $conf['weix_notice'] == 1 ? 'selected' : '' ?> value="1">开启新订单通知
                                    </option>
                                </select>
                            </div>

                            <div class="form-group mb-3">
                                <label for="example-input-normal"
                                       style="font-weight: 500">手机号绑定(可用来登陆站长后台，需消耗你的短信额度)</label>
                                <input type="text" name="Mobile" lay-verify="required|phone" class="form-control"
                                       value="" placeholder="请输入你的手机号！">
                            </div>

                            <div class="form-group mb-3">
                                <label for="example-input-normal" style="font-weight: 500">我的短信额度</label>
                                <input type="text" name="sms" class="form-control" value="0条" disabled
                                       placeholder="剩余短信额度！">
                            </div>

                            <div class="form-group mb-3">
                                <label for="example-input-normal" style="font-weight: 500">今日发送短信</label>
                                <input type="text" name="sms_today" class="form-control" value="0条" disabled
                                       placeholder="今日发送短信！">
                            </div>

                            <div class="form-group mb-3">
                                <label for="example-input-normal" style="font-weight: 500">累计发送短信</label>
                                <input type="text" name="sms_total" class="form-control" value="0条" disabled
                                       placeholder="累计发送短信！">
                            </div>

                            <div class="form-group mb-3">
                                <label for="example-input-normal" style="font-weight: 500">服务端余额</label>
                                <input type="text" name="money" class="form-control" value="0元" disabled
                                       placeholder="服务端余额！">
                            </div>

                            <button type="submit" lay-submit lay-filter="Notification_set"
                                    class="btn btn-block btn-xs btn-success">保存内容
                            </button>
                        </form>
                        <span class="mt-3" style="display: block">短信额度充值请前往授权服务端<a
                                    href="https://cdn.api.ln.cn/api/wxapi/view/" target="_blank"
                                    style="color: #000"><span
                                        class="badge badge-primary-lighten">小储科技</span> 微信公众号 ( 进入）</a></span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<?php include "bottom.php"; ?>

<script>
    layui.use('form', function () {
        var form = layui.form;
        form.on('submit(Notification_set)', function (data) {
            layer.alert('是否要执行当前操作？', {
                icon: 3, btn: ['确定', '取消'], btn1: function (layero, index) {
                    var index = layer.msg('数据保存中,请稍后...', {icon: 16, time: 999999});
                    $.post('ajax.php?act=config_set_sms', data.field, function (res) {
                        if (res.code == 1) {
                            layer.close(index);
                            layer.alert(res.msg, {
                                btn1: function (layero, index) {
                                    location.reload();
                                }
                            });
                        } else {
                            layer.close(index);
                            layer.alert(res.msg, {
                                btn1: function (layero, index) {
                                    location.reload();
                                }
                            });
                        }
                    });
                }
            });
            return false;
        })
    })
    $.post('ajax.php?act=sms_data', function (res) {
        if (res.code < 0) {
            layer.msg(res.msg);
        } else {
            $("input[name='money']").val(res.data.money + '元');
            $("input[name='sms']").val(res.data.sms + '条');
            $("input[name='Mobile']").val((res.data.Mobile == 0 ? '' : res.data.Mobile));
            $("input[name='sms_today']").val(res.data.sms_today + '条');
            $("input[name='sms_total']").val(res.data.sms_total + '条');
        }
    })
</script>


