<?php
/**
 * 网站模板设置
 */
$title = '网站模板设置';
include "header.php";
$template_arr = for_dir("../template/");
?>
<div class="row">
    <div class="col-xl-12">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-12">
                        <h3 class="mb-3 header-title text-success"><?= $title ?></h3>
                        <form class="form-horizontal layui-form">
                            <div class="form-group mb-3">
                                <label for="example-input-normal">首页模板（PC端）</label>
                                <select class="custom-select mt-3" lay-search name="template">
                                    <?php
                                    foreach ($template_arr as $v) {
                                        echo '<option ';
                                        echo $conf['template'] == $v ? 'selected' : null;
                                        echo ' value="' . $v . '">' . $v . '</option>';
                                    }
                                    ?>
                                </select>
                            </div>
                            <div class="form-group mb-3">
                                <label for="example-input-normal">首页模板（手机端）</label>
                                <select class="custom-select mt-3" lay-search name="template_m">
                                    <?php
                                    foreach ($template_arr as $v) {
                                        echo '<option ';
                                        echo $conf['template_m'] == $v ? 'selected' : null;
                                        echo ' value="' . $v . '">' . $v . '</option>';
                                    }
                                    ?>
                                </select>
                            </div>
                            <div class="form-group mb-3">
                                <label for="example-input-normal">背景图片</label>
                                <select class="custom-select mt-3" lay-search name="background">
                                    <option <?= $conf['background'] == 1 ? 'selected' : '' ?> value="1">每日必应背景(快)
                                    </option>
                                    <option <?= $conf['background'] == 2 ? 'selected' : '' ?> value="2">随机必应背景(慢)
                                    </option>
                                    <option <?= $conf['background'] == 3 ? 'selected' : '' ?> value="3">二次元背景图(慢)
                                    </option>
                                    <option <?= $conf['background'] == 4 ? 'selected' : '' ?> value="4">模板默认背景(快)
                                    </option>
                                    <option <?= $conf['background'] == 5 ? 'selected' : '' ?> value="5">自定义背景图(快)
                                    </option>
                                </select>
                                <div class="text-danger mt-1">自定义背景图存放到：assets/img/bj.png,若无则会显示空白！</div>
                            </div>
                            <div class="form-group mb-3">
                                <label for="example-input-normal">CDN节点</label>
                                <select class="custom-select mt-3" lay-search name="cdnpublic">
                                    <option <?= $conf['cdnpublic'] == 1 ? 'selected' : '' ?> value="1">360CDN</option>
                                    <option <?= $conf['cdnpublic'] == 2 ? 'selected' : '' ?> value="2">BootCDN</option>
                                    <option <?= $conf['cdnpublic'] == 3 ? 'selected' : '' ?> value="3">今日头条</option>
                                    <option <?= $conf['cdnpublic'] < 1 || $conf['cdnpublic'] > 3 ? 'selected' : '' ?>
                                            value="4">七牛云CDN
                                    </option>
                                </select>
                            </div>

                            <div class="form-group mb-3">
                                <label for="example-input-normal">小储云静态资源加速</label>
                                <select class="custom-select mt-3" lay-search name="cdnserver">
                                    <option <?= $conf['cdnserver'] == 1 ? 'selected' : '' ?> value="1">开启静态资源加速
                                    </option>
                                    <option <?= $conf['cdnserver'] == 2 ? 'selected' : '' ?> value="2">关闭静态资源加速
                                    </option>
                                </select>
                            </div>

                            <div class="form-group mb-2">
                                <label for="example-input-normal">首页banner(轮播图)</label>
                                <div class="input-group">
                                     <span class="btn btn-xs btn-outline-primary mr-1"
                                           style="cursor: pointer" onclick="template.add()">添加</span>
                                    <span class="btn btn-xs btn-outline-success"
                                          onclick="template.QuickEdit()"
                                          style="cursor: pointer;margin-left: 1em">快速编辑</span>
                                    <div class="banner"
                                         data-img="<?= $conf['banner'] ?>">
                                    </div>
                                </div>
                            </div>
                            <style>
                                .banner {
                                    width: 100%;
                                    min-height: 12em
                                }

                                .banner img {
                                    width: 10em;
                                    height: 10em;
                                    margin: 1em;
                                    box-shadow: 3px 3px 16px #eee;
                                    border-radius: 0.5em;
                                }
                            </style>

                            <button type="submit" lay-submit lay-filter="Notification_set"
                                    class="btn btn-block btn-xs btn-success">保存内容
                            </button>
                        </form>

                        <span class="mt-3" style="display: block">获取更多模板欢迎加入<a href="http://api.ln.cn/" target="_blank"><span
                                        class="badge badge-primary-lighten">晴天Market</span></a> ( 需授权）</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<?php include "bottom.php"; ?>

<script>
    layui.use('form', function () {
        var form = layui.form;
        form.on('submit(Notification_set)', function (data) {
            layer.alert('是否要执行当前操作？', {
                icon: 3, btn: ['确定', '取消'], btn1: function (layero, index) {
                    var index = layer.msg('数据保存中,请稍后...', {icon: 16, time: 999999});
                    var banner = $(".banner").attr('data-img');
                    data.field['banner'] = banner;
                    $.post('ajax.php?act=config_set', data.field, function (res) {
                        if (res.code == 1) {
                            layer.close(index);
                            layer.alert(res.msg, {
                                btn1: function (layero, index) {
                                    location.reload();
                                }
                            });
                        } else {
                            layer.close(index);
                            layer.alert(res.msg, {
                                btn1: function (layero, index) {
                                    location.reload();
                                }
                            });
                        }
                    });
                }
            });
            return false;
        })
    });
    var template = {
        ls: function () {
            var images = $(".banner").attr('data-img');
            var content = images.split('|');
            contents = '';
            $.each(content, function (key, val) {
                img_arr = val.split('*');
                contents += '<a href="' + img_arr[1] + '" target="_blank" ><img src="' + img_arr[0] + '"  /></a>';
            });
            $(".banner").html(contents);
        },
        add: function () {
            var content = '<a  class="btn btn-xs btn-outline-success mr-2" id="upload" >上传图片到本地服务器</a><a target="_blank"  class="btn btn-xs btn-outline-primary" href="http://cdn.vue8.cn/"  >打开晴天云盘</a><hr>' +
                '<div class="layui-form layui-form-pane">\n' +
                '                    <div class="layui-form-item">\n' +
                '                        <label class="layui-form-label">图片地址</label>\n' +
                '                        <div class="layui-input-block" pane>\n' +
                '                            <input type="text" name="image" value="" placeholder="请填写图片地址！" autocomplete="off"\n' +
                '                                   class="layui-input">\n' +
                '                        </div>\n' +
                '                    </div>' +
                '                    <div class="layui-form-item">\n' +
                '                        <label class="layui-form-label">跳转链接</label>\n' +
                '                        <div class="layui-input-block" pane>\n' +
                '                            <input type="text" name="url" value="" placeholder="请填写的跳转链接" autocomplete="off"\n' +
                '                                   class="layui-input">\n' +
                '                        </div>\n' +
                '                    </div>' +
                '</div>';
            var ix = layer.open({
                title: '快速添加首页轮播图',
                content: content,
                btn: ['插入', '取消'],
                btn1: function (layero, index) {
                    var image = $("input[name='image']").val();
                    var url = $("input[name='url']").val();
                    if (image == '' || url == '') {
                        alert('请填写完整！');
                        return false;
                    } else {
                        var images = $(".banner").attr('data-img');
                        var imas = image + '*' + url;
                        if (images == '') {
                            $(".banner").attr('data-img', imas);
                        } else {
                            $(".banner").attr('data-img', images + '|' + imas);
                        }
                        template.ls();
                        layer.close(ix);
                    }

                }, success: function (layero, index) {

                    layui.use(['upload', 'form'], function () {
                        var upload = layui.upload;
                        var uploadInst = upload.render({
                            elem: '#upload' //绑定元素
                            , url: 'ajax.php?act=image_up' //上传接口
                            , acceptMime: 'image/*'
                            , accept: 'images'
                            , done: function (res, index, upload) {
                                $("input[name='image']").val(res.src);
                            }
                            , error: function () {
                                layer.msg('图片上传失败!')
                            }
                        });
                    });
                }
            });
        },
        QuickEdit: function () {
            var images = $(".banner").attr('data-img');
            var content = images.split('|');
            var content = content.join("\n");
            layer.prompt({
                formType: 2,
                value: content,
                title: '一行一条规则,[*]分割跳转链接！',
                maxlength: 99999999999,
                area: ['350px', '350px'] //自定义文本域宽高
            }, function (value, index, elem) {
                var content = value.split("\n");
                var content = content.join('|');
                $(".banner").attr('data-img', content);
                template.ls();
                layer.close(index);
            });
        }
    };
    template.ls();
</script>


