<?php
/**
 * 日志管理
 */

$title = '用户日志管理';
include "header.php";
$sum = 8; #每页数量
$page = shop::page($sum, $_QET['page']); #取出翻页数据
$user_log = user::users_log($sum, $page['count'], $page['limit'], $_QET['uid'], $_QET['name']); #查询指定UID
$paging = shop::paging($user_log['count'], $_QET['page']); #取出翻页按钮数据
if (!empty($_QET['unset'])) {
    $a = $DB->query("DELETE FROM `sky_journal`  WHERE (`id`='{$_QET['unset']}')"); #删除
    if ($a) {
        show_msg('成功提示', '编号:' . $_QET['unset'] . '删除成功,请点击下方按钮返回', '1');
    } else show_msg('温馨提示', '编号:' . $_QET['unset'] . '删除失败,原因->' . $DB->error(), '2');
}
?>
<!-- third party css -->
<link href="<?= $cdnserver == null ? '../' : $cdnserver ?>assets/css/vendor/dataTables.bootstrap4.css" rel="stylesheet"
      type="text/css"/>
<link href="<?= $cdnserver == null ? '../' : $cdnserver ?>assets/css/vendor/responsive.bootstrap4.css" rel="stylesheet"
      type="text/css"/>
<!-- third party css end -->
<!-- App css -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-sm-4">
                        <a href="javascript:query()" class="btn btn-danger mb-2"><i
                                    class="layui-icon layui-icon-add-circle-fine mr-2"></i>
                            查找用户
                        </a>
                    </div>
                </div>
                <div class="table-responsive">
                    <code>可点击日志名称或点击用户UID可查看相关日志内容</code>
                    <table class="table table-centered table-striped dt-responsive nowrap w-100"
                           id="products-datatable">
                        <thead>
                        <tr style="white-space: nowrap">
                            <th>ID</th>
                            <th>日志类型</th>
                            <th>UID</th>
                            <th>数量</th>
                            <th>操作IP</th>
                            <th>日志内容</th>
                            <th>发送时间</th>
                            <th>操作</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($user_log['data'] as $v) {
                            ?>
                            <tr style="white-space: nowrap;font-size: 0.9em">
                                <td>
                                    <a href="#" class="badge badge-info-lighten">
                                        <?= $v['id'] ?>
                                    </a>
                                </td>
                                <td>
                                    <?php
                                    switch ($v['name']) {
                                        case '每日签到':
                                            $color = '#43A047';
                                            break;
                                        case '用户登陆':
                                            $color = '#795548';
                                            break;
                                        case '后台扣款':
                                            $color = 'red';
                                            break;
                                        case '余额购买':
                                            $color = '#00E676';
                                            break;
                                        case '在线购买':
                                            $color = '#00C853';
                                            break;
                                        case '积分兑换':
                                            $color = '#00B0FF';
                                            break;
                                        case '积分扣除':
                                            $color = '#E65100';
                                            break;
                                        case '	积分充值':
                                            $color = '#EEFF41';
                                            break;
                                        case '后台加款':
                                            $color = '#2E7D32';
                                            break;
                                        default:
                                            $color = '#546E7A';
                                            break;
                                    }
                                    $uids = !empty($_QET['uid']) ? '&uid=' . $_QET['uid'] : '';
                                    echo '<a href="?name=' . $v['name'] . $uids . '"><font color="' . $color . '">' . $v['name'] . '</font></a>';
                                    ?>
                                </td>
                                <td>
                                    <a href="admin.user.log.php?uid=<?= $v['uid'] ?><?= !empty($_QET['name']) ? '&name=' . $_QET['name'] : '' ?>"
                                       class="badge badge-primary-lighten"><?= $v['uid'] ?></a>
                                </td>
                                <td>
                                    <?= round($v['count'], 6) ?>
                                </td>

                                <td class="table-user">
                                    <?= $v['ip'] ?>
                                </td>
                                <td>
                                    <?= $v['content'] ?>
                                </td>
                                <td>
                                    <?= $v['date'] ?>
                                </td>
                                <td>
                                    <a href="javascript:unset(<?= $v['id'] ?>)" class="action-icon"> <i
                                                class="layui-icon layui-icon-delete"></i></a>
                                </td>
                            </tr>
                        <?php } ?>

                        </tbody>
                    </table>
                </div>
                <nav>
                    <ul class="pagination pagination-rounded" style="overflow: auto">
                        <li class="page-item">
                            <a class="page-link"
                               href="?page=1<?= !empty($_QET['uid']) ? '&uid=' . $_QET['uid'] : '' ?><?= !empty($_QET['name']) ? '&name=' . $_QET['name'] : '' ?>"
                               aria-label="Previous">
                                <span aria-hidden="true">«</span>
                                <span class="sr-only">Previous</span>
                            </a>
                        </li>
                        <?php foreach ($paging as $v) { ?>
                            <li class="page-item <?= $v['active'] ?>"><a class="page-link"
                                                                         href="?page=<?= $v['number'] ?><?= !empty($_QET['uid']) ? '&uid=' . $_QET['uid'] : '' ?><?= !empty($_QET['name']) ? '&name=' . $_QET['name'] : '' ?>"><?= $v['number'] ?></a>
                            </li>
                        <?php } ?>
                        <li class="page-item">
                            <a class="page-link"
                               href="?page=<?= $user_log['count'] ?><?= !empty($_QET['uid']) ? '&uid=' . $_QET['uid'] : '' ?><?= !empty($_QET['name']) ? '&name=' . $_QET['name'] : '' ?>"
                               aria-label="Next">
                                <span aria-hidden="true">»</span>
                                <span class="sr-only">Next</span>
                            </a>
                        </li>
                        <?php if (!empty($_QET['uid']) || !empty($_QET['name'])) { ?>
                            <li class="page-item">
                                <a class="page-link" href="?page=1" aria-label="Nexst">
                                    <span aria-hidden="true">查看全部</span>
                                    <span class="sr-only">Nexst</span>
                                </a>
                            </li>
                        <?php } ?>
                    </ul>
                </nav>
            </div> <!-- end card-body-->
        </div> <!-- end card-->
    </div> <!-- end col -->
</div>
<?php include "bottom.php"; ?>
<script>
    function unset(a) {
        layer.alert('删除后不可撤销，是否确认删除？', {
            icon: 3, title: '温馨提示', btn: ['取消', '确定删除'], btn2: function (layero, index) {
                window.location.href = '?unset=' + a;
            }
        })
    }

    function query() {
        layer.prompt({
            formType: 0,
            value: '',
            title: '请填写用户名或ID查找用户!',
        }, function (value, index, elem) {
            location.href = '?uid=' + value;
        });
    }
</script>
