<?php
/**
 * 用户排行榜
 */
$title = '站内排行榜';
include 'header.php';
$data_rand = user::rank();
?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title mb-3 text-danger">排行榜只显示前八十八名哦~ </h4>
                    <ul class="nav nav-tabs nav-justified nav-bordered mb-3">
                        <li class="nav-item">
                            <a href="#home-b2" data-toggle="tab" aria-expanded="false" class="nav-link active">
                                <span class="d-lg-block" style="font-weight: 300">今邀榜</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="#profile-b2" data-toggle="tab" aria-expanded="true" class="nav-link">
                                <span class="d-lg-block" style="font-weight: 300">总邀榜</span>
                            </a>
                        </li>

                        <li class="nav-item">
                            <a href="#settings-b2" data-toggle="tab" aria-expanded="false" class="nav-link">
                                <span class="d-lg-block" style="font-weight: 300"><?= $conf['currency'] ?></span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="#settings-b3" data-toggle="tab" aria-expanded="false" class="nav-link">
                                <span class="d-lg-block" style="font-weight: 300">余额榜</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="#settings-b4" data-toggle="tab" aria-expanded="false" class="nav-link">
                                <span class="d-lg-block" style="font-weight: 300">消费榜</span>
                            </a>
                        </li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active" id="home-b2">
                            <div class="table-responsive">
                                <table class="table table-hover table-centered mb-0">
                                    <thead>
                                    <tr style="white-space: nowrap">
                                        <th>名次</th>
                                        <th>编号</th>
                                        <th>名称</th>
                                        <th>头像</th>
                                        <th>邀请人数</th>
                                        <th>已得奖励</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $a = 1;
                                    foreach ($data_rand['data_1'] as $v) {
                                        switch ($a) {
                                            case 1:
                                                $mc = '<span class="badge badge-danger-lighten">第1名</span>';
                                                break;
                                            case 2:
                                                $mc = '<span class="badge badge-warning-lighten">第2名</span>';
                                                break;
                                            case 3:
                                                $mc = '<span class="badge badge-primary-lighten">第3名</span>';
                                                break;
                                            default:
                                                $mc = '<span class="badge badge-secondary-lighten">第' . $a . '名</span>';
                                                break;
                                        }
                                        ?>
                                        <tr>
                                            <td><?= $mc ?></td>
                                            <td><a href="admin.user.list.php?id=<?= $v['uid'] ?>"><span
                                                            class="badge badge-success"><?= $v['uid'] ?>号</span></a>
                                            </td>
                                            <td><?= $v['name'] ?></td>
                                            <td><img lay-src="<?= $v['image'] ?>" width="30"/></td>
                                            <td><?= $v['count'] ?>人</td>
                                            <td><?= $v['money'] . $conf['currency'] ?></td>
                                        </tr>
                                        <?php $a = $a + 1;
                                    } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="tab-pane show" id="profile-b2">
                            <div class="table-responsive">
                                <table class="table table-hover table-centered mb-0">
                                    <thead>
                                    <tr style="white-space: nowrap">
                                        <th>名次</th>
                                        <th>编号</th>
                                        <th>名称</th>
                                        <th>头像</th>
                                        <th>邀请人数</th>
                                        <th>已得奖励</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $a = 1;
                                    foreach ($data_rand['data_2'] as $v) {
                                        switch ($a) {
                                            case 1:
                                                $mc = '<span class="badge badge-danger-lighten">第1名</span>';
                                                break;
                                            case 2:
                                                $mc = '<span class="badge badge-warning-lighten">第2名</span>';
                                                break;
                                            case 3:
                                                $mc = '<span class="badge badge-primary-lighten">第3名</span>';
                                                break;
                                            default:
                                                $mc = '<span class="badge badge-secondary-lighten">第' . $a . '名</span>';
                                                break;
                                        }
                                        ?>
                                        <tr>
                                            <td><?= $mc ?></td>
                                            <td><a href="admin.user.list.php?id=<?= $v['uid'] ?>"><span
                                                            class="badge badge-success"><?= $v['uid'] ?>号</span></a>
                                            </td>
                                            <td><?= $v['name'] ?></td>
                                            <td><img lay-src="<?= $v['image'] ?>" width="30"/></td>
                                            <td><?= $v['count'] ?>人</td>
                                            <td><?= $v['money'] . $conf['currency'] ?></td>
                                        </tr>
                                        <?php $a = $a + 1;
                                    } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="tab-pane" id="settings-b2">
                            <div class="table-responsive">
                                <table class="table table-hover table-centered mb-0">
                                    <thead>
                                    <tr style="white-space: nowrap">
                                        <th>名次</th>
                                        <th>编号</th>
                                        <th>名称</th>
                                        <th>头像</th>
                                        <th>剩余<?= $conf['currency'] ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $a = 1;
                                    foreach ($data_rand['data_3'] as $v) {
                                        switch ($a) {
                                            case 1:
                                                $mc = '<span class="badge badge-danger-lighten">第1名</span>';
                                                break;
                                            case 2:
                                                $mc = '<span class="badge badge-warning-lighten">第2名</span>';
                                                break;
                                            case 3:
                                                $mc = '<span class="badge badge-primary-lighten">第3名</span>';
                                                break;
                                            default:
                                                $mc = '<span class="badge badge-secondary-lighten">第' . $a . '名</span>';
                                                break;
                                        }
                                        ?>
                                        <tr>
                                            <td><?= $mc ?></td>
                                            <td><a href="admin.user.list.php?id=<?= $v['id'] ?>"><span
                                                            class="badge badge-success"><?= $v['id'] ?>号</span></a></td>
                                            <td><?= $v['name'] ?></td>
                                            <td><img lay-src="<?= $v['image'] ?>" width="30"/></td>
                                            <td><?= $v['currency'] . $conf['currency'] ?></td>
                                        </tr>
                                        <?php $a = $a + 1;
                                    } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div class="tab-pane" id="settings-b3">
                            <div class="table-responsive">
                                <table class="table table-hover table-centered mb-0">
                                    <thead>
                                    <tr style="white-space: nowrap">
                                        <th>名次</th>
                                        <th>编号</th>
                                        <th>名称</th>
                                        <th>头像</th>
                                        <th>余额总数</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $a = 1;
                                    foreach ($data_rand['data_4'] as $v) {
                                        switch ($a) {
                                            case 1:
                                                $mc = '<span class="badge badge-danger-lighten">第1名</span>';
                                                break;
                                            case 2:
                                                $mc = '<span class="badge badge-warning-lighten">第2名</span>';
                                                break;
                                            case 3:
                                                $mc = '<span class="badge badge-primary-lighten">第3名</span>';
                                                break;
                                            default:
                                                $mc = '<span class="badge badge-secondary-lighten">第' . $a . '名</span>';
                                                break;
                                        }
                                        ?>
                                        <tr>
                                            <td><?= $mc ?></td>
                                            <td><a href="admin.user.list.php?id=<?= $v['id'] ?>"><span
                                                            class="badge badge-success"><?= $v['id'] ?>号</span></a>
                                            </td>
                                            <td><?= $v['name'] ?></td>
                                            <td><img lay-src="<?= $v['image'] ?>" width="30"/></td>
                                            <td class="text-success"><?= round($v['money'], 2) ?>元</td>
                                        </tr>
                                        <?php $a = $a + 1;
                                    } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div class="tab-pane" id="settings-b4">
                            <div class="table-responsive">
                                <table class="table table-hover table-centered mb-0">
                                    <thead>
                                    <tr style="white-space: nowrap">
                                        <th>名次</th>
                                        <th>编号</th>
                                        <th>名称</th>
                                        <th>头像</th>
                                        <th>总消费</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $a = 1;
                                    foreach ($data_rand['data_5'] as $v) {
                                        switch ($a) {
                                            case 1:
                                                $mc = '<span class="badge badge-danger-lighten">第1名</span>';
                                                break;
                                            case 2:
                                                $mc = '<span class="badge badge-warning-lighten">第2名</span>';
                                                break;
                                            case 3:
                                                $mc = '<span class="badge badge-primary-lighten">第3名</span>';
                                                break;
                                            default:
                                                $mc = '<span class="badge badge-secondary-lighten">第' . $a . '名</span>';
                                                break;
                                        }
                                        ?>
                                        <tr>
                                            <td><?= $mc ?></td>
                                            <td><a href="admin.user.list.php?id=<?= $v['uid'] ?>"><span
                                                            class="badge badge-success"><?= $v['uid'] ?>号</span></a>
                                            </td>
                                            <td><?= $v['name'] ?></td>
                                            <td><img lay-src="<?= $v['image'] ?>" width="30"/></td>
                                            <td class="text-success"><?= round($v['money'], 2) ?>元</td>
                                        </tr>
                                        <?php $a = $a + 1;
                                    } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                </div> <!-- end card-body-->
            </div> <!-- end card-->
        </div>
    </div>
<?php
include 'bottom.php';
?>