<?php
/**
 * 登陆
 */
include "../includes/fun.global.php";
include_once(SYSTEM_ROOT . "fun.admin.php");
if (!empty($_COOKIE['THEKEY_ADMIN'])) {
    header("Location:index.php");
    return false;
}
$api_text = get_curl('https://v1.hitokoto.cn/');
$api_text = json_decode($api_text, TRUE);
if (!is_mobile()) {
    $image = background::image();
}

if (!empty($_COOKIE['ADMIN_TOKEN'])) header("Location:index.php");

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8"/>
    <title>站长登陆</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="A fully featured admin theme which can be used to build CRM, CMS, etc." name="description"/>
    <meta content="Coderthemes" name="author"/>
    <!-- App favicon -->
    <link rel="shortcut icon" href="<?=$cdnserver==null?'../':$cdnserver?>assets/favicon.ico">
    <!-- App css -->
    <link href="<?=$cdnserver==null?'../':$cdnserver?>assets/css/icons.min.css" rel="stylesheet" type="text/css"/>
    <link href="<?=$cdnserver==null?'../':$cdnserver?>assets/css/app.min.css" rel="stylesheet" type="text/css"/>
    <script src="<?=$cdnserver==null?'../':$cdnserver?>assets/layui/css/layui.css"></script>
</head>

<body class="auth-fluid-pages pb-0">

<div class="auth-fluid"
     style="<?= $image == false ? 'background:linear-gradient(to left, #70e1f5, #ffd194);' : $image ?>">
    <!--Auth fluid left content -->
    <div class="auth-fluid-form-box">
        <div class="align-items-center d-flex h-100">
            <div class="card-body">

                <!-- Logo -->
                <div class="auth-brand text-center text-lg-left">
                    <a href="../">
                        <span><img src="<?= $conf['logo'] ?>" alt="" height="18"></span>
                    </a>
                </div>

                <!-- User pic with title-->
                <div class="text-center w-75 m-auto">
                    <img src="<?=$cdnserver==null?'../':$cdnserver?>assets/img/wx.png" height="88" alt="user-image" class="rounded-circle">
                    <h4 class="text-dark-50 text-center mt-3" style="font-weight: 300">你好！站长</h4>
                    <div id="login" class="btn btn-primary btn-block text-white mt-3 shadow-lg"><i
                                class="dripicons-user-group"></i> 登陆站长后台
                    </div>
                    <div id="login2" class="btn btn-success btn-block text-white mt-3 shadow-lg" style="display: none">
                        <i
                                class="mdi mdi-window-open"></i> 手动输入验证码
                    </div>
                    <div id="login_ok" class="btn btn-success btn-block text-white mt-3 shadow-lg" style="display: none"
                         onclick="location.href='index.php'"><i class="dripicons-user-group"></i> 验证通过,进入后台
                    </div>
                </div>
                <div class="text-center mt-4">
                    <p class="text-muted font-18" style="font-weight: 300" id="tisp"><?= $api_text['hitokoto'] ?></p>
                </div>
            </div> <!-- end .card-body -->
        </div> <!-- end .align-items-center.d-flex.h-100-->
    </div>
    <!-- end auth-fluid-form-box-->

    <!-- Auth fluid right content -->
    <div class="auth-fluid-right text-center">
        <div class="auth-user-testimonial">
            <p class="lead"><?= $api_text['hitokoto'] ?></p>
            <p>
                <?= $conf['sitename'] ?>
            </p>
        </div> <!-- end auth-user-testimonial-->
    </div>
    <!-- end Auth fluid right content -->
</div>
<!-- end auth-fluid-->

<!-- App js -->
<script src="<?=$cdnserver==null?'../':$cdnserver?>assets/js/app.min.js"></script>
<script src="<?=$cdnserver==null?'../':$cdnserver?>assets/layui/layui.all.js"></script>
<script src="<?= $cdnpublic ?>/jquery/3.4.1/jquery.min.js"></script>
</body>
<script>
    $("#login").click(function () {
        var index = layer.msg('正在登陆中', {time: 9999999});
        $.ajax({
            type: "post",
            url: "ajax.php?act=login",
            dataType: "json",
            success: function (data) {
                layer.close(index);
                if (data.code > 0) {
                    layer.alert(data.msg, {icon: 1});
                    to_load();
                } else {
                    layer.alert(data.msg, {icon: 2})
                }
            },
            error: function () {
                layer.alert('服务器异常！');
                layer.close(index);
            }
        });
    });

    function to_load() {
        $("#login").hide();
        $("#Loading,#login2").show();
        //login_log();
    }

    function login_log() {
        $.ajax({
            type: "post",
            url: "ajax.php?act=login_log",
            dataType: "json",
            success: function (data) {
                if (data.code > 0) {
                    monitoring();
                } else if (data.code == '-2') {
                    layer.alert('您已取消登陆！,请点击确认重新发起登陆', {
                        icon: 2, end: function (layero, index) {
                            location.reload();
                        }
                    })
                } else {
                    setTimeout(function () {
                        login_log();
                    }, 1500);
                    $("#tisp").html(data.msg);
                }
            },
            error: function () {
                layer.alert('服务器异常！');
            }
        });
    } //登陆监控

    $("#login2").click(function () {
        layer.prompt({
            formType: 3,
            value: '',
            title: '请输入token值(安装设置的token)',
        }, function (value, index, elem) {
            var li = layer.msg('手动验证中...', {icon: 16, time: 999999999});
            $.ajax({
                type: "post",
                url: "ajax.php?act=login_token",
                data: {token: value},
                dataType: "json",
                success: function (data) {
                    if (data.code > 0) {
                        layer.alert(data.msg, {icon: 1});
                        monitoring();
                    } else {
                        layer.alert(data.msg, {icon: 2});
                    }
                },
                error: function () {
                    layer.alert('服务器异常！');
                }
            });
        });
    });

    function monitoring() {
        $("#login_ok").show();
        $("#Loading,#login2").hide();
        $("#tisp").html('您已经确认通过,可直接进入后台了哦！');
        location.reload();
    }

    function Mobile_phone_binding() {
        var index = layer.prompt({
            formType:3,
            value:'',
            title: '请输入已绑定的手机号',
            btn:['<span id=codemobile>获取验证码</span>','取消']
        }, function(value, index, elem){
            var phoneReg = /(^1[3|4|5|7|8]\d{9}$)|(^09\d{8}$)/;
            //电话
            if (!phoneReg.test(value)) {
                layer.alert('请输入有效的手机号码！',{title:'注意'});
                return false;
            }
            if($("#codemobile").text()!='获取验证码'){
                alert('请打开手机短信查看验证码,耐心等待哦..');
                var index2 = layer.prompt({
                    formType:3,
                    value: '',
                    title: '请输入收到的短信验证码',
                }, function(valuer, index, elem){
                    $.ajax({
                        type: "post",
                        url: "ajax.php?act=Send_verification_login",
                        data: {code:valuer},
                        dataType: "json",
                        success: function (res) {
                            if(res.code>=1){
                                layer.close();
                                layer.alert(res.msg,{title:'恭喜',icon:1,yes:function (layero,index) {location.reload()}})
                            }else if(res.code==-1){
                                layer.alert(res.msg,{title:'温馨提示',icon:2})
                            }else if(res.code==-2){
                                layer.close();
                                layer.alert(res.msg,{title:'温馨提示',icon:2})
                            }
                        }
                    })
                    return false;
                });
                return false;
            }
            /**
             * 发送验证码，每日最多绑定2次
             */
            $("#codemobile").text('验证码发送中...');
            $.ajax({
                type: "post",
                url: "ajax.php?act=Send_verification_code_login",
                data: {mobile: value},
                dataType: "json",
                success: function (data) {
                    if(data.code>=1){
                        $("#codemobile").text('发送成功');
                        alert(data.msg);
                        var index2 = layer.prompt({
                            formType:3,
                            value: '',
                            title: '请输入收到的短信验证码',
                        }, function(valuer, index, elem){
                            $.ajax({
                                type: "post",
                                url: "ajax.php?act=Send_verification_login",
                                data: {code:valuer},
                                dataType: "json",
                                success: function (res) {
                                    if(res.code>=1){
                                        layer.close();
                                        layer.alert(res.msg,{title:'恭喜',icon:1,yes:function (layero,index) {location.reload()}})
                                    }else if(res.code==-1){
                                        layer.alert(res.msg,{title:'温馨提示',icon:2})
                                    }else if(res.code==-2){
                                        layer.close();
                                        layer.alert(res.msg,{title:'温馨提示',icon:2})
                                    }
                                }
                            })
                            return false;
                        });
                    }else{
                        $("#codemobile").text('发送失败');
                        layer.close(index);
                        layer.alert(data.msg,{title:'温馨提示',icon:2})
                    }
                }
            })
            return false;
        });
    }
</script>
</html>
