DROP TABLE IF EXISTS `sky_buylog`;
CREATE TABLE `sky_buylog`
(
    `id`   int(11) NOT NULL AUTO_INCREMENT,
    `gid`  int(11)      DEFAULT NULL COMMENT '商品ID',
    `uid`  int(11)      DEFAULT NULL COMMENT '兑换人',
    `num`  int(11)      DEFAULT 1 COMMENT '下单数量',
    `ip`   varchar(255) DEFAULT NULL,
    `date` datetime     DEFAULT NULL COMMENT '兑换时间',
    PRIMARY KEY (`id`)
) ENGINE = MyISAM
  AUTO_INCREMENT = 1
  DEFAULT CHARSET = utf8;
DROP TABLE IF EXISTS `sky_cache`;
CREATE TABLE `sky_cache`
(
    `K` varchar(255) NOT NULL COMMENT 'cache',
    `V` text,
    PRIMARY KEY (`K`)
) ENGINE = MyISAM
  AUTO_INCREMENT = 1
  DEFAULT CHARSET = utf8;
DROP TABLE IF EXISTS `sky_class`;
CREATE TABLE `sky_class`
(
    `cid`   int(11) NOT NULL AUTO_INCREMENT,
    `sort`  int(11)      DEFAULT NULL COMMENT '排序',
    `name`  varchar(255) DEFAULT NULL,
    `image` text,
    `state` int(11)      DEFAULT '1' COMMENT '1,显示，2隐藏',
    `date`  datetime     DEFAULT NULL,
    PRIMARY KEY (`cid`)
) ENGINE = MyISAM
  AUTO_INCREMENT = 1
  DEFAULT CHARSET = utf8;
DROP TABLE IF EXISTS `sky_config`;
CREATE TABLE `sky_config`
(
    `K` varchar(255) NOT NULL,
    `V` text,
    `C` text,
    PRIMARY KEY (`K`)
) ENGINE = MyISAM
  DEFAULT CHARSET = utf8;
DROP TABLE IF EXISTS `sky_goods`;
CREATE TABLE `sky_goods`
(
    `gid`              int(11) NOT NULL AUTO_INCREMENT,
    `cid`              int(11)        DEFAULT '1' COMMENT '分类ID',
    `sort`             int(11)        DEFAULT NULL COMMENT '排序',
    `name`             varchar(255)   DEFAULT NULL,
    `image`            varchar(255)   DEFAULT NULL,
    `picture`          text COMMENT '商品详情图',
    `money`            decimal(24, 8) DEFAULT NULL COMMENT '成本价格',
    `profits`          decimal(24, 0) DEFAULT '100' COMMENT '商品利润比例',
    `min`              int(255)       DEFAULT '1' COMMENT '最小下单数量',
    `max`              int(255)       DEFAULT NULL COMMENT '最大下单数量',
    `freight`          varchar(255)   DEFAULT '-1' COMMENT '运费模板',
    `method`           varchar(255)   DEFAULT '[1,2,3,4,5,6,7]' COMMENT '商品扩展参数',
    `value`            text COMMENT '提交字段名称 | 分割',
    `quota`            varchar(255)   DEFAULT NULL COMMENT '份数',
    `quantity`         varchar(255)   DEFAULT NULL COMMENT '每份数量',
    `docs`             text COMMENT '商品说明',
    `alert`            text COMMENT '弹窗',
    `sqid`             int(11)        DEFAULT NULL COMMENT '社区ID',
    `state`            int(11)        DEFAULT '1' COMMENT '1上架,2下架',
    `curl`             text COMMENT 'curl链接',
    `post_data`        text COMMENT 'POST内容',
    `goods_id`         int(11)        DEFAULT NULL COMMENT '社区商品编号(亿乐玖伍)',
    `goods_type`       int(11)        DEFAULT NULL COMMENT '社区商品分类(玖伍)',
    `goods_url`        text COMMENT '卡易信下单链接',
    `submit_the_field` varchar(255)   DEFAULT NULL COMMENT '提交字段 | 分割',
    `goods_mainKey`    text,
    `note`    text,
    `date`             datetime       DEFAULT NULL,
    PRIMARY KEY (`gid`)
) ENGINE = MyISAM
  AUTO_INCREMENT = 295
  DEFAULT CHARSET = utf8;
DROP TABLE IF EXISTS `sky_invite`;
CREATE TABLE `sky_invite`
(
    `id`            int(11) NOT NULL AUTO_INCREMENT,
    `uid`           int(11)        DEFAULT NULL COMMENT '邀请者ID',
    `invitee`       int(11)        DEFAULT NULL COMMENT '被邀请者编号',
    `award`         decimal(11, 0) DEFAULT NULL COMMENT '邀请奖励金额池',
    `ip`            varchar(255)   DEFAULT NULL COMMENT '可根据IP配置防刷',
    `draw_time`     datetime       DEFAULT NULL COMMENT '领取时间',
    `creation_time` datetime       DEFAULT NULL COMMENT '创建时间',
    PRIMARY KEY (`id`)
) ENGINE = MyISAM
  AUTO_INCREMENT = 1
  DEFAULT CHARSET = utf8;
DROP TABLE IF EXISTS `sky_journal`;
CREATE TABLE `sky_journal`
(
    `id`      int(11) NOT NULL AUTO_INCREMENT,
    `ip`      varchar(255)   DEFAULT NULL,
    `uid`     int(11)        DEFAULT NULL COMMENT '用户ID',
    `count`   decimal(24, 8) DEFAULT NULL COMMENT '相关数量',
    `name`    varchar(255)   DEFAULT NULL COMMENT '日志名称',
    `content` text COMMENT '日志内容',
    `date`    datetime       DEFAULT NULL COMMENT '发生时间',
    PRIMARY KEY (`id`)
) ENGINE = MyISAM
  AUTO_INCREMENT = 1
  DEFAULT CHARSET = utf8;
DROP TABLE IF EXISTS `sky_login`;
CREATE TABLE `sky_login`
(
    `id`           int(11) NOT NULL AUTO_INCREMENT,
    `token`        varchar(255) DEFAULT NULL,
    `ip`           varchar(255) DEFAULT NULL,
    `state`        int(1)       DEFAULT '3' COMMENT '1:用户确认，2用户取消，3，待确认',
    `finish_time`  datetime     DEFAULT NULL,
    `date_created` datetime     DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = MyISAM
  AUTO_INCREMENT = 1
  DEFAULT CHARSET = utf8;
DROP TABLE IF EXISTS `sky_notice`;
CREATE TABLE `sky_notice`
(
    `id`      int(11) NOT NULL AUTO_INCREMENT,
    `title`   varchar(255) DEFAULT NULL,
    `content` text,
    `browse`  text COMMENT '浏览人数,|分割',
    `date`    datetime     DEFAULT NULL COMMENT '发布时间',
    PRIMARY KEY (`id`)
) ENGINE = MyISAM
  AUTO_INCREMENT = 1
  DEFAULT CHARSET = utf8;
DROP TABLE IF EXISTS `sky_order`;
CREATE TABLE `sky_order`
(
    `id`         int(11)   NOT NULL AUTO_INCREMENT,
    `order`      varchar(255)   DEFAULT NULL COMMENT '订单号',
    `trade_no`   varchar(255)   DEFAULT NULL COMMENT '商户订单',
    `uid`        int(11)        DEFAULT NULL COMMENT '用户ID',
    `ip`         varchar(255)   DEFAULT NULL,
    `input`      varchar(255)   DEFAULT NULL,
    `state`      int(11)        DEFAULT NULL COMMENT '领取状态，1成功，2待处理，3异常，4正在处理，',
    `num`        int(11)        DEFAULT 1 COMMENT '下单份数',
    `return`     text COMMENT '对接返回数据',
    `gid`        int(11)        DEFAULT NULL COMMENT '商品ID',
    `order_id`   text COMMENT '社区返回的订单号',
    `money`      decimal(24, 8) DEFAULT NULL COMMENT '下单成本',
    `payment`    varchar(255)   DEFAULT NULL COMMENT '付款方式',
    `price`      decimal(24, 8) DEFAULT NULL COMMENT '订单金额',
    `user_rmb`   decimal(24, 8) DEFAULT NULL COMMENT '玖伍返回的余额,亿乐为空',
    `remark`     text COMMENT '订单处理信息！',
    `finishtime` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '订单完成时间',
    `addtitm`    datetime       DEFAULT NULL COMMENT '创建时间',
    PRIMARY KEY (`id`)
) ENGINE = MyISAM
  AUTO_INCREMENT = 1
  DEFAULT CHARSET = utf8;
DROP TABLE IF EXISTS `sky_pay`;
CREATE TABLE `sky_pay`
(
    `id`       int(11)      NOT NULL AUTO_INCREMENT,
    `order`    varchar(255) NOT NULL COMMENT '本地生成的订单号',
    `trade_no` varchar(255)   DEFAULT NULL COMMENT '对接易支付生成的订单号',
    `type`     varchar(11)    DEFAULT NULL COMMENT '付款方式，qqpayQQ,wxpay微信,alipay支付宝',
    `uid`      int(11)        DEFAULT NULL COMMENT '操作用户,-1 游客，>0用户',
    `gid`      int(11)        DEFAULT NULL COMMENT '-1,在线充值, >0购买的商品ID',
    `name`     varchar(255)   DEFAULT NULL COMMENT '充值标识,如 后台充值,购买商品等',
    `money`    decimal(24, 8) DEFAULT NULL COMMENT '操作金额',
    `ip`       varchar(255)   DEFAULT NULL,
    `input`    text COMMENT '用户输入的下单内容',
    `num`      int(11)        DEFAULT '1' COMMENT '下单数量',
    `state`    int(11)        DEFAULT '2' COMMENT '订单状态,1:已完成,2未完成',
    `verify`   varchar(255)   DEFAULT '-1' COMMENT '价格监控验证，-1未验证状态！',
    `endtime`  datetime       DEFAULT NULL COMMENT '结束时间',
    `addtime`  datetime       DEFAULT NULL COMMENT '发布时间',
    PRIMARY KEY (`id`, `order`)
) ENGINE = MyISAM
  AUTO_INCREMENT = 1
  DEFAULT CHARSET = utf8;
DROP TABLE IF EXISTS `sky_shequ`;
CREATE TABLE `sky_shequ`
(
    `id`       int(11)      NOT NULL AUTO_INCREMENT,
    `url`      varchar(255)          DEFAULT NULL,
    `type`     int(11)      NOT NULL DEFAULT '1' COMMENT '1,玖伍,2亿乐',
    `username` varchar(222)          DEFAULT NULL,
    `password` varchar(255)          DEFAULT NULL,
    `secret`   varchar(255)          DEFAULT NULL,
    `pattern`  varchar(255) NULL     DEFAULT 1 COMMENT '对接模式',
    `date`     datetime              DEFAULT NULL COMMENT '创建时间',
    PRIMARY KEY (`id`)
) ENGINE = MyISAM
  AUTO_INCREMENT = 1
  DEFAULT CHARSET = utf8;
DROP TABLE IF EXISTS `sky_user`;
CREATE TABLE `sky_user`
(
    `id`            int(11)      NOT NULL AUTO_INCREMENT,
    `user_idu`      varchar(255) NOT NULL COMMENT '唯一识别码',
    `token`         varchar(255)      DEFAULT NULL COMMENT '同系统对接密钥',
    `ip_white_list` text COMMENT 'IP白名单',
    `superior`      int(11)           DEFAULT NULL COMMENT '上级编号',
    `currency`      decimal(24, 0)    DEFAULT '0' COMMENT '用户积分',
    `ip`            varchar(255)      DEFAULT NULL,
    `money`         decimal(24, 8)    DEFAULT '0.00' COMMENT '余额',
    `grade`         int(255)          DEFAULT 1 COMMENT '用户等级！',
    `domain`        varchar(255) NULL COMMENT '店铺域名',
    `configuration` text         NULL COMMENT '其他配置，以序列格式存在',
    `image`         varchar(255)      DEFAULT NULL COMMENT '用户头像',
    `name`          varchar(255)      DEFAULT NULL,
    `qq`            varchar(255)      DEFAULT NULL,
    `mobile`        varchar(255)      DEFAULT NULL COMMENT '电话号码',
    `state`         int(11)           DEFAULT NULL COMMENT '用户状态，1正常，2禁止登陆',
    `recent_time`   timestamp    NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
    `found_date`    datetime          DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = MyISAM
  AUTO_INCREMENT = 1000
  DEFAULT CHARSET = utf8;
DROP TABLE IF EXISTS `sky_token`;
CREATE TABLE `sky_token`
(
    `kid`     int(11) NOT NULL AUTO_INCREMENT,
    `uid`     int(11)      DEFAULT '1' COMMENT '购买者UID',
    `gid`     int(11)      DEFAULT NULL COMMENT '商品ID',
    `code`    varchar(255) DEFAULT NULL COMMENT '提卡密码',
    `token`   varchar(255) DEFAULT NULL COMMENT '卡密内容',
    `ip`      varchar(255) DEFAULT NULL,
    `order`   varchar(255) DEFAULT NULL,
    `endtime` datetime     DEFAULT NULL,
    `addtime` datetime     DEFAULT NULL,
    PRIMARY KEY (`kid`)
) ENGINE = MyISAM
  DEFAULT CHARSET = utf8;
DROP TABLE IF EXISTS `sky_price`;
CREATE TABLE `sky_price`
(
    `mid`      int(12) NOT NULL AUTO_INCREMENT,
    `sort`     int(12)        DEFAULT NULL COMMENT '排序',
    `name`     varchar(255)   DEFAULT NULL COMMENT '等级名称',
    `content`  text COMMENT '等级说明',
    `priceis`  text COMMENT '售价增长比',
    `pointsis` text COMMENT '积分增长比',
    `money`    decimal(12, 2) DEFAULT '0.00' COMMENT '等级价格,0则默认',
    `state`    int(12)        DEFAULT 1 COMMENT '等级开关',
    `addtime`  datetime       DEFAULT NULL COMMENT '创建时间',
    PRIMARY KEY (`mid`)
) ENGINE = MyISAM
  AUTO_INCREMENT = 1
  DEFAULT CHARSET = utf8;
DROP TABLE IF EXISTS `sky_freight`;
CREATE TABLE `sky_freight`
(
    `id`        int(11) NOT NULL AUTO_INCREMENT,
    `name`      varchar(255)   DEFAULT NULL COMMENT '运费模板名称',
    `region`    text COMMENT '地区',
    `money`     decimal(11, 2) DEFAULT NULL COMMENT '运费,和地区挂钩',
    `nums`      int(11)        DEFAULT NULL COMMENT '购买数量>=nums则运费为money',
    `exceed`    decimal(11, 2) DEFAULT NULL COMMENT '高于下单数量额外每件商品的价格',
    `threshold` decimal(11, 2) DEFAULT NULL COMMENT '临界点,高于免运费',
    `date`      datetime       DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = MyISAM
  AUTO_INCREMENT = 1
  DEFAULT CHARSET = utf8;
DROP TABLE IF EXISTS `sky_withdrawal`;
CREATE TABLE `sky_withdrawal`
(
    `id`             int(12) NOT NULL AUTO_INCREMENT,
    `type`           varchar(255)   DEFAULT NULL,
    `name`           varchar(255)   DEFAULT NULL COMMENT '提现者姓名',
    `account_number` varchar(255)   DEFAULT NULL COMMENT '提现账号',
    `uid`            int(11)        DEFAULT NULL,
    `remarks`        text COMMENT '提现者备注',
    `state`          int(1)         DEFAULT '3' COMMENT '1，已完成,2已退回,3待处理',
    `result_code`    text COMMENT '处理结果',
    `money`          decimal(12, 2) DEFAULT NULL COMMENT '提现金额',
    `endtime`        datetime       DEFAULT NULL COMMENT '处理时间',
    `addtime`        datetime       DEFAULT NULL COMMENT '创建时间',
    PRIMARY KEY (`id`)
) ENGINE = MyISAM
  DEFAULT CHARSET = utf8;
INSERT INTO `sky_price` (`mid`,`sort`, `name`, `content`, `priceis`, `pointsis`, `money`, `addtime`)  VALUES ('1','1','普通用户', '普通用户，和游客没什么区别!', '30', '3000', '0.00','2020-03-18 00:00:00');
INSERT INTO `sky_price` (`mid`,`sort`, `name`, `content`, `priceis`, `pointsis`, `money`, `addtime`)  VALUES ('2','2','铜牌代理', '铜牌代理，可以加盟分店了,其他用户在你分站下单你可以获得提成!', '28', '2800', '10.00','2020-03-18 00:00:00');
INSERT INTO `sky_price` (`mid`,`sort`, `name`, `content`, `priceis`, `pointsis`, `money`, `addtime`)  VALUES ('3','3','银牌代理', '银牌代理，除了可以加盟分店外，还可以赚取下级提成，并且收益比上一级别更高！，推荐购买!', '26', '2600', '20.00','2020-03-18 00:00:00');
INSERT INTO `sky_price` (`mid`,`sort`, `name`, `content`, `priceis`, `pointsis`, `money`, `addtime`)  VALUES ('4','4','金牌代理', '金牌代理，除了可以加盟分店外，还可以赚取下级提成，并且收益比上一级别更高！，推荐购买!', '24', '2400', '30.00','2020-03-18 00:00:00');
INSERT INTO `sky_price` (`mid`,`sort`, `name`, `content`, `priceis`, `pointsis`, `money`, `addtime`)  VALUES ('5','5','小站长', '小站长，除了可以加盟分店外，还可以赚取下级提成，并且收益比上一级别更高！，推荐购买!', '22', '2200', '40.00','2020-03-18 00:00:00');
INSERT INTO `sky_price` (`mid`,`sort`, `name`, `content`, `priceis`, `pointsis`, `money`, `addtime`)  VALUES ('6','6','平台站长', '平台站长，除了可以加盟分店外，还可以赚取下级提成，并且收益比上一级别更高！，推荐购买!', '20', '2000', '50.00','2020-03-18 00:00:00');
INSERT INTO `sky_price` (`mid`,`sort`, `name`, `content`, `priceis`, `pointsis`, `money`, `addtime`)  VALUES ('7','7','高级站长', '高级站长，除了可以加盟分店外，还可以赚取下级提成，并且收益比上一级别更高！，推荐购买!', '18', '1800', '60.00','2020-03-18 00:00:00');
INSERT INTO `sky_price` (`mid`,`sort`, `name`, `content`, `priceis`, `pointsis`, `money`, `addtime`)  VALUES ('8','8','领袖站长', '领袖站长，除了可以加盟分店外，还可以赚取下级提成，并且收益比上一级别更高！，推荐购买!', '16', '1600', '70.00','2020-03-18 00:00:00');