/**
 * 小储云商城
 * 模板视图js调用类 cloud
 * @type {{input_data: (function(*, *, *, *): string), data_class: (function(*): string), num: (function(): string), data_goods: (function(*): string)}}
 */
var template = {
    data_class: function (data) { //当前模板分类数据
        if (data.image == '') {
            data.image = '<?php echo $cdnserver; ?>assets/cloud/image/error_img.png';
        }
        var content = '<div class="col-xl-2 col-lg-3 col-sm-4 col-6">\n' +
            '                <div class="contacts__item shadow-sm">\n' +
            '                    <a href="?cid=' + data.cid + '"\n' +
            '                       class="data-tid contacts__img goodTypeChange">\n' +
            '                        <img class="lazy" lay-src="' + data.image + '" onerror="this.src=\'assets/cloud/image/error_img.png\'" style="height: 9em;border-radius: 0.5em" alt="' + data.name + '"/>\n' +
            '                    </a>\n' +
            '                    <div class="contacts__info">\n' +
            '                        <strong>' + data.name + '</strong>\n' +
            '                    </div>\n' +
            '                    <a href="?cid=' + data.cid + '" class="contacts__btn goodTypeChange"\n' +
            '                            style="display: block;">共有' + data.number + '个商品\n' +
            '                    </a>\n' +
            '                </div>\n' +
            '            </div>\n';
        return content;
    },
    data_goods: function (data) { //当前模板商品数据
        if (data.quota != 0) {
            var quota = '' + data.quantity + '个';
        } else {
            var quota = '<font color=#EF5350>库存不足</font>'
        }
        if (data.image == '') {
            data.image = 'assets/cloud/image/error_img.png';
        }
        var content = '<div class="col-xl-2 col-lg-3 col-sm-4 col-6">\n' +
            '            <div class="contacts__item shadow-sm">\n' +
            '                <a href="?mod=shop&gid=' + data.gid + '&cid=' + data.cid + '"\n' +
            '                   class="data-tid contacts__img goodTypeChange">\n' +
            '                    <img class="lazy" lay-src="' + data.image + '" onerror="this.src=\'assets/cloud/image/error_img.png\'" style="height: 9em;border-radius: 0.5em" alt="' + data.name + '"/>\n' +
            '                </a>\n' +
            '                <div class="contacts__info">\n' +
            '                    <strong>' + data.name + '</strong>\n' +
            '                    <small>' + quota + '</small>\n' +
            '                </div>\n' +
            '                <a href="?mod=shop&gid=' + data.gid + '&cid=' + data.cid + '" class="contacts__btn goodTypeChange"\n' +
            '                   style="display: block;">售价 | ' + (data.price - 0) + '元\n' +
            '                </a>\n' +
            '            </div>\n' +
            '        </div>\n';
        return content;
    },
    select_data: function (selectname, addstr, i) { //多选框构建
        var content = '<div class="input-group select">\n' +
            '    <label class="col-form-label" id="var_c' + i + '">' + selectname + '</label>\n' +
            '    <select class="form-control" id="input_val_' + i + '">' + addstr + '</select>\n' +
            '    <i class="form-group__bar"></i>\n' +
            '</div>';
        return content;
    },
    input_data: function (name, placeholder, id, addstr) {//解析此模板对应的下单参数块,每个模板自定义下单信息展示
        if (addstr != '') {
            var content = '' +
                '   <div class="form-group">\n' +
                '        <div class="input-group">\n' +
                '        <label class="col-form-label" id="var_c' + id + '" >' + name + '</label>\n' +
                '        <input type="text"  class="form-control" onblur="checkInput(\'var_c' + id + '\',\'input_val_' + id + '\')" placeholder="' + placeholder + '"  id="input_val_' + id + '" />' + addstr + '</div> \n' +
                '    </div> \n';
        } else {
            var content = '' +
                '   <div class="form-group">\n' +
                '        <div class="input-group">\n' +
                '        <label class="col-form-label" id="var_c' + id + '" >' + name + '</label>\n' +
                '        <input type="text"  class="form-control" onblur="checkInput(\'var_c' + id + '\',\'input_val_' + id + '\')" placeholder="' + placeholder + '"  id="input_val_' + id + '" />\n' +
                '        <i class="form-group__bar"></i>\n' +
                '        </div> \n' +
                '    </div> \n';
        }
        return content;
    },
    num: function () { //下单份数模板
        var content = '<div class="form-group">\n' +
            '        <div class="input-group">\n' +
            '        <label class="col-form-label">下单份数</label>\n' +
            '        <input type="number" min="1"  class="form-control" value="1"  placeholder="请填写商品下单份数！"  id="num" /></div> \n' +
            '    </div> \n';
        return content;
    },
    image: function (img) {
        swal({
            title: false,
            text: false,
            imageUrl: img,
            imageWidth: 300,
            imageHeight: 300,
            animation: false,
            customClass: 'jello animated',
            showConfirmButton: false,
        })
    }
    , success: function (data) {

        $('#points').on('click', function () {
            var that = this;
            layer.tips('<font color=#fff>此商品支持积分付款哦,每日限量快来领取吧！</font>', that, {tips: [1, '#000']});
        });
        if ($_GET['cid'] == undefined || $_GET['cid'] == '') {
            var url = './'
        } else {
            var url = './?cid=' + $_GET['cid'];
        }

        layui.use('util', function () {
            var util = layui.util;
            util.fixbar({
                bar1: '&#xe65c;'
                , bgcolor: '#FF5252'
                , click: function (type) {
                    console.log(type);
                    if (type === 'bar1') {
                        location.href = url
                    }
                }
            });
        });

        var picture = $("#gootsp").attr('data-picture');
        var coutent_img = '';
        if (picture == '' || picture == undefined) {
            coutent_img = '<div class="swiper-slide"><img onclick="template.image(\'' + $("#gootsp").attr('data-image') + '\')" src="' + $("#gootsp").attr('data-image') + '"  /></div>';
        } else {
            array_img = picture.split('|');
            $.each(array_img, function (key, val) {
                coutent_img += '<div class="swiper-slide"><img onclick="template.image(\'' + val + '\')" src="' + val + '"  /></div>';
            });
        }
        $("#picture").html(coutent_img);

        var swiper = new Swiper('.swiper-container', {
            slidesPerView: 1,
            spaceBetween: 30,
            loop: true,
            pagination: {
                el: '.swiper-pagination',
                dynamicBullets: true,
            }
        });

        if (data.data['CarriageTem'] != undefined && data.data['freight'] != "") { //启用运费模板
            if (data.data['freight'] != "-1") {
                CarriageTem.start(data.data['CarriageTem'], data.data['freight'], data.data['price']);
            }
        }
        $("#level").html('<font color="#ff4500">' + data.data.level + '</font>');
        var level_arr = $("#gootsp").attr('data-level_arr');
        if (level_arr == '-1') {
            layer.tips('<font color="white">恭喜！您当前为最高等级密价！</font>', '#level', {tips: [1, '#651FFF']});
            $("#level").attr('onclick', 'layer.msg(\'恭喜！您当前为最高等级密价！\')');
        } else {
            layer.tips('<font color="white">此商品有更多优惠哦！<br>点击查看获取！</font>', '#level', {tips: [3, '#6200EA']});
            $("#level").attr('onclick', 'layer.alert(\'' + unescape(level_arr) + '\',{title:\'密价等级表\',btn:[\'朕已阅\',\'升级密价\'],shade: [0.8, \'#000\'],shadeClose:true,btn2:function(layero,index){window.open(\'/user/grade.php\')}})');
        }
    },
    query_tem: function (data) { //订单模板
        $("#order_all,#order_a,#order_b,#order_c,#order_d,#order_e").html('');
        var content_error = '<div class="layui-col-xs12 layui-col-sm6 layui-col-md4 layui-col-lg3"><div class="layui-card qt-card">\n' +
            '              <div class="layui-card-header">\n' +
            '               <p style="width: 70%" class="layui-elip">没有查询到相关订单</p>\n' +
            '                       </div>\n' +
            '                        <div class="layui-card-body">\n' +
            '                       <div class="layui-row layui-col-space10">\n' +
            '                            <div class="layui-col-xs4" style="text-align: center">\n' +
            '                                <img src="' + logo + '">\n' +
            '                            </div><div class="layui-col-xs8" style="text-align: center">\n' +
            '                                登陆后台可永久保存订单哦<hr><a href="user">进入后台</a>\n' +
            '                            </div>\n' +
            '         </div>\n' +
            '    </div>\n' +
            '</div></div>';

        if (data.code == 1) {
            var content = ''; //全部订单
            var content_a = ''; //已完成
            var content_b = ''; //待处理
            var content_c = ''; //异常订单
            var content_d = ''; //进行中
            var content_e = ''; //已退款
            $.each(data.data, function (key, val) {

                switch (val['state']) {
                    case '1': //成功
                        var state = '<font color="#43A047">已完成</font>';
                        break;
                    case '2': //待处理
                        var state = '<font color="#651FFF">待处理</font>';
                        break;
                    case '3': //异常
                        var state = '<font color="#FF1744">异常中</font>';
                        break;
                    case '4': //正在处理
                        var state = '<font color="#F57C00">正在处理</font>';
                        break;
                    case '5': //已退款
                        var state = '<font color="#424242">已退款</font>';
                        break;
                    default:
                        var state = '<font color="#607D8B">未知状态</font>';
                        break;
                }

                if (val.payment == '积分付款') {
                    val.price = val.price + '积分';
                } else if (val.payment == '免费领取') {
                    val.price = '<font color="#2e8b57">免费商品</font>';
                } else {
                    val.price = val.price + '元';
                }

                if (val.token !== "0") {
                    msg_token = (val.token).join('<br>');
                    btns = '<button class="layui-btn qt-btn layui-btn-sm layui-btn-primary" onclick="layer.alert(\'卡密信息为：<br>' + msg_token + '\',{title:\'您购买的卡密信息\'})">\n' +
                        '                             提取卡密\n' +
                        '                      </button>';
                } else {
                    btns = '';
                }

                if (val.logistics != "-1") { //有快递？当然是查询
                    btne = '<button class="layui-btn qt-btn layui-btn-sm layui-btn-primary" onclick="layer.alert(\'快递单号信息：<br>' + val.logistics + '\<hr>查询快递方法：复制快递单号，手机打开菜鸟包裹查询即可！\',{title:\'您的快递单号\'})">\n' +
                        '                             快递单号\n' +
                        '                      </button>';
                } else {
                    btne = '';
                }

                content += content_bf = '<div class="layui-col-xs12 layui-col-sm6 layui-col-md4 layui-col-lg3"><div class="layui-card qt-card">\n' +
                    '              <div class="layui-card-header">\n' +
                    '               <p style="width: 70%" class="layui-elip">' + val.name + '</p>\n' +
                    '                    <span class="layui-layout-right layui-elip"\n' +
                    '                           style="width:30%;text-align: right;margin-right: 0.5em">\n' +
                    '                          ' + state + '\n' +
                    '                    </span>\n' +
                    '                       </div>\n' +
                    '                        <div class="layui-card-body">\n' +
                    '                       <div class="layui-row layui-col-space10">\n' +
                    '                            <div class="layui-col-xs4">\n' +
                    '                                <img src="' + val.image + '"/>\n' +
                    '                            </div>\n' +
                    '                       <div class="layui-col-xs8"\n' +
                    '                            style="font-size: 0.8em;color:black;font-family: \'微软雅黑\'">\n' +
                    '                            下单时间：' + val.addtitm + '<br>\n' +
                    '                            商品总价：' + val.price + '<br>\n' +
                    '                            购买方式：' + val.payment + '\n' +
                    '                      </div>\n' +
                    '                  <div style="width: 100%;text-align: right;margin-top: 1em">\n' +
                    '                       <button class="layui-btn qt-btn layui-btn-sm layui-btn-primary" onclick="merchandise.query_data(' + val.id + ')">\n' +
                    '                             查看详情\n' +
                    '                      </button>' + btns + btne + '\n' +
                    '               </div>\n' +
                    '         </div>\n' +
                    '    </div>\n' +
                    '</div></div>';

                switch (val['state']) {
                    case '1': //成功
                        content_a += content_bf;
                        break;
                    case '2': //待处理
                        content_b += content_bf;
                        break;
                    case '3': //异常
                        content_c += content_bf;
                        break;
                    case '4': //正在处理
                        content_d += content_bf;
                        break;
                    case '5': //已退款
                        content_e += content_bf;
                        break;
                }


                content_bf = '';
            });

            if (content == '') {
                content = content_error;
            }
            if (content_a == '') {
                content_a = content_error;
            }
            if (content_b == '') {
                content_b = content_error;
            }
            if (content_c == '') {
                content_c = content_error;
            }
            if (content_d == '') {
                content_d = content_error;
            }
            if (content_e == '') {
                content_e = content_error;
            }

            $("#order_all").html(content);
            $("#order_a").html(content_a);
            $("#order_b").html(content_b);
            $("#order_c").html(content_c);
            $("#order_d").html(content_d);
            $("#order_e").html(content_e);
            content = '';
        } else {
            $("#order_all,#order_a,#order_b,#order_c,#order_d,#order_e").html(content_error);
        }
    },
    SharePoster: function (gid) {
        layer.msg('正在生成商品分享海报...', {icon: 16, time: 9999999})
        $.ajax({
            type: "post",
            url: "/ajax.php?act=SharePoster",
            data: {gid: gid},
            dataType: "json",
            success: function (data) {
                if (data.code == 1) {
                    layer.alert('<img src="' + data.src + '" width=300 heigth=450 />', {
                        area: ['340px', '490px'],
                        title: false,
                        btn: false, shade: [0.8, '#000'],
                        shadeClose: true,
                    })
                } else {
                    layer.msg(data.msg, {icon: 2});
                }
            },
            error: function () {
                layer.alert('生成失败！');
            }
        });
    },
};


if ($_GET['cid'] == undefined && $_GET['name'] == undefined) {
    merchandise.cid_data();//调用分类
} else if ($_GET['cid'] != undefined && $_GET['gid'] == undefined || $_GET['name'] != undefined) {

    merchandise.gid_data($_GET['cid'], $_GET['name']);

    layui.use('util', function () {
        var util = layui.util;
        util.fixbar({
            bar1: '&#xe65c;'
            , bgcolor: '#FF5252'
            , click: function (type) {
                console.log(type);
                if (type === 'bar1') {
                    location.href = './';
                }
            }
        });
    });
} else if ($_GET['cid'] != undefined && $_GET['gid'] != undefined) {
    /**
     * 调用商品下单界面模块
     */
    $("#shop").show();
    merchandise.shop_data($_GET['gid']);
}