<?php
/**
 * 登陆
 */
include "../includes/fun.global.php";

include_once ROOT . 'Connect/Connect.php';

use QqConnect\QqConnect;
use sms\sms_operation;

if (!empty($_COOKIE['THEKEY'])) {
    header("Location:index.php");
    return false;
}
if ($_QET['act'] == 'login') {
    QqConnect::Start('/user/login.php?act=login_reception');
    //echo login_data::login('/user/login.php?act=login_reception');
}
if ($_QET['act'] == 'login_reception') {
    QqConnect::Reception($_QET['code']);
    //echo login_data::login_reception($_QET);
}


$api_text = get_curl('https://v1.hitokoto.cn/');
$api_text = json_decode($api_text, TRUE);
if (!is_mobile()) {
    $image = background::image();
}
if ($_QET['act'] == 'Send_verification_code_login') {
    sms_operation::user_login((int)$_QET['mobile'], $conf['usersmslogin']);
}
if ($_QET['act'] == 'Send_verification_login') {
    sms_operation::user_login_verify((int)$_QET['code']);
}
global $cdnserver;
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8"/>
    <title>用户登陆</title>
    <meta name="keywords" content="<?= $conf['keywords'] ?>">
    <meta name="description" content="<?= $conf['description'] ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="A fully featured admin theme which can be used to build CRM, CMS, etc." name="description"/>
    <meta content="Coderthemes" name="author"/>
    <!-- App favicon -->
    <link rel="shortcut icon" href="/assets/favicon.ico">

    <!-- App css -->
    <link href="<?= $cdnserver == null ? '../' : $cdnserver ?>assets/css/icons.min.css" rel="stylesheet"
          type="text/css"/>
    <link href="<?= $cdnserver == null ? '../' : $cdnserver ?>assets/css/app.min.css" rel="stylesheet" type="text/css"/>
    <link href="<?= $cdnserver == null ? '../' : $cdnserver ?>assets/layui/css/layui.css" type="text/css">
</head>

<body class="auth-fluid-pages pb-0">

<div class="auth-fluid"
     style="<?= $image == false ? 'background:linear-gradient(to left, #70e1f5, #ffd194);' : $image ?>">
    <!--Auth fluid left content -->
    <div class="auth-fluid-form-box">
        <div class="align-items-center d-flex h-100">
            <div class="card-body">

                <!-- Logo -->
                <div class="auth-brand text-center text-lg-left">
                    <a href="../">
                        <span><img src="<?= $conf['logo'] ?>" alt="" height="18"></span>
                    </a>
                </div>

                <!-- User pic with title-->
                <div class="text-center w-75 m-auto">
                    <img src="/assets/img/qq.png" height="88"
                         alt="user-image" class="rounded-circle">
                    <h4 class="text-dark-50 text-center mt-3" style="font-weight: 300">你好！用户</h4>
                    <a href="?act=login" target="_blank" class="btn btn-primary btn-block text-white mt-3 shadow-lg">
                        登陆用户后台
                    </a>
                    <?php if ($conf['sms_switch_user'] == 1) { ?>
                        <a href="javascript:Mobile_phone_binding()"
                           class="btn btn-danger btn-block text-white mt-3 shadow-lg">
                            使用短信验证登陆
                        </a>
                    <?php } ?>

                    <a href="javascript:Weix.image()"
                       class="btn btn-success btn-block text-white mt-3 shadow-lg">
                        点击使用微信登陆
                    </a>

                </div>
                <div class="text-center mt-4">
                    <p class="text-muted font-18" style="font-weight: 300"><?= $api_text['hitokoto'] ?></p>
                </div>
            </div> <!-- end .card-body -->
        </div> <!-- end .align-items-center.d-flex.h-100-->
    </div>
    <!-- end auth-fluid-form-box-->

    <!-- Auth fluid right content -->
    <div class="auth-fluid-right text-center">
        <div class="auth-user-testimonial">
            <p class="lead"><?= $api_text['hitokoto'] ?></p>
            <p>
                <?= $conf['sitename'] ?>
            </p>
        </div> <!-- end auth-user-testimonial-->
    </div>
    <!-- end Auth fluid right content -->
</div>
<!-- end auth-fluid-->
<!-- App js -->
<script src="<?= $cdnserver == null ? '../' : $cdnserver ?>assets/layui/layui.all.js"></script>
<script src="<?= $cdnserver == null ? '../' : $cdnserver ?>assets/js/app.min.js"></script>
<script>
    <?php if($conf['sms_switch_user'] == 1){  ?>
    function Mobile_phone_binding() {
        var index = layer.prompt({
            formType: 3,
            value: '',
            title: '请输入已绑定的手机号',
            btn: ['<span id=codemobile>获取验证码</span>', '取消']
        }, function (value, index, elem) {
            var phoneReg = /(^1[3|4|5|6|7|8]\d{9}$)|(^09\d{8}$)/;
            //电话
            if (!phoneReg.test(value)) {
                layer.alert('请输入有效的手机号码！', {title: '注意'});
                return false;
            }
            if ($("#codemobile").text() != '获取验证码') {
                alert('请打开手机短信查看验证码,耐心等待哦..');
                var index2 = layer.prompt({
                    formType: 3,
                    value: '',
                    title: '请输入收到的短信验证码',
                }, function (valuer, index, elem) {
                    $.ajax({
                        type: "post",
                        url: "?act=Send_verification_login",
                        data: {code: valuer},
                        dataType: "json",
                        success: function (res) {
                            console.log(res)
                            if (res.code >= 1) {
                                layer.close();
                                layer.alert(res.msg, {
                                    title: '恭喜', icon: 1, yes: function (layero, index) {
                                        location.reload()
                                    }
                                })
                            } else if (res.code == -1) {
                                layer.alert(res.msg, {title: '温馨提示', icon: 2})
                            } else if (res.code == -2) {
                                layer.close();
                                layer.alert(res.msg, {title: '温馨提示', icon: 2})
                            }
                        }
                    })
                    return false;
                });
                return false;
            }
            /**
             * 发送验证码，每日最多绑定2次
             */
            $("#codemobile").text('验证码发送中...');
            $.ajax({
                type: "post",
                url: "?act=Send_verification_code_login",
                data: {mobile: value},
                dataType: "json",
                success: function (data) {
                    if (data.code >= 1) {
                        alert(data.msg);
                        $("#codemobile").text('发送成功');
                        var index2 = layer.prompt({
                            formType: 3,
                            value: '',
                            title: '请输入收到的短信验证码',
                        }, function (valuer, index, elem) {
                            $.ajax({
                                type: "post",
                                url: "?act=Send_verification_login",
                                data: {code: valuer},
                                dataType: "json",
                                success: function (res) {
                                    console.log(res)
                                    if (res.code >= 1) {
                                        layer.close();
                                        layer.alert(res.msg, {
                                            title: '恭喜', icon: 1, yes: function (layero, index) {
                                                location.reload()
                                            }
                                        })
                                    } else if (res.code == -1) {
                                        layer.alert(res.msg, {title: '温馨提示', icon: 2})
                                    } else if (res.code == -2) {
                                        layer.close();
                                        layer.alert(res.msg, {title: '温馨提示', icon: 2})
                                    }
                                }
                            })
                            return false;
                        });
                    } else {
                        $("#codemobile").text('发送失败');
                        layer.close(index);
                        layer.alert(data.msg, {title: '温馨提示', icon: 2})
                    }
                }
            })
            return false;
        });
    }

    <?php } ?>
    var Weix = {
        image: function () {
            layer.msg('获取微信登陆数据中...', {icon: 16, time: 99999});
            $.ajax({
                type: "POST",
                url: "/Connect/Weix.php?act=UserImage",
                data: {type: 1},
                dataType: "json",
                success: function (data) {
                    if (data.code == 1) {
                        if (data.type == 1) {
                            location.href = data.url;
                        } else {
                            layer.open({
                                title: '请在微信客户端扫码登陆',
                                content: '<div style="width: 300px;height: 300px;margin: auto"><img src="' + data.image + '" style="width: 100%;height: 100%;" /><hr><center><code>' + data.url + '</code><br>可复制链接在微信内打开访问！</center></div>',
                                btn: ['我已扫码', '取消'],
                                anim: 6,
                                btn1: function (layero, index) {
                                    //扫码验证！
                                    var is_do = layer.load(3);
                                    $.ajax({
                                        type: "POST",
                                        url: "/Connect/Weix.php?act=UserImageVerify",
                                        dataType: "json",
                                        success: function (data) {
                                            layer.close(is_do);
                                            if (data.code == 1) {
                                                layer.alert(data.msg, {
                                                    title: '恭喜', icon: 1, yes: function (layero, index) {
                                                        location.reload()
                                                    }
                                                })
                                            } else alert(data.msg);
                                        },
                                        error: function () {
                                            layer.alert('检测失败！');
                                        }
                                    });

                                }
                            })
                        }
                    } else {
                        layer.msg(data.msg, {icon: 2});
                    }
                },
                error: function () {
                    layer.alert('加载失败！');
                }
            });
        }
    }
</script>
</body>
</html>
