<?php
/**
 * 密钥管理,同系统对接用
 */
$title = '同系统对接密钥管理';
include 'header.php';
?>

<div class="row">
    <div class="col-sm-12">
        <!-- Profile -->
        <div class="card bg-white">
            <div class="card-body profile-user-box">
                <div class="row">
                    <div class="col-sm-8">
                        <div class="media">
                            <span class="float-left m-2 mr-4 hide"><img src="<?= $USERDATA['image'] ?>"
                                                                        style="height: 100px;" alt=""
                                                                        class="rounded-circle img-thumbnail"></span>
                            <div class="media-body">
                                <h5 class="mt-1 mb-1">ID：<?= $USERDATA['id'] ?></h5>
                                <h5 class="mt-1 mb-1">
                                    KEY：<span><?= $USERDATA['token'] == null ? '未生成' : '<a id="token" href="javascript:layer.alert($(\'#token\').attr(\'data-token\'),{title:\'请手动复制密钥\'})" data-token="' . $USERDATA['token'] . '">查看密钥</a>' ?></span>
                                </h5>
                                <h5 class="mt-1 mb-1">账户余额：<?= $USERDATA['money'] ?>元</h5>
                                <p class="mt-3 font-16 text-success">
                                    我的订单 <a href="/?mod=query" target="_blank">查询</a></p>
                            </div> <!-- end media-body-->
                        </div>
                    </div> <!-- end col-->
                    <div class="col-sm-4">
                        <div class="text-center mt-sm-0 mt-3 text-sm-right">
                            <button type="button" class="btn btn-primary btn-rounded mt-1"
                                    onclick="Docking.add_token()">
                                <i class="mdi mdi-account-edit mr-1"></i> 生成对接密钥
                            </button>
                            <button type="button" class="btn btn-warning btn-rounded mt-1" onclick="Docking.set_ip()">
                                <i class="mdi mdi-account-edit mr-1"></i> 设置IP白名单
                            </button>

                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-sm-12">
        <div class="card">
            <div class="card-header">
                以下为您添加的白名单IP，| 为分隔符
            </div>
            <div class="card-body text-success"
                 id="ip_data"><?= $USERDATA['ip_white_list'] == null ? '一个白名单IP都没有,您必须添加一个可以进行商品对接！' : $USERDATA['ip_white_list'] ?></div>
        </div>
    </div>
</div>
<?php
include 'bottom.php';
?>
<script>
    var Docking = { //商品对接设置类
        add_token: function () {
            $.ajax({
                type: "post",
                url: "ajax.php?act=add_token",
                dataType: "json",
                success: function (data) {
                    if (data.code == 1) {
                        $("#token").attr('data-token', data.token);
                        layer.alert('您新的密钥为：<br>' + data.token, {
                            btn1: function (layero, index) {
                                location.reload();
                            }
                        });
                    } else {
                        layer.msg('生成失败');
                    }
                },
                error: function () {
                    layer.alert('生成失败！');
                }
            });
        },
        set_ip: function () {
            var ips = $("#ip_data").text();
            var ips = ips.split("|");
            console.log(ips);
            var content = ips.join('\n');
            layer.prompt({
                formType: 2,
                value: content,
                title: '一行一个IP！',
                area: ['350px', '350px'] //自定义文本域宽高
            }, function (value, index, elem) {
                layer.close(index);
                var value = value.split('\n');
                console.log(value);
                $.ajax({
                    type: "post",
                    url: "ajax.php?act=ip_data",
                    data: {
                        ip_data: value
                    },
                    dataType: "json",
                    success: function (data) {
                        if (data.code == 1) {
                            $("#ip_data").text(data.ip_data);
                            layer.alert(data.msg);
                        } else {
                            layer.msg(data.msg);
                        }
                    },
                    error: function () {
                        layer.alert('设置失败！');
                    }
                });
            });
        }
    }
</script>
