using Qianbo.BLL;
using Qianbo.BLL.CommonModel;
using Qianbo.Common;
using Qianbo.Model;
using System;
using System.Data;
using System.Web.Profile;
using System.Web.SessionState;
using System.Web.UI;

public partial class Other_AddInfoForm : System.Web.UI.Page
{
    protected B_CustomForm BCustomForm = new B_CustomForm();
    private B_CustomFormField BCustomFormField = new B_CustomFormField();
    protected B_InfoModel BInfoModel = new B_InfoModel();
    private B_Money BMoney = new B_Money();
    private B_ShowFieldStyle BShowFieldStyle = new B_ShowFieldStyle();
    private B_User BUser = new B_User();
    protected int CustomFormId = 0;
    private DataTable dtIsUser;
    protected M_CustomForm MCustomForm = new M_CustomForm();
    protected B_SiteInfo SiteBll = new B_SiteInfo();

    private void GetIsOk()
    {
        if (this.MCustomForm.IsUnlockTime)
        {
            if (DateTime.Parse(this.MCustomForm.StartTime.ToShortDateString()) > DateTime.Parse(DateTime.Now.ToShortDateString()))
            {
                Qianbo.Common.Function.ShowMsg(0, "<li>" + this.MCustomForm.FormName + "启用了时间限制，暂无法使用" + this.MCustomForm.FormName + "。</li><li><a href='javascript:window.history.back(-1)'>返回上一步</a></li>");
            }
            if (DateTime.Parse(this.MCustomForm.EndTime.ToShortDateString()) < DateTime.Parse(DateTime.Now.ToShortDateString()))
            {
                Qianbo.Common.Function.ShowMsg(0, "<li>" + this.MCustomForm.FormName + "启用了时间限制，目前已过期。</li><li><a href='javascript:window.history.back(-1)'>返回上一步</a></li>");
            }
        }
        if (this.MCustomForm.UserGroup != "|")
        {
            if (!this.BUser.IsLogin())
            {
                Qianbo.Common.Function.ShowMsg(0, "<li>请先登录才能使用" + this.MCustomForm.FormName + "功能</li><li><a href='" + Param.ApplicationRootPath + "/User/Login.aspx'>登陆</a> <a href='javascript:window.history.back(-1)'>返回上一步</a></li>");
            }
            else if (this.MCustomForm.UserGroup.IndexOf("|" + this.BUser.GetUser(this.BUser.GetCookie().UserID).GroupID + "|") == -1)
            {
                Qianbo.Common.Function.ShowMsg(0, "<li>您所在的用户组无权限使用" + this.MCustomForm.FormName + "功能</li><li><a href='javascript:window.history.back(-1)'>返回上一步</a></li>");
            }
        }
        if (this.dtIsUser.Rows.Count > 0)
        {
            for (int i = 0; i < this.dtIsUser.Rows.Count; i++)
            {
                if ((this.dtIsUser.Rows[i]["IsNotNull"].ToString() == "True") && ((base.Request.Form["txt_" + this.dtIsUser.Rows[i]["Name"].ToString()] == "") || (base.Request.Form["txt_" + this.dtIsUser.Rows[i]["Name"].ToString()] == null)))
                {
                    Qianbo.Common.Function.ShowMsg(0, "<li>" + this.dtIsUser.Rows[i]["Alias"].ToString() + "不能为空</li><li><a href='javascript:window.history.back(-1)'>返回上一步</a></li>");
                }
                if ((this.dtIsUser.Rows[i]["Type"].ToString() == "NumberType") && !Qianbo.Common.Function.CheckNumber(base.Request.Form["txt_" + this.dtIsUser.Rows[i]["Name"].ToString()]))
                {
                    Qianbo.Common.Function.ShowMsg(0, "<li>" + this.dtIsUser.Rows[i]["Alias"].ToString() + "必须为数字</li><li><a href='javascript:window.history.back(-1)'>返回上一步</a></li>");
                }
            }
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        this.CustomFormId = int.Parse(base.Request.QueryString["CustomFormId"]);
        this.dtIsUser = this.BCustomFormField.GetIsUserList(this.CustomFormId);
        this.MCustomForm = this.BCustomForm.GetModel(this.CustomFormId);
        if (!this.Page.IsPostBack)
        {
            this.GetIsOk();
            if (this.MCustomForm.IsValidate)
            {
                if (this.Session["ValidateCode"] == null)
                {
                    Qianbo.Common.Function.ShowMsg(0, "<li>您在管理登录停留的时间过长，导致验证码失效。请重新返回登录页面进行登录。</li><li><a href='javascript:window.history.back(-1)'>返回上一步</a></li>");
                }
                if (this.Session["ValidateCode"].ToString() != base.Request.Form["txtValidate"].Trim().ToLower())
                {
                    Qianbo.Common.Function.ShowMsg(0, "<li>您输入的验证码和系统产生的不一致，请重新输入。</li><li><a href='javascript:window.history.back(-1)'>返回上一步</a></li>");
                }
            }
            int userId = 0;
            string logName = "匿名用户";
            if (this.BUser.IsLogin())
            {
                userId = this.BUser.GetCookie().UserID;
                logName = this.BUser.GetUser(this.BUser.GetCookie().UserID).LogName;
            }
            if (this.MCustomForm.IsSubmitNum)
            {
                if (!Qianbo.Common.Function.ReadTempCookies("CustomForm_" + this.CustomFormId, this.CustomFormId.ToString()))
                {
                    Qianbo.Common.Function.SaveTempCookies("CustomForm_" + this.CustomFormId, this.CustomFormId.ToString());
                }
                else
                {
                    Qianbo.Common.Function.ShowMsg(0, "<li>" + this.MCustomForm.FormName + "设置为禁止用户多次提交数据</li><li><a href='javascript:window.history.back(-1)'>返回上一步</a></li>");
                }
            }
            if (userId != 0)
            {
                B_User user = new B_User();
                if ((user.GetUser(userId).YellowBoy + this.MCustomForm.Money) < 0M)
                {
                    Qianbo.Common.Function.ShowMsg(0, "<li>您剩余的金币不足，无法提交该表单。</li><li><a href='javascript:window.history.back(-1)'>返回上一步</a></li>");
                }
                else
                {
                    this.BMoney.YellowBoy(this.MCustomForm.Money, userId);
                }
            }
            string tableName = this.MCustomForm.TableName;
            DataTable dt = new DataTable();
            dt.Columns.Add(new DataColumn("FieldName", typeof(string)));
            dt.Columns.Add(new DataColumn("FieldValue", typeof(string)));
            DataRow row = dt.NewRow();
            row[0] = "UId";
            row[1] = userId;
            dt.Rows.Add(row);
            DataRow row2 = dt.NewRow();
            row2[0] = "UName";
            row2[1] = logName;
            dt.Rows.Add(row2);
            DataRow row3 = dt.NewRow();
            row3[0] = "Ip";
            row3[1] = base.Request.ServerVariables["REMOTE_ADDR"];
            dt.Rows.Add(row3);
            DataRow row4 = dt.NewRow();
            row4[0] = "AddTime";
            row4[1] = DateTime.Now.ToString();
            dt.Rows.Add(row4);
            string str4 = string.Empty;
            for (int i = 0; i < this.dtIsUser.Rows.Count; i++)
            {
                DataRow row5 = dt.NewRow();
                row5[0] = this.dtIsUser.Rows[i]["Name"].ToString();
                string str5 = this.dtIsUser.Rows[i]["Type"].ToString();
                if (str5 == null)
                {
                    goto Label_07AA;
                }
                if (!(str5 == "ListBoxType"))
                {
                    if (str5 == "RadioType")
                    {
                        goto Label_0650;
                    }
                    if (str5 == "MultipleTextType")
                    {
                        goto Label_0742;
                    }
                    goto Label_07AA;
                }
                str4 = base.Request.Form["txt_" + this.dtIsUser.Rows[i]["Name"].ToString() + ""];
                if ((str4 == "") || (str4 == null))
                {
                    row5[1] = "";
                }
                else
                {
                    if (!str4.EndsWith(","))
                    {
                        str4 = str4 + ",";
                    }
                    if (!str4.StartsWith(","))
                    {
                        str4 = "," + str4;
                    }
                    row5[1] = str4;
                }
                dt.Rows.Add(row5);
                row5 = dt.NewRow();
                row5[0] = this.dtIsUser.Rows[i]["Name"].ToString() + "_Id";
                str4 = base.Request.Form["txt_" + this.dtIsUser.Rows[i]["Name"].ToString() + "_Id"];
                if ((str4 == "") || (str4 == null))
                {
                    row5[1] = "";
                }
                else
                {
                    if (!str4.EndsWith(","))
                    {
                        str4 = str4 + ",";
                    }
                    if (!str4.StartsWith(","))
                    {
                        str4 = "," + str4;
                    }
                    row5[1] = str4;
                }
                dt.Rows.Add(row5);
                continue;
            Label_0650:
                row5[1] = base.Request.Form["txt_" + this.dtIsUser.Rows[i]["Name"].ToString() + ""];
                dt.Rows.Add(row5);
                row5 = dt.NewRow();
                row5[0] = this.dtIsUser.Rows[i]["Name"].ToString() + "_Id";
                row5[1] = base.Request.Form["txt_" + this.dtIsUser.Rows[i]["Name"].ToString() + "_Id"];
                dt.Rows.Add(row5);
                continue;
            Label_0742:
                row5[1] = this.SiteBll.GetFiltering(base.Request.Form["txt_" + this.dtIsUser.Rows[i]["Name"].ToString() + ""]);
                dt.Rows.Add(row5);
                continue;
            Label_07AA:
                row5[1] = this.SiteBll.GetFiltering(base.Request.Form["txt_" + this.dtIsUser.Rows[i]["Name"].ToString() + ""]);
                dt.Rows.Add(row5);
            }
            this.BInfoModel.AddInfoModel(dt, tableName);
            Qianbo.Common.Function.ShowMsg(1, "<li>成功提交信息</li><li><a href='/'>返回网站首页</a></li>");
            this.dtIsUser.Clear();
            this.dtIsUser.Dispose();
        }
    }
}