﻿<%@ Page Language="C#" AutoEventWireup="true" Inherits="System_User_LogList, QianboCMS" EnableEventValidation="false" %>
<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<%@ Import Namespace="Qianbo.BLL" %>
<%@ Import Namespace="Qianbo.Common" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>操作日志</title>
    <link href="../Css/layout.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" src="../../Js/Common.js"></script>
    <script language="javascript" type="text/javascript" src="../../Js/DatePicker/WdatePicker.js"></script>
    <script type="text/javascript">
        function CheckValidate() {
            var dayCount = $('txtDayCount').value.trim();
            if (!CheckNumberNotZero(dayCount)) {
                alert("清理日志天数必须为正整数！");
                return false;
            }
            if (confirm('是否确定清理' + dayCount + '天前的日志记录？')) {
                return true;
            }
            else {
                return false;
            }
        }
    </script>
</head>

<body>
    <form id="form1" runat="server">
        <table cellspacing="1" cellpadding="0" class="wzdh" align="center">
            <tr>
                <td style="padding-left: 10px;">
                    <img src="../Images/Skin/Default/you.gif" align="absmiddle" />
                    您现在的位置：<a href="../SystemInfo.aspx">后台管理</a> &gt;&gt; 日志管理
				</td>
            </tr>
        </table>
        <table class="border" cellspacing="1" cellpadding="0" align="center">
            <tr>
                <td class="wzlist">
					<span style="float: left;">
						操作类型：
						<asp:DropDownList ID="ddlLogType" runat="server">
							<asp:ListItem Value="0" Text="所有类型"></asp:ListItem>
							<asp:ListItem Value="1" Text="登陆/退出"></asp:ListItem>
							<asp:ListItem Value="2" Text="添加操作"></asp:ListItem>
							<asp:ListItem Value="3" Text="修改操作"></asp:ListItem>
							<asp:ListItem Value="4" Text="清除操作"></asp:ListItem>
						</asp:DropDownList>
						操作者：
						<asp:TextBox ID="txtUserName" runat="server" Width="75" MaxLength="20"></asp:TextBox>
						起始日期：
						<asp:TextBox ID="txtStartTime" runat="server" Width="60" MaxLength="10" Columns="10" onClick="WdatePicker()"></asp:TextBox>
						截止日期：
						<asp:TextBox ID="txtEndTime" runat="server" Width="60" MaxLength="10" Columns="10" onClick="WdatePicker()"></asp:TextBox>
						<asp:Button ID="btnSearch" runat="server" Text="查询" CssClass="btn" OnClick="btnSearch_Click" />
					</span>
                    <span style="float: right;">
						清理
						<asp:TextBox ID="txtDayCount" runat="server" Width="50" MaxLength="5"></asp:TextBox>
                        天前的日志
						<asp:Button ID="btnClear" runat="server" CssClass="btn" OnClick="btnClear_Click" OnClientClick="return CheckValidate()" Text="清理" />
					</span>
				</td>
            </tr>
        </table>
        <table class="border" cellpadding="0" cellspacing="1" align="center">
            <asp:Repeater ID="repLog" runat="server">
                <HeaderTemplate>
                    <tr class="title">
                        <td width="30px">编号</td>
                        <td width="150px">操作者</td>
                        <td>操作描述</td>
                        <td width="90px">IP地址</td>
                        <td width="120px">操作时间</td>
                        <td width="90px">操作类型</td>
                    </tr>
                </HeaderTemplate>
                <ItemTemplate>
                    <tr class="tdbg" onmouseover="this.className='tdbgmouseover'" onmouseout="this.className='tdbg'">
                        <td><%#Eval("LogId") %></td>
                        <td align="left" style="padding-left: 5px;"><%#Eval("UserName") %></td>
                        <td align="left" style="padding-left: 5px;"><%#Function.HtmlEncode(Eval("Description")) %></td>
                        <td><%#Eval("IpAddress") %></td>
                        <td><%#Eval("LogTime","{0:yyyy-MM-dd HH:mm:ss}") %></td>
                        <td><%#B_Log.GetNameByLogType(Eval("LogType"))%></td>
                    </tr>
                </ItemTemplate>
            </asp:Repeater>
        </table>
        <table cellpadding="0" cellspacing="1" class="border" align="center">
            <tr>
                <td class="wzlist">
                    <webdiyer:AspNetPager ID="Pager" runat="server" AlwaysShow="True" FirstPageText="首页" LastPageText="尾页" NextPageText="下一页" PageSize="20" HorizontalAlign="Right" PrevPageText="上一页" ShowInputBox="Never" ShowCustomInfoSection="Left" Width="99%" OnPageChanging="Pager_PageChanging" LayoutType="Table" CustomInfoSectionWidth="10%"></webdiyer:AspNetPager>
				</td>
            </tr>
        </table>
    </form>
    <asp:Literal ID="litMsg" runat="server"></asp:Literal>
    <br />
</body>
</html>