CKEDITOR.plugins.add('rf_attribute', {
  requires: ['dialog'],
  init: function (editor) {
    var pluginName = 'rf_attribute';
    var iframeId = pluginName + '_' + editor.name;
    //给自定义插件注册一个调用命令
    editor.addCommand(pluginName, new CKEDITOR.dialogCommand(pluginName));
    //注册一个按钮，来调用自定义插件
    editor.ui.addButton(pluginName, {
      label: "表单属性",
      command: pluginName,
      icon: this.path + "attribute.png",
      toolbar: 'rf_plugins,1'
    });
    
    CKEDITOR.dialog.add(pluginName, function (editor) {
     
      return {
        title: '表单属性',
        minWidth: 500,
        minHeight: 399,
        resizable: CKEDITOR.DIALOG_RESIZE_WIDTH,
        contents: [{
          id: pluginName,
          label: '表单属性',
          title: '表单属性',
          elements:
            [
              {
                id: pluginName,
                type: 'html',
                    html: '<iframe id="' + iframeId + '" src="../../../../index.html?loadurl=' + encodeURIComponent('/form/plugins/attr?editorname=' + editor.name) + editor.iframeQueryString + '" style="width:100%;height:399px;border:0;" frameborder="0"></iframe>'
              }
            ]
        }],
        onLoad: function () {
          
        },
        onShow: function () {
          
        },
        onOk: function () {
          
        }
      }
    });

  }
});