CKEDITOR.plugins.add('rf_label', {
    requires: ['dialog'],
    init: function (editor) {
        var pluginName = 'rf_label';
        //给自定义插件注册一个调用命令
        editor.addCommand(pluginName, new CKEDITOR.dialogCommand(pluginName));
        editor.addCommand(pluginName + "_delete", {
            exec: function (editor) {
                CKEDITOR.rf_remove(editor);
            }
        });

        //为文本框双击事件绑定一个事件，即显示弹出窗
        editor.on('doubleclick', function (evt) {
            var element = evt.data.element;
            if (element.is('input')) {
                var type = element.getAttribute('data-type');
                if (type == 'label') {
                    editor.currentSelectEditorElement = element;//保存当前焦点对象 currentSelectEditorElement
                    evt.data.dialog = pluginName;
                }
            }
        });
        //注册一个按钮，来调用自定义插件
        editor.ui.addButton(pluginName, {
            label: "标签(Label)",
            command: pluginName,
            icon: this.path + "label.png",
            toolbar: 'rf_plugins,13'
        });
        if (editor.contextMenu) {
            editor.addMenuGroup('rf_plugins');
            editor.addMenuItem(pluginName, {
                label: 'Label标签属性',
                command: pluginName,
                group: 'rf_plugins'
            });
            editor.addMenuItem(pluginName + '_delete', {
                label: '删除Label标签',
                command: pluginName + '_delete',
                group: 'rf_plugins'
            });

            //右键菜单的监听器，判断是否显示菜单
            editor.contextMenu.addListener(function (element) {
                if (element && !element.isReadOnly()) {
                    var name = element.getName();
                    if (name == 'input') {
                        var type = element.getAttribute('data-type');
                        if (type == 'label') {
                            editor.currentSelectEditorElement = element;//保存当前焦点对象 currentSelectEditorElement
                            return { rf_label: CKEDITOR.TRISTATE_OFF, rf_label_delete: CKEDITOR.TRISTATE_OFF };
                        }
                    }
                }
            });
        }
        CKEDITOR.dialog.add(pluginName, function (editor) {
            return {
                title: 'Label标签',
                minWidth: 600,
                minHeight: 320,
                contents: [{
                    id: pluginName + '_attr',
                    label: '属性',
                    title: '属性',
                    elements:
                        [
                            {
                                id: pluginName + '_attr',
                                type: 'html',
                                html: '<iframe style="width:100%;height:320px;border:0;" frameborder="0" src="../../../../index.html?loadurl=' + encodeURIComponent('/form/plugins/label?editorname=' + editor.name) + editor.iframeQueryString + '"></iframe>'
                            }
                        ]
                },],
                onShow: function () {
                    if (editor.initFunction_label) {
                        editor.initFunction_label(editor.currentSelectEditorElement);
                    }

                },
                onHide: function () {
                    editor.currentSelectEditorElement = null;
                },
                onOk: function () {
                    var json = editor.currentSelectEditorElementJson;
                    if (!json) {
                        return;
                    }
                    var add = false;
                    var input = editor.currentSelectEditorElement;
                    if (!input) {
                        input = editor.document.createElement("input");
                        add = true;
                    }

                    var table = editor.formAttributeJSON.dbTable;
                    var id = (table + "-" + json.field).toUpperCase();
                    input.setAttribute("type", "text");
                    input.setAttribute("data-type", "label");
                    input.setAttribute("data-isflow", "1");
                    input.setAttribute("value", "Label标签(" + json.field + ")");
                    input.setStyle("color", "#999");
                    input.setAttribute("data-id", id);
                    input.setAttribute("data-bindfiled", json.field);
                    input.setAttribute("data-defaultvalue", json.defaultValue);
                    input.setAttribute("data-style", encodeURIComponent(json.style));
                   
                    if (add) {
                        editor.insertElement(input);
                    }
                    editor.currentSelectEditorElement = null;
                }
            }
        });

    }
});