CKEDITOR.plugins.add('rf_organize', {
    requires: ['dialog'],
    init: function (editor) {
        var pluginName = 'rf_organize';
        //给自定义插件注册一个调用命令
        editor.addCommand(pluginName, new CKEDITOR.dialogCommand(pluginName));
        editor.addCommand(pluginName + "_delete", {
            exec: function (editor) {
                CKEDITOR.rf_remove(editor);
            }
        });

        //为文本框双击事件绑定一个事件，即显示弹出窗
        editor.on('doubleclick', function (evt) {
            var element = evt.data.element;
            if (element.is('input')) {
                var type = element.getAttribute('data-type');
                if (type == 'organize') {
                    editor.currentSelectEditorElement = element;//保存当前焦点对象 currentSelectEditorElement
                    evt.data.dialog = pluginName;
                }
            }
        });
        //注册一个按钮，来调用自定义插件
        editor.ui.addButton(pluginName, {
            label: "组织架构选择",
            command: pluginName,
            icon: this.path + "organize.png",
            toolbar: 'rf_plugins,9'
        });
        if (editor.contextMenu) {
            editor.addMenuGroup('rf_plugins');
            editor.addMenuItem(pluginName, {
                label: '组织架构属性',
                command: pluginName,
                group: 'rf_plugins'
            });
            editor.addMenuItem(pluginName + '_delete', {
                label: '删除组织架构',
                command: pluginName + '_delete',
                group: 'rf_plugins'
            });

            //右键菜单的监听器，判断是否显示菜单
            editor.contextMenu.addListener(function (element) {
                if (element && !element.isReadOnly()) {
                    var name = element.getName();
                    if (name == 'input') {
                        var type = element.getAttribute('data-type');
                        if (type == 'organize') {
                            editor.currentSelectEditorElement = element;//保存当前焦点对象 currentSelectEditorElement
                            return { rf_organize: CKEDITOR.TRISTATE_OFF, rf_organize_delete: CKEDITOR.TRISTATE_OFF };
                        }
                    }
                }
            });
        }
        CKEDITOR.dialog.add(pluginName, function (editor) {
            return {
                title: '组织架构',
                minWidth: 600,
                minHeight: 350,
                contents: [{
                    id: pluginName + '_attr',
                    label: '属性',
                    title: '属性',
                    elements:
                        [
                            {
                                id: pluginName + '_attr',
                                type: 'html',
                                html: '<iframe style="width:100%;height:350px;border:0;" frameborder="0" src="../../../../index.html?loadurl=' + encodeURIComponent('/form/plugins/organize?editorname=' + editor.name) + editor.iframeQueryString + '"></iframe>'
                            }
                        ]
                }, {
                    id: pluginName + '_events',
                    label: '事件',
                    title: '事件',
                    elements:
                        [
                            {
                                id: pluginName + '_events',
                                type: 'html',
                                html: '<iframe style="width:100%;height:350px;border:0;" frameborder="0" src="../../../../index.html?loadurl=' + encodeURIComponent('/form/plugins/event?editorname=' + editor.name) + editor.iframeQueryString + '"</iframe>'
                            }
                        ]
                }],
                onShow: function () {
                    if (editor.initFunction_organize) {
                        editor.initFunction_organize(editor.currentSelectEditorElement);
                    }
                    if (editor.initFunction_initEvent) {
                        editor.initFunction_initEvent();
                    }
                },
                onHide: function () {
                    editor.currentSelectEditorElement = null;
                },
                onOk: function () {
                    var json = editor.currentSelectEditorElementJson;
                    if (!json) {
                        return;
                    }
                    var add = false;
                    var input = editor.currentSelectEditorElement;
                    if (!input) {
                        input = editor.document.createElement("input");
                        add = true;
                    }

                    var table = editor.formAttributeJSON.dbTable;
                    var id = (table + "-" + json.field).toUpperCase();
                    input.setAttribute("type", "text");
                    input.setAttribute("data-type", "organize");
                    input.setAttribute("data-isflow", "1");
                    input.setAttribute("value", "组织架构(" + json.field + ")");
                    input.setStyle("color", "#999");
                    input.setAttribute("data-id", id);
                    input.setAttribute("data-bindfiled", json.field);
                    input.setAttribute("data-defaultvalue", json.defaultValue) || '';
                    input.setAttribute("data-width", json.width) || '';
                    input.setAttribute("data-height", json.height) || '';
                    input.setAttribute("data-placeholder", json.placeholder) || '';
                    input.setAttribute("data-multiple", json.multiple) || '0';
                    input.setAttribute("data-selecttype", json.selectType) || '';
                    input.setAttribute("data-selectroot", json.selectRoot) || '0';
                    input.setAttribute("data-selectrange", json.selectRange) || '';
                    input.setAttribute("data-root", json.root) || '';

                    if (json.width) {
                        input.setStyle("width", json.width);
                    } else {
                        input.setStyle("width", '');
                    }

                    if (add) {
                        editor.insertElement(input);
                    }
                    editor.currentSelectEditorElement = null;
                }
            }
        });

    }
});