CKEDITOR.plugins.add('rf_preview', {
    requires: ['dialog'],
    init: function (editor) {
        var pluginName = 'rf_preview';
        //给自定义插件注册一个调用命令
        editor.addCommand(pluginName, new CKEDITOR.dialogCommand(pluginName));
        
        //注册一个按钮，来调用自定义插件
        editor.ui.addButton(pluginName, {
            label: "预览表单",
            command: pluginName,
            icon: this.path + "preview.png",
            toolbar: 'rf_plugins1,1'
        });

        CKEDITOR.dialog.add(pluginName, function (editor) {
            return {
                title: '预览表单',
                minWidth: 1180,
                minHeight: 580,
                contents: [{
                    id: pluginName + '_attr',
                    label: '表单',
                    title: '表单',
                    elements:
                        [
                            {
                                id: pluginName + '_attr',
                                type: 'html',
                                html: '<iframe style="width:100%;height:580px;border:0;" frameborder="0" src="../../../../index.html?loadurl=' + encodeURIComponent('/form/plugins/preview?editorname=' + editor.name) + editor.iframeQueryString + '"></iframe>'
                            }
                        ]
                }],
                onShow: function () {
                    //var attJSON = editor.formAttributeJSON;
                    //var eventJSON = editor.formEventsJSON;
                    //var subtableJSON = editor.formSubtabsJSON;
                    //var html = editor.getData();
                    //var previewHtml = editor.designjs.compile(attJSON, eventJSON, html);
                    //editor['previewHtml'] = previewHtml;
                    if (editor.initFunction_preview) {
                        editor.initFunction_preview();
                    }
                },
                onHide: function () {
                    //editor.currentSelectEditorElement = null;
                    //editor['previewHtml'] = '';
                },
                onOk: function () {
                    //editor.currentSelectEditorElement = null;
                    //editor['previewHtml'] = '';
                }
            }
        });
    }
});