CKEDITOR.plugins.add('rf_saveas', {
    requires: ['dialog'],
    init: function (editor) {
        var pluginName = 'rf_saveas';
        //给自定义插件注册一个调用命令
        editor.addCommand(pluginName, new CKEDITOR.dialogCommand(pluginName));
        //editor.addCommand(pluginName + "_delete", {
        //    exec: function (editor) {
        //        CKEDITOR.rf_remove(editor);
        //    }
        //});

        
        //注册一个按钮，来调用自定义插件
        editor.ui.addButton(pluginName, {
            label: "表单另存为",
            command: pluginName,
            icon: this.path + "saveas.png",
            toolbar: 'rf_plugins1,3'
        });
        
        CKEDITOR.dialog.add(pluginName, function (editor) {
            return {
                title: '表单另存为',
                minWidth: 500,
                minHeight: 200,
                contents: [{
                    id: pluginName + '_attr',
                    label: '表单另存为',
                    title: '表单另存为',
                    elements:
                        [
                            {
                                id: pluginName + '_attr',
                                type: 'html',
                                html: '<iframe style="width:100%;height:200px;border:0;" frameborder="0" src="../../../../index.html?loadurl=' + encodeURIComponent('/form/plugins/saveas?editorname=' + editor.name) + editor.iframeQueryString + '"></iframe>'
                            }
                        ]
                }],
                onShow: function () {
                    
                },
                onHide: function () {
                    
                },
                onOk: function () {
                    //var attrJSON = formAttributeJSON;
                    //if (!attrJSON) {
                    //    alert("未找到表单属性!");
                    //    return false;
                    //}
                    //var $iframe = $("div[name='" + pluginName + "_attr'] iframe");
                    //if ($iframe.size() == 0) {
                    //    return;
                    //}
                    //var doc = $iframe.get(0).contentWindow.document;
                    //var formName = $("#formname", doc).val() || '';
                    //if ($.trim(formName).length == 0) {
                    //    alert('表单名称不能为空!');
                    //    return false;
                    //}
                    //$.ajax({
                    //    url: "../FormDesignerPlugin/SaveAs1?" + query, type: "post", data: { "id": attrJSON.id, "formname": $.trim(formName) }, dataType: "json", cache: false, async: false, success: function (json) {
                    //        alert(json.message);
                    //        return json.success === 1;
                    //    }
                    //});
                    var attJSON = editor.formAttributeJSON;
                    if (!attJSON) {
                        alert("未找到表单属性！");
                        return false;
                    }
                    if (!editor["SaveAsName"]) {
                        alert('另存为的表单名称不能为空！');
                        return false;
                    }
                    editor._vue.ajax.post('/Form/SaveAs?1=1' + editor.iframeQueryString, editor._vue.qs.stringify({ id: attJSON.id, name: editor["SaveAsName"] })).then(function (data) {
                        alert(data.msg);
                        return data.success;
                    });
                }
            }
        });

    }
});