CKEDITOR.plugins.add('rf_switch', {
    requires: ['dialog'],
    init: function (editor) {
        var pluginName = 'rf_switch';
        //给自定义插件注册一个调用命令
        editor.addCommand(pluginName, new CKEDITOR.dialogCommand(pluginName));
        editor.addCommand(pluginName + "_delete", {
            exec: function (editor) {
                CKEDITOR.rf_remove(editor);
            }
        });

        //为双击事件绑定一个事件，即显示弹出窗
        editor.on('doubleclick', function (evt) {
            var element = evt.data.element;
            if (element.is('input')) {
                var type = element.getAttribute('type') || 'text';
                if (type == 'text' && 'switch' == element.getAttribute('data-type')) {
                    editor.currentSelectEditorElement = element;//保存当前焦点对象 currentSelectEditorElement
                    evt.data.dialog = pluginName;
                }
            }
        });
        //注册一个按钮，来调用自定义插件
        editor.ui.addButton(pluginName, {
            label: "开关(switch)",
            command: pluginName,
            icon: this.path + "switch.png",
            toolbar: 'rf_plugins,7'
        });
        if (editor.contextMenu) {
            editor.addMenuGroup('rf_plugins');
            editor.addMenuItem(pluginName, {
                label: '开关属性',
                command: pluginName,
                group: 'rf_plugins'
            });
            editor.addMenuItem(pluginName + '_delete', {
                label: '删除开关',
                command: pluginName + '_delete',
                group: 'rf_plugins'
            });

            //右键菜单的监听器，判断是否显示菜单
            editor.contextMenu.addListener(function (element) {
                if (element && !element.isReadOnly()) {
                    var name = element.getName();
                    if (name == 'input') {
                        var type = element.getAttribute('type');
                        if (type == 'text' && 'switch' == element.getAttribute('data-type')) {
                            editor.currentSelectEditorElement = element;//保存当前焦点对象 currentSelectEditorElement在index1.jsp中定义
                            return { rf_switch: CKEDITOR.TRISTATE_OFF, rf_switch_delete: CKEDITOR.TRISTATE_OFF };
                        }
                    }
                }
            });
        }
        CKEDITOR.dialog.add(pluginName, function (editor) {
            return {
                title: '开关',
                minWidth: 600,
                minHeight: 350,
                contents: [{
                    id: pluginName + '_attr',
                    label: '属性',
                    title: '属性',
                    elements:
                        [
                            {
                                id: pluginName + '_attr',
                                type: 'html',
                                html: '<iframe style="width:100%;height:350px;border:0;" frameborder="0" src="../../../../index.html?loadurl=' + encodeURIComponent('/form/plugins/switch?editorname=' + editor.name) + editor.iframeQueryString + '"></iframe>'
                            }
                        ]
                }, {
                    id: pluginName + '_events',
                    label: '事件',
                    title: '事件',
                    elements:
                        [
                            {
                                id: pluginName + '_events',
                                type: 'html',
                                html: '<iframe style="width:100%;height:350px;border:0;" frameborder="0" src="../../../../index.html?loadurl=' + encodeURIComponent('/form/plugins/event?editorname=' + editor.name) + editor.iframeQueryString + '"></iframe>'
                            }
                        ]
                }],
                onShow: function () {
                    if (editor.initFunction_switch) {
                        editor.initFunction_switch(editor.currentSelectEditorElement);
                    }
                    if (editor.initFunction_initEvent) {
                        editor.initFunction_initEvent();
                    }
                },

                onHide: function () {
                    editor.currentSelectEditorElement = null;
                },
                onOk: function () {
                    var json = editor.currentSelectEditorElementJson;
                    if (!json) {
                        return;
                    }
                    var add = false;
                    var input = editor.currentSelectEditorElement;
                    if (!input) {
                        input = editor.document.createElement("input");
                        add = true;
                    }
    
                    var table = editor.formAttributeJSON.dbTable;
                    var id = (table + "-" + json.field).toUpperCase();
                    input.setAttribute("type", "text");
                    input.setAttribute("data-type", "switch");
                    input.setAttribute("value", "开关(" + json.field + ")");
                    input.setStyle("color", "#999");
                    input.setAttribute("data-id", id);
                    input.setAttribute("data-bindfiled", json.field);
                    input.setAttribute("data-defaultvalue", json.defaultValue);
                    input.setAttribute("data-on", json.on||'');
                    input.setAttribute("data-off", json.off || '');
                    input.setAttribute("data-ontitle", json.ontitle || '');
                    input.setAttribute("data-offtitle", json.offtitle || '');
                    input.setAttribute("data-isflow", "1");

                    if (add) {
                        editor.insertElement(input);
                    }
                    editor.currentSelectEditorElement = null;

                }
            }
        });
    }
});