CKEDITOR.plugins.add('rf_text', {
    requires: ['dialog'],
    init: function (editor) {
        var pluginName = 'rf_text';
        //给自定义插件注册一个调用命令
        editor.addCommand(pluginName, new CKEDITOR.dialogCommand(pluginName));
        editor.addCommand(pluginName + "_delete", {
            exec: function (editor) {
                CKEDITOR.rf_remove(editor);
            }
        });

        //为文本框双击事件绑定一个事件，即显示弹出窗
        editor.on('doubleclick', function (evt) {
            var element = evt.data.element;
            if (element.is('input')) {
                var type = element.getAttribute('type') || 'text';
                if (type == 'text' && 'text' == element.getAttribute('data-type')) {
                    editor.currentSelectEditorElement = element;//保存当前焦点对象 currentSelectEditorElement
                    evt.data.dialog = pluginName;
                }
            }
        });
        //注册一个按钮，来调用自定义插件
        editor.ui.addButton(pluginName, {
            label: "文本框(text)",
            command: pluginName,
            icon: this.path + "text.png",
            toolbar: 'rf_plugins,2'
        });
        if (editor.contextMenu) {
            editor.addMenuGroup('rf_plugins');
            editor.addMenuItem(pluginName, {
                label: '文本框属性',
                command: pluginName,
                group: 'rf_plugins'
            });
            editor.addMenuItem(pluginName + '_delete', {
                label: '删除文本框',
                command: pluginName + '_delete',
                group: 'rf_plugins'
            });

            //右键菜单的监听器，判断是否显示菜单
            editor.contextMenu.addListener(function (element) {
                if (element && !element.isReadOnly()) {
                    var name = element.getName();
                    if (name == 'input') {
                        var type = element.getAttribute('type');
                        if (type == 'text' && 'text' == element.getAttribute('data-type')) {
                            editor.currentSelectEditorElement = element;//保存当前焦点对象 currentSelectEditorElement
                            return { rf_text: CKEDITOR.TRISTATE_OFF, rf_text_delete: CKEDITOR.TRISTATE_OFF };
                        }
                    }
                }
            });
        }
        CKEDITOR.dialog.add(pluginName, function (editor) {
            return {
                title: '文本框',
                minWidth: 600,
                minHeight: 350,
                contents: [{
                    id: pluginName + '_attr',
                    label: '属性',
                    title: '属性',
                    elements:
                        [
                            {
                                id: pluginName + '_attr',
                                type: 'html',
                                html: '<iframe style="width:100%;height:350px;border:0;" frameborder="0" src="../../../../index.html?loadurl=' + encodeURIComponent('/form/plugins/text?editorname=' + editor.name) + editor.iframeQueryString + '"></iframe>'
                            }
                        ]
                }, {
                    id: pluginName + '_events',
                    label: '事件',
                    title: '事件',
                    elements:
                        [
                            {
                                id: pluginName + '_events',
                                type: 'html',
                                html: '<iframe style="width:100%;height:350px;border:0;" frameborder="0" src="../../../../index.html?loadurl=' + encodeURIComponent('/form/plugins/event?editorname=' + editor.name) + editor.iframeQueryString + '"></iframe>'
                            }
                        ]
                }],
                onShow: function () {
                    if (editor.initFunction_text) {
                        editor.initFunction_text(editor.currentSelectEditorElement);
                    }
                    if (editor.initFunction_initEvent) {
                        editor.initFunction_initEvent();
                    }
                },

                onHide: function () {
                    editor.currentSelectEditorElement = null;
                },
                onOk: function () {
                    var json = editor.currentSelectEditorElementJson;
                    if (!json) {
                        return;
                    }
                    var add = false;
                    var input = editor.currentSelectEditorElement;
                    if (!input) {
                        input = editor.document.createElement("input");
                        add = true;
                    }
                    
                    var table = editor.formAttributeJSON.dbTable;
                    var id = (table + "-" + json.field).toUpperCase();
                    input.setAttribute("type", "text");
                    input.setAttribute("data-type", "text");
                    input.setAttribute("value", "文本框(" + json.field + ")");
                    input.setStyle("color", "#999");
                    input.setAttribute("data-id", id);
                    input.setAttribute("data-bindfiled", json.field);
                    input.setAttribute("data-defaultvalue", json.defaultValue);
                    input.setAttribute("data-width", json.width);
                    input.setAttribute("data-align", json.align);
                    input.setAttribute("data-readonly", json.readOnly);
                    input.setAttribute("data-maxlength", json.maxLength);
                    input.setAttribute("data-placeholder", json.placeholder);
                    input.setAttribute("data-inputtype", json.inputType);
                    input.setAttribute("data-valuetype", json.valueType);
                    input.setAttribute("data-format", json.format);
                    input.setAttribute("data-isflow", "1");

                    if ("ajax" == json.valueType) {
                        input.setAttribute("data-ajaxurl", encodeURIComponent(json.ajaxurl))
                    }
                    if (json.width) {
                        input.setStyle("width", json.width);
                    } else {
                        input.setStyle("width", '');
                    }
                   
                    if (add) {
                        editor.insertElement(input);
                    }
                    editor.currentSelectEditorElement = null;

                }
            }
        });
    }
});