CKEDITOR.plugins.add('rf_textarea', {
    requires: ['dialog'],
    init: function (editor) {
        var pluginName = 'rf_textarea';
        //给自定义插件注册一个调用命令
        editor.addCommand(pluginName, new CKEDITOR.dialogCommand(pluginName));
        editor.addCommand(pluginName + "_delete", {exec: function (editor) {
            CKEDITOR.rf_remove(editor);
        }});

        //为文本框双击事件绑定一个事件，即显示弹出窗
        editor.on('doubleclick', function (evt) {
            var element = evt.data.element;
            if (element.is('textarea') && 'textarea' == element.getAttribute('data-type')) {
                editor.currentSelectEditorElement = element;//保存当前焦点对象 currentSelectEditorElement
                evt.data.dialog = pluginName;
            }
        });
        //注册一个按钮，来调用自定义插件
        editor.ui.addButton(pluginName, {
            label: "文本域(textarea)",
            command: pluginName,
            icon: this.path + "textarea.png",
            toolbar: 'rf_plugins,3'
        });
        if (editor.contextMenu) {
            editor.addMenuGroup('rf_plugins');
            editor.addMenuItem('rf_textarea', {
                label: '文本域属性',
                command: pluginName,
                group: 'rf_plugins'
            });
            editor.addMenuItem(pluginName + '_delete', {
                label: '删除文本域',
                command: pluginName + '_delete',
                group: 'rf_plugins'
            });

            //右键菜单的监听器，判断是否显示菜单
            editor.contextMenu.addListener(function (element) {
                if (element && !element.isReadOnly()) {
                    var name = element.getName();
                    if (name == 'textarea' && 'textarea' == element.getAttribute('data-type')) {
                        editor.currentSelectEditorElement = element;//保存当前焦点对象 currentSelectEditorElement
                        return {rf_textarea: CKEDITOR.TRISTATE_OFF, rf_textarea_delete: CKEDITOR.TRISTATE_OFF};
                    }
                }
            });
        }
        CKEDITOR.dialog.add(pluginName, function (editor) {
            return {
                title: '文本域',
                minWidth: 600,
                minHeight: 370,
                contents: [{
                    id: pluginName + '_attr',
                    label: '属性',
                    title: '属性',
                    elements:
                        [
                            {
                                id: pluginName + '_attr',
                                type: 'html',
                                html: '<iframe style="width:100%;height:370px;border:0;" frameborder="0" src="../../../../index.html?loadurl=' + encodeURIComponent('/form/plugins/textarea?editorname=' + editor.name) + editor.iframeQueryString + '"></iframe>'
                            }
                        ]
                }, {
                    id: pluginName + '_events',
                    label: '事件',
                    title: '事件',
                    elements:
                        [
                            {
                                id: pluginName + '_events',
                                type: 'html',
                                html: '<iframe style="width:100%;height:370px;border:0;" frameborder="0" src="../../../../index.html?loadurl=' + encodeURIComponent('/form/plugins/event?editorname=' + editor.name) + editor.iframeQueryString + '"></iframe>'
                            }
                        ]
                }],
                onShow: function () {
                    if (editor.initFunction_textarea) {
                        editor.initFunction_textarea(editor.currentSelectEditorElement);
                    }
                    if (editor.initFunction_initEvent) {
                        editor.initFunction_initEvent();
                    }
                },
                onHide: function () {
                    editor.currentSelectEditorElement = null;
                },
                onOk: function () {
                    var json = editor.currentSelectEditorElementJson;
                    if (!json) {
                        return;
                    }
                    var add = false;
                    var input = editor.currentSelectEditorElement;
                    if (!input) {
                        input = editor.document.createElement("textarea");
                        add = true;
                    }
                    var table = editor.formAttributeJSON.dbTable;
                    var id = (table + "-" + json.field).toUpperCase();
                    input.setAttribute("data-type", "textarea");
                    input.setText("文本域(" + json.field + ")");
                    input.setStyle("color", "#999");
                    input.setAttribute("data-id", id);
                    input.setAttribute("data-bindfiled", json.field);
                    input.setAttribute("data-defaultvalue", json.defaultValue);
                    input.setAttribute("data-placeholder", json.placeholder);
                    input.setAttribute("data-valuetype", json.valueType);
                    input.setAttribute("data-format", json.format);
                    input.setAttribute("data-height", json.height);
                    input.setAttribute("data-width", json.width);
                    input.setAttribute("data-maxlength", json.maxLength);
                    input.setAttribute("data-isflow", "1");
                    
                    if ("ajax" == json.valueType) {
                        input.setAttribute("data-ajaxurl", encodeURIComponent(json.ajaxurl))
                    }
                    if (json.width.length > 0) {
                        input.setStyle("width", isNaN(json.width) ? json.width : parseInt(json.width).toString() + 'px');
                    } else {
                        input.setStyle("width", '');
                    }
                    if (json.height.length > 0) {
                        input.setStyle("height", isNaN(json.height) ? json.height : parseInt(json.height).toString() + 'px');
                    } else {
                        input.setStyle("height", '');
                    }
                    if (add) {
                        editor.insertElement(input);
                    }
                    editor.currentSelectEditorElement = null;
                }
            }
        });
    }
});