﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="MomentsViewMain.ascx.cs" Inherits="DreamerShop.Mobile.TPM1.MomentsViewMain" %>
<%@ Register TagPrefix="uc1" TagName="LanguagesDeal" Src="../../LanguagesManage.ascx" %>
<uc1:LanguagesDeal ID="myLanguagesDeal" runat="server" Visible="False"></uc1:LanguagesDeal>
<!DOCTYPE html>
<html>
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no, minimal-ui" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <meta name="apple-mobile-web-app-status-bar-style" content="black" />
    <meta name="format-detection" content="telephone=no, email=no" />
    <meta charset="UTF-8">
    <title><%=myLanguagesDeal.GetMyString("TextMoments")%></title>
    <link rel="stylesheet" href="TPM8/themes/css/core.css">
    <link rel="stylesheet" href="TPM8/themes/css/icon.css">
    <link rel="stylesheet" href="TPM8/themes/css/home.css">
    <link rel="stylesheet" type="text/css" href="../madmin/css/hui.css" />
    <link rel="stylesheet" href="../madmin/css/icofont/iconfont.css">
	 <script type="text/javascript" src="/cfcss/hui.js"></script>
	 <script src="http://res.wx.qq.com/open/js/jweixin-1.0.0.js"></script>
	 <script>
        wx.config({
            debug: false, // 开启调试模式,调用的所有api的返回值会在客户端alert出来，若要查看传入的参数，可以在pc端打开，参数信息会通过log打出，仅在pc端时才会打印。
            appId: '<%=mstrAppId%>', // 必填，公众号的唯一标识
            timestamp: '<%=mstrTimeStamp %>', // 必填，生成签名的时间戳
            nonceStr: '<%=mstrNonceStr %>', // 必填，生成签名的随机串
            signature: '<%=mstrSign %>', // 必填，签名
            jsApiList: [
                    'checkJsApi',
                    'onMenuShareTimeline',
                    'onMenuShareAppMessage',
                    'onMenuShareQQ',
                    'onMenuShareWeibo',
                    'hideMenuItems',
                    'showMenuItems',
                    'hideAllNonBaseMenuItem',
                    'showAllNonBaseMenuItem',
                    'translateVoice',
                    'startRecord',
                    'stopRecord',
                    'onRecordEnd',
                    'playVoice',
                    'pauseVoice',
                    'stopVoice',
                    'uploadVoice',
                    'downloadVoice',
                    'chooseImage',
                    'previewImage',
                    'uploadImage',
                    'downloadImage',
                    'getNetworkType',
                    'openLocation',
                    'getLocation',
                    'hideOptionMenu',
                    'showOptionMenu',
                    'closeWindow',
                    'scanQRCode',
                    'chooseWXPay',
                    'openProductSpecificView',
                    'addCard',
                    'chooseCard',
                    'openCard'
            ] // 必填，需要使用的JS接口列表，所有JS接口列表见附录2。详见：http://mp.weixin.qq.com/wiki/7/aaa137b55fb2e0456bf8dd9148dd613f.html
        });

        wx.error(function (res) {
            console.log(res);
           
        });

        wx.ready(function () {
            var url = 'https://m.dreamershop.com/';
            var link = '<%=mstrShareUrl %>';
            var imgUrl = '<%=mstrShareImg %>';

            //转发到朋友圈
            wx.onMenuShareTimeline({
                title: '<%=mstrShareTitle %>',
                link: link,
                imgUrl: imgUrl,
                success: function () {
                    
                },
                cancel: function () {
                    
                }
            });
            //转发给朋友
            wx.onMenuShareAppMessage({
                title: '<%=mstrShareTitle %>',
                desc: '<%=mstrShareDesc %>',
                link: link,
                imgUrl: imgUrl,
                type: 'link',
                dataUrl: '',
                success: function () {
                    
                },
                cancel: function () {
                    
                }
            });
        });
    </script>
</head>
<body>

    <header class="aui-header-default aui-header-fixed ">
        <a href="Moments.aspx" class="aui-header-item"><i class="aui-icon aui-icon-back"></i></a>
        <div class="aui-header-center aui-header-center-clear">
            <div class="aui-header-center-logo">
                <div class=""><%=myLanguagesDeal.GetMyString("TextMoments")%></div>
            </div>
        </div>
        <span class="aui-header-item-icon" style="min-width: 0"></span>
    </header>
    <div class="hui-wrap">

        <div class="hui-title" style="padding: 50px 8px;">
            <%=mMomentsInf.Title %>
        </div>
        <div>
            <div class="hui-more">发表时间：<%=mMomentsInf.AddTime.ToString("yyyy/MM/dd") %>  &nbsp; 阅读：<%=mMomentsInf.VisitCount %> &nbsp;&nbsp;</div>
        </div>
        <%
            int intI;

            if (mMomentsInf.TitleImage != null && mMomentsInf.TitleImage != "")
            {
                Response.Write("<div class='hui-img-list' style='padding: 10px 3px;'>");
                Response.Write("<ul>");
                Response.Write("<li>");

                Response.Write("<img src='" + getImageUrl(mMomentsInf.TitleImage) + "' />");

                Response.Write("</li>");

                Response.Write("</ul>");
                Response.Write("</div>");
            }

            if (mMomentsInf.ItemArr != null)
            {
                for (intI = 0; intI < mMomentsInf.ItemArr.Length; intI++)
                {
                    if (mMomentsInf.ItemArr[intI].ItemType == 1)
                    {
                        if (mMomentsInf.ItemArr[intI].FileUrl != null && mMomentsInf.ItemArr[intI].FileUrl != "")
                        {
                            Response.Write("<div class='hui-img-list' style='padding: 10px 3px;'>");
                            Response.Write("<ul>");
                            Response.Write("<li>");

                            Response.Write("<img src='" + getImageUrl(mMomentsInf.ItemArr[intI].FileUrl) + "' />");

                            Response.Write("</li>");

                            Response.Write("</ul>");
                            Response.Write("</div>");
                        }
                    }

                    if (mMomentsInf.ItemArr[intI].ItemType == 2)
                    {
                        if (mMomentsInf.ItemArr[intI].FileUrl != null && mMomentsInf.ItemArr[intI].FileUrl != "")
                        {
                            Response.Write("<div class='hui-img-list' style='padding: 10px 3px;'>");
                            Response.Write("<ul>");
                            Response.Write("<li>");

                            Response.Write("<video src='" + getImageUrl(mMomentsInf.ItemArr[intI].FileUrl) + "' controls='controls' width='100%'></video>");

                            Response.Write("</li>");

                            Response.Write("</ul>");
                            Response.Write("</div>");
                        }
                    }

                    if (mMomentsInf.ItemArr[intI].ItemType == 3)
                    {
                        if (mMomentsInf.ItemArr[intI].ItemContent != null && mMomentsInf.ItemArr[intI].ItemContent != "")
                        {
                            Response.Write("<div class='hui-content' style='padding: 5px;'>");
                            Response.Write("<p>");
                            Response.Write(mMomentsInf.ItemArr[intI].ItemContent);
                            Response.Write("</p>");
                            Response.Write("</div>");
                        }
                    }
                }
            }
        %>


        <div class="line"></div>
        <div style="border-bottom: 1px solid #E3E3E3;"></div>
         
        <form id="Form1" method="post" runat="server">
            <asp:Label ID="lbEditID" runat="server" Visible="false"></asp:Label>
			<asp:Label ID="lbReplyTemp" runat="server" Visible="false"><div style="padding-top: 5px; border-bottom: 1px solid #E3E3E3;"></div><div style="padding-top: 5px; color: #999999"> 作者 </div> <div style="padding-top: 5px">(reply)</div></asp:Label>
            <asp:ScriptManager ID="ScriptManager1" runat="server">
            </asp:ScriptManager>
            <asp:UpdatePanel ID="UpdatePanel1" runat="server">
                <ContentTemplate>
                    <div class="hui-media-list" style="padding: 10px;">
                        <ul>
                            <asp:DataGrid ID="dgList" runat="server" DataKeyField="ReviewID"
                                PageSize="20" AllowPaging="false" AutoGenerateColumns="False" OnItemCommand="dgList_ItemCommand" BorderWidth="0" ShowHeader="false" ItemStyle-BorderWidth="0" ShowFooter="false"  Width="100%" >
                                <ItemStyle BorderWidth="0" ></ItemStyle>
                                <Columns>
                                    <asp:TemplateColumn HeaderText="TextOperation">

                                        <ItemTemplate>

                                            <li>

                                                <div style="width: 10%">
                                                    <img src="<%# DataBinder.Eval(Container.DataItem, "HeadImage") %>" />
                                                </div>
                                                <div style="padding-left: 10px; width: 90%">
                                                    <div style="padding-top: 5px; color: #999999">
                                                        <%# DataBinder.Eval(Container.DataItem, "WeixinName") %>
                                                        <div class="hui-more">
                                                            <asp:LinkButton ID="lkbUp" runat="server" CausesValidation="False" CommandName="Up" runat="server" CssClass="icon iconfont"> &#xe60c;<%# DataBinder.Eval(Container.DataItem, "UpCount") %></asp:LinkButton>
                                                        </div>
                                                    </div>
                                                    <div style="padding-top: 5px"><%# DataBinder.Eval(Container.DataItem, "ReviewContent") %></div>

                                                    <%# DataBinder.Eval(Container.DataItem, "ReplyContent") %>
                                                </div>

                                            </li>
                                        </ItemTemplate>
                                    </asp:TemplateColumn>
                                </Columns>
                                <PagerStyle Visible="False" NextPageText="下一页" PrevPageText="上一页" HorizontalAlign="Right"></PagerStyle>
                            </asp:DataGrid>

                            

                        </ul>
                    </div>
                    <asp:Panel ID="PanReview" runat="server" Visible="true">
                        <div class="hui-form-items">
                            <div class="hui-form-items-title">&nbsp;我的留言</div>
                            <div class="hui-form-textarea">

                                <textarea id="txtContent" runat="server" placeholder=" "></textarea>
                            </div>
                        </div>
                        <div style="padding: 10px; float: right;">
                            <asp:Button ID="btSubmit" runat="server" CssClass="hui-button hui-button-small hui-primary hui-fl" Text=" 提 交 " OnClick="btSubmit_Click"></asp:Button>
                        </div>
                    </asp:Panel>
                    <%if (btMyReview.Visible)
                        { %>
                    <div style="padding: 10px; float: right;">
                        <asp:Button ID="btMyReview" runat="server" CssClass="hui-button hui-button-small hui-primary hui-fl" Text=" 我要留言 " OnClick="btMyReview_Click"></asp:Button>
                    </div>
                    <%} %>
                </ContentTemplate>
            </asp:UpdatePanel>
        </form>
        <br />
        <br />

        <div class="line"></div>
        <div class="line"></div>
    </div>
    <script type="text/javascript" src="TPM8/themes/js/jquery.min.js"></script>
    <script type="text/javascript" src="TPM8/themes/js/aui.js"></script>
</body>
</html>
